/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     screen.c                                                       *
 *            Funktionen zur Bildschirmausgabe und Palettenauswahl           *
 * Autor:     Andreas Tille                                                  *
 * Datum:     23.02.1998                                                     *
 * Changes:   19.03.1998: Imlib nur zur Darstellung, Laden der Dateien       *
 *                        mittels kopiertem load.c aus Imlib                 *
 *                                                                           *
 *****************************************************************************/

#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>

#include "paul.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

int SHOW_SLOW = 1;

int ApplyPicture(GdkWindow *win, PICTURE *bild)
/* Display image
 * --- Parameter: ---
 * GdkWindow *win           : window to draw in
 * PICTURE   *bild          : image to display
 * --- return: ---
 * int        ApplyPicture(): if OK 0, else -1
 */
{
   GdkPixmap *pp /*, *m */;
   int        x, y;

   if ( !win || !bild ) return -1;
   
   if ( SHOW_SLOW ) gdk_window_get_size(win, &x, &y);
   if ( !gdk_imlib_render(bild->im, bild->W, bild->H) ) return -1;
   pp     = gdk_imlib_move_image(bild->im);
   /* m=gdk_imlib_move_mask(bild->im);                  Mask */
   gdk_window_set_back_pixmap(win, pp, 0);

/* If there was a mask to the image, set the Image's mask to it
   if (m) gdk_window_shape_combine_mask(win,m,0,0);   */

   if ( SHOW_SLOW ) if ( x != bild->W || y != bild->H ) gdk_window_resize(win, bild->W, bild->H);
   gdk_window_clear(win);
   gdk_imlib_free_pixmap(pp);
   if ( SHOW_SLOW ) gdk_window_set_title(win, bild->file);
   gdk_window_show(win);
   gdk_flush();
/* printf("%s(%i) ApplyPicture(%s)\n", __FILE__, __LINE__, bild->file);*/
   return 0;
}

void GrowPic(GdkWindow *win, PICTURE *bild)
/* Increase picture size (after pressing "+")
 * --- Parameter: ---
 * GdkWindow *win  : Bildfenster
 * PICTURE   *bild : Bildstruktur
 */
{
  
   register int tw, th;
   int      w, h;
   
   gdk_window_get_size(win, &w, &h);
   tw = (int)((w << 2) / 3);
   th = bild->W; /* Geschwindigkeit! */
   if (tw > gdk_screen_width() << 1 || tw > th << 4 ) {
      gdk_beep();
      return;
   }
   if ( abs(tw - th) < (int)(th / 5) ) {
      tw = th;
      th = bild->H;
   }
   else th = (int)((h << 2) / 3);
   
   gdk_window_resize(win, tw, th);   
   printf("Vergrert auf %ix%i\n", tw, th);
}

void ShrinkPic(GdkWindow *win, PICTURE *bild)
/* Schrumpfen eines Bildes (nach drcken von "-")
 * --- Parameter: ---
 * GdkWindow *win  : Bildfenster
 * PICTURE   *bild : Bildstruktur
 */
{
   register int tw, th;
   int      w, h;
   
   gdk_window_get_size(win, &w, &h);
   tw = (3*w) >> 2;
   th = bild->W; /* Geschwindigkeit! */
   if (tw < 10 || tw < th >> 4 ) {
      gdk_beep();
      return;
   }
   if ( abs(tw - th) < (int)(th / 5) ) {
      tw = th;
      th = bild->H;
   }
   else th = (3*h) >> 2;
   
   gdk_window_resize(win, tw, th);   
   printf("Verkleinert auf %ix%i\n", tw, th);
}






