
from Gtkinter import *
from gnome.ui import *
from gnome.zvt import *
import os, marshal, struct
import sys

import bdb

class Pipe:
	"""This simple class is a wrapper for fork that sets up a two way
	communication channel for use between the two processes.  The
	protocol is a single integer, indicating the size of the object,
	followed by the object in marshalled form"""
	_size = struct.calcsize('l')
	def __init__(self, fork=os.fork):
		to_child = os.pipe()   # (rdr, wrtr)
		from_child = os.pipe()
		pid = fork()
		if pid < 0:
			raise RuntimeError, "fork failed"
		if pid:
			# parent
			os.close(to_child[0])
			os.close(from_child[1])
			self.instream = os.fdopen(from_child[0], "r")
			self.outstream = os.fdopen(to_child[1], "w", 0)
		else:
			# child
			os.close(to_child[1])
			os.close(from_child[0])
			self.outstream = os.fdopen(from_child[1], "w", 0)
			self.instream  = os.fdopen(to_child[0], "r")
		self.pid = pid
	def __del__(self):
		self.close()
	def read(self):
		size_str = self.instream.read(self._size)
		if len(size_str) != self._size:
			raise IOError, "couldn't read correct number of bytes"
		size = struct.unpack('l', size_str)[0]
		buf = self.instream.read(size)
		if len(buf) != size:
			raise IOError, "couldn't read correct number of bytes"
		return marshal.loads(buf)
	def write(self, obj):
		buf = marshal.dumps(obj)
		self.outstream.write(struct.pack('l', len(buf)))
		self.outstream.write(buf)
	def close(self):
		self.instream.close()
		self.outstream.close()
		if self.pid:
			os.kill(self.pid, 9)
			os.wait(self.pid)
			self.pid = 0

class OutSource:
	def __init__(self, klass, *args):
		self.channel = Pipe()
		if self.channel.pid == 0:
			self.child = apply(klass, args)
			self.__requestloop()
	def __requestloop(self):
		while 1:
			type, name, args = self.channel.read()
			

class ParentDb:
	def __init__(self, pipe):
		self.pipe = pipe
	def execute(self, *args):
		self.pipe.write(args)
		return self.pipe.read()

class ChildDb(bdb.Bdb):
	def __init__(self, pipe):
		bdb.Bdb.__init__(self)
		self.pipe = pipe

	def reset(self):
		bdb.Bdb.reset(self)
		self.forget()
	def forget(self):
		self.lineno = None
		self.stack = []
		self.curindex = 0
		self.curframe = None
		self.cont_exec = 0 # set to break out of interaction loop
	def setup(self, f, t):
		self.forget()
		self.stack, self.curindex = self.get_stack(f, t)
		self.curframe = self.stack[self.curindex][0]

	def user_line(self, frame):
		self.interaction(frame, None)
	def user_return(self, frame, return_value):
		frame.f_locals['__return__'] = return_value
		self.interaction(frame, None)
	def user_exception(self, frame, (exc_type, exc_value, exc_traceback)):
		frame.f_locals['__exception__'] = exc_type, exc_value
		self.interaction(frame, exc_traceback)
	def interaction(self, frame, traceback):
		self.setup(frame, traceback)
		while not self.cont_exec:
			try:
				obj = self.pipe.read()
			except IOError:
				self.set_quit()
				break
			func = getattr(self, obj[0])
			ret = apply(func, obj[1:])
			self.pipe.write(ret)
		self.forget()
	def do_next(self):
		self.set_next(self.curframe)
		self.cont_exec = 1
	def do_step(self):
		self.set_step()
		self.cont_exec = 1
	def do_return(self):
		self.set_return(self.curframe)
		self.cont_exec = 1
	def do_continue(self):
		self.set_continue()
		self.cont_exec = 1
	def do_quit(self):
		self.set_quit()
		self.cont_exec = 1

def debug(statement, fork=os.fork):
	pipe = Pipe(fork=fork)
	if pipe.pid == 0:
		child = ChildDb(pipe)
		child.run(statement)
		sys.exit(0)
	else:
		parent = ParentDb(pipe)
		return parent

class FE(GtkVBox):
	def __init__(self):
		GtkVBox.__init__(self)
		button = GtkButton("Next")
		button.connect("clicked", self.clicked)
		self.pack_start(button, expand=FALSE)
		button.show()

		self.zvt = ZvtTerm()
		self.zvt.set_scrollback(50)
		self.zvt.set_font_name("-misc-fixed-medium-r-normal--12-200-75-75-c-100-*-*")
		self.pack_start(self.zvt)
		self.zvt.show()
	def run(self, prog):
		self.com = debug(prog, fork=self.zvt.forkpty)
	def clicked(self, _b):
		self.com.execute('do_next')

def make_client():
	pipe = Pipe()
	if pipe.pid == 0:
		while 1:
			try:
				obj = pipe.read()
			except IOError: raise SystemExit
			print `obj`
	else:
		return pipe

if __name__ == '__main__':
	win = GtkWindow()
	win.connect("destroy", mainquit)
	dbg = FE()
	win.add(dbg)
	dbg.show()
	win.show()
	idle_add(lambda dbg=dbg: dbg.run('execfile("tmp.py")'))

	mainloop()
