%module _gnome

%{
#include "libgnome/libgnome.h"
#include "libgnome/gnome-history.h"
#include "libgnome/gnome-fileconvert.h"
/* #include "libgnome/gnome-mime.h" */
%}

/* libgnome.h */
void gnomelib_init(char *app_id);

/* gnome-config.h */
char *gnome_config_get_string(char *path);
char *gnome_config_get_translated_string(char *path);
int gnome_config_get_int(char *path);
double gnome_config_get_float(char *path);
int gnome_config_get_bool(char *path);
char *gnome_config_private_get_string(char *path);
char *gnome_config_private_get_translated_string(char *path);
int gnome_config_private_get_int(char *path);
double gnome_config_private_get_float(char *path);
int gnome_config_private_get_bool(char *path);
%{
static PyObject *gnome__config_get_vector(PyObject *self, PyObject *args) {
  char *path;
  int argc, i;
  char **argv;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "s:gnome_config_get_vector", &path))
    return NULL;
  gnome_config_get_vector(path, &argc, &argv);
  ret = PyTuple_New(argc);
  for (i = 0; i < argc; i++)
    PyTuple_SetItem(ret, i, PyString_FromString(argv[i]));
  return ret;
}
static PyObject *gnome__config_private_get_vector(PyObject *self,
						  PyObject *args) {
  char *path;
  int argc, i;
  char **argv;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "s:gnome_config_private_get_vector", &path))
    return NULL;
  gnome_config_private_get_vector(path, &argc, &argv);
  ret = PyTuple_New(argc);
  for (i = 0; i < argc; i++)
    PyTuple_SetItem(ret, i, PyString_FromString(argv[i]));
  return ret;
}
%}
%native(gnome_config_get_vector) PyObject *gnome__config_get_vector(
					PyObject *self, PyObject *args);
%native(gnome_config_private_get_vector) PyObject *
  gnome__config_private_get_vector(PyObject *self, PyObject *args);
void gnome_config_set_string(char *path, char *value);
void gnome_config_set_translated_string(char *path, char *value);
void gnome_config_set_int(char *path, int value);
void gnome_config_set_float(char *path, double value);
void gnome_config_set_bool(char *path, int value);
void gnome_config_private_set_string(char *path, char *value);
void gnome_config_private_set_translated_string(char *path, char *value);
void gnome_config_private_set_int(char *path, int value);
void gnome_config_private_set_float(char *path, double value);
void gnome_config_private_set_bool(char *path, int value);
%{
static PyObject *gnome__config_set_vector(PyObject *self, PyObject *args) {
  char *path;
  PyObject *seq, *item;
  int argc, i;
  char **argv;
  if (!PyArg_ParseTuple(args, "sO:gnome_config_set_vector", &path, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "second argument not a sequence");
    return NULL;
  }
  argc = PySequence_Length(seq);
  argv = g_new(char *, argc);
  for (i = 0; i < argc; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(argv);
      return NULL;
    }
    argv[i] = PyString_AsString(item);
  }
  gnome_config_set_vector(path, argc, (const char **)argv);
  g_free(argv);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__config_private_set_vector(PyObject *self,
						  PyObject *args) {
  char *path;
  PyObject *seq, *item;
  int argc, i;
  char **argv;
  if (!PyArg_ParseTuple(args, "sO:gnome_config_private_set_vector", &path,
			&seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "second argument not a sequence");
    return NULL;
  }
  argc = PySequence_Length(seq);
  argv = g_new(char *, argc);
  for (i = 0; i < argc; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(argv);
      return NULL;
    }
    argv[i] = PyString_AsString(item);
  }
  gnome_config_private_set_vector(path, argc, (const char **)argv);
  g_free(argv);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_config_set_vector) PyObject *gnome__config_set_vector(
					PyObject *self, PyObject *args);
%native(gnome_config_private_set_vector) PyObject *
  gnome__config_private_set_vector(PyObject *self, PyObject *args);
int gnome_config_has_section(char *path);
int gnome_config_private_has_section(char *path);
%{
static PyObject *gnome_config_section_contents(PyObject *self,PyObject *args) {
  char *path, *key, *value;
  void *iterator;
  PyObject *ret;
  
  if (!PyArg_ParseTuple(args, "s:gnome_config_section_contents", &path))
    return NULL;
  iterator = gnome_config_init_iterator(path);
  ret = PyDict_New();
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, &value);
    PyDict_SetItemString(ret, key, PyString_FromString(value));
  }
  return ret;
}
static PyObject *gnome_config_enum_sections(PyObject *self, PyObject *args) {
  char *path, *key;
  void *iterator;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "s:gnome_config_enum_sections", &path))
    return NULL;
  iterator = gnome_config_init_iterator_sections(path);
  ret = PyList_New(0);
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, NULL);
    PyList_Append(ret, PyString_FromString(key));
  }
  return ret;
}
static PyObject *gnome_config_private_section_contents(PyObject *self,
						       PyObject *args) {
  char *path, *key, *value;
  void *iterator;
  PyObject *ret;
  
  if (!PyArg_ParseTuple(args, "s:gnome_config_private_section_contents",&path))
    return NULL;
  iterator = gnome_config_private_init_iterator(path);
  ret = PyDict_New();
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, &value);
    PyDict_SetItemString(ret, key, PyString_FromString(value));
  }
  return ret;
}
static PyObject *gnome_config_private_enum_sections(PyObject *self,
						    PyObject *args) {
  char *path, *key;
  void *iterator;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "s:gnome_config_private_enum_sections", &path))
    return NULL;
  iterator = gnome_config_private_init_iterator_sections(path);
  ret = PyList_New(0);
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, NULL);
    PyList_Append(ret, PyString_FromString(key));
  }
  return ret;
}
%}
%native(gnome_config_section_contents) PyObject *gnome_config_section_contents(
					PyObject *self, PyObject *args);
%native(gnome_config_enum_sections) PyObject *gnome_config_enum_sections(
					PyObject *self, PyObject *args);
%native(gnome_config_private_section_contents) PyObject *
  gnome_config_private_section_contents(PyObject *self, PyObject *args);
%native(gnome_config_private_enum_sections) PyObject *
  gnome_config_private_enum_sections(PyObject *self, PyObject *args);
void gnome_config_drop_all();
void gnome_config_sync();
void gnome_config_clean_file(char *path);
void gnome_config_private_clean_file(char *path);
void gnome_config_clean_section(char *path);
void gnome_config_private_clean_section(char *path);
void gnome_config_clean_key(char *path);
void gnome_config_private_clean_key(char *path);
void gnome_config_push_prefix(char *path);
void gnome_config_pop_prefix();

/* gnome-fileconvert.h */
%{
static PyObject *gnome_file_convert_stream(PyObject *self, PyObject *args) {
  PyObject *in_file;
  int fd, out_fd;
  char *fromtype, *totype;
  FILE *fp;

  if (!PyArg_ParseTuple(args, "O!ss:gnome_file_convert_stream", &PyFile_Type,
			&in_file, &fromtype, &totype))
    return NULL;
  fd = fileno(PyFile_AsFile(in_file));
  out_fd = gnome_file_convert_fd(fd, fromtype, totype);
  if (fd < 0 || (fp = fdopen(out_fd, "rb")) == NULL) {
    PyErr_SetString(PyExc_IOError, "can't make conversion");
    return NULL;
  }
  return PyFile_FromFile(fp, "<conversion>", "rb", fclose);
}
static PyObject *gnome__file_convert(PyObject *self, PyObject *args) {
  char *filename, *fromtype, *totype;
  int fd;
  FILE *fp;
  if (!PyArg_ParseTuple(args, "sss:gnome_file_convert", &filename, &fromtype,
			&totype))
    return NULL;
  fd = gnome_file_convert(filename, fromtype, totype);
  if (fd < 0 || (fp = fdopen(fd, "rb")) == NULL) {
    PyErr_SetString(PyExc_IOError, "can't make conversion");
    return NULL;
  }
  return PyFile_FromFile(fp, "<conversion>", "rb", fclose);
}
%}
%native(gnome_file_convert_stream) PyObject *gnome_file_convert_stream(
					PyObject *self, PyObject *args);
%native(gnome_file_convert) PyObject *gnome__file_convert(PyObject *self,
							  PyObject *args);

/* gnome-help.h */
%{
static PyObject *gnome__help_file_find_file(PyObject *self, PyObject *args) {
  char *app, *path, *ret;
  PyObject *py_ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_help_file_find_file", &app, &path))
    return NULL;
  ret = gnome_help_file_find_file(app, path);
  py_ret = PyString_FromString(ret);
  g_free(ret);
  return py_ret;
}
static PyObject *gnome__help_file_path(PyObject *self, PyObject *args) {
  char *app, *path, *ret;
  PyObject *py_ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_help_file_path", &app, &path))
    return NULL;
  ret = gnome_help_file_path(app, path);
  py_ret = PyString_FromString(ret);
  g_free(ret);
  return py_ret;
}
static PyObject *gnome__help_display(PyObject *self, PyObject *args) {
  GnomeHelpMenuEntry ref;
  if (!PyArg_ParseTuple(args, "ss:gnome_help_display", &(ref.name),
			&(ref.path)))
    return NULL;
  gnome_help_display(NULL, &ref);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__help_goto(PyObject *self, PyObject *args) {
  char *file;
  if (!PyArg_ParseTuple(args, "s:gnome_help_goto", &file))
    return NULL;
  gnome_help_goto(NULL, file);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_help_file_path) PyObject *gnome__help_file_path(PyObject *self,
							      PyObject *args);
%native(gnome_help_file_find_file) PyObject *gnome__help_file_find_file(
					PyObject *self, PyObject *args);
%native(gnome_help_display) PyObject *gnome__help_display(PyObject *self,
							  PyObject *args);
%native(gnome_help_goto) PyObject *gnome__help_goto(PyObject *self,
						    PyObject *args);

/* gnome-history.h */
void gnome_history_recently_used(char *filename, char *filetype,
				 char *creator, char *desc);
%{
static PyObject *gnome__history_get_recently_used(PyObject *self,
						 PyObject *args) {
  GList *list;
  PyObject *py_list;
  GnomeHistoryEntry entry;
  if (!PyArg_ParseTuple(args, ":gnome_history_get_recently_used"))
    return NULL;
  list = gnome_history_get_recently_used();
  py_list = PyList_New(0);
  while (list) {
    entry = list->data;
    PyList_Append(py_list, Py_BuildValue("(ssss)", entry->filename,
					 entry->filetype, entry->creator,
					 entry->desc));
    list = g_list_next(list);
  }
  gnome_history_free_recently_used_list(list);
  return py_list;
}
%}
%native(gnome_history_get_recently_used) PyObject *
        gnome__history_get_recently_used(PyObject *self, PyObject *args);

/* gnome-metadata.h */
%{
/* translate return value */
static PyObject *metadata_set_ret(int retval) {
  if (retval == GNOME_METADATA_IO_ERROR) {
    PyErr_SetString(PyExc_IOError, "low-level communications/storage error");
    return NULL;
  } else if (retval == GNOME_METADATA_NOT_FOUND) {
    PyErr_SetString(PyExc_KeyError, "metadata attribute not found");
    return NULL;
  } else {
    Py_INCREF(Py_None);
    return Py_None;
  }
}
static PyObject *gnome__metadata_set(PyObject *self, PyObject *args) {
  char *file, *key, *value;
  int vallen;
  if (!PyArg_ParseTuple(args, "sss#:gnome_metadata_set", &file, &key, &value,
			&vallen))
    return NULL;
  return metadata_set_ret(gnome_metadata_set(file, key, vallen, value));
}
static PyObject *gnome__metadata_remove(PyObject *self, PyObject *args) {
  char *file, *key;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_remove", &file, &key))
    return NULL;
  return metadata_set_ret(gnome_metadata_remove(file, key));
}
static PyObject *gnome__metadata_list(PyObject *self, PyObject *args) {
  char *file, **ret, **tmp;
  PyObject *list;
  if (!PyArg_ParseTuple(args, "s:gnome_metadata_list", &file))
    return NULL;
  ret = gnome_metadata_list(file);
  list = PyList_New(0);
  for (tmp = ret; *tmp != NULL; tmp++)
    PyList_Append(list, PyString_FromString(*tmp));
  gnome_string_array_free(ret);
  return list;
}
static PyObject *gnome__metadata_get(PyObject *self, PyObject *args) {
  char *file, *key, *value;
  int valuelen;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_get", &file, &key))
    return NULL;
  ret = metadata_set_ret(gnome_metadata_get(file, key, &valuelen, &value));
  if (ret == NULL) return NULL;
  Py_DECREF(ret);
  ret = PyString_FromStringAndSize(value, valuelen);
  g_free(value);
  return ret;
}
static PyObject *gnome__metadata_get_fast(PyObject *self, PyObject *args) {
  char *file, *key, *value;
  int valuelen;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_get_fast", &file, &key))
    return NULL;
  ret = metadata_set_ret(gnome_metadata_get_fast(file, key, &valuelen,&value));
  if (ret == NULL) return NULL;
  Py_DECREF(ret);
  ret = PyString_FromStringAndSize(value, valuelen);
  g_free(value);
  return ret;
}
static PyObject *gnome__metadata_rename(PyObject *self, PyObject *args) {
  char *file, *to;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_rename", &file, &to))
    return NULL;
  return metadata_set_ret(gnome_metadata_rename(file, to));
}
static PyObject *gnome__metadata_copy(PyObject *self, PyObject *args) {
  char *file, *to;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_copy", &file, &to))
    return NULL;
  return metadata_set_ret(gnome_metadata_copy(file, to));
}
static PyObject *gnome__metadata_delete(PyObject *self, PyObject *args) {
  char *file;
  if (!PyArg_ParseTuple(args, "s:gnome_metadata_delete", &file))
    return NULL;
  return metadata_set_ret(gnome_metadata_delete(file));
}
static PyObject *gnome__metadata_regex_add(PyObject *self, PyObject *args) {
  char *regex, *key, *value;
  int vallen;
  if (!PyArg_ParseTuple(args, "sss#:gnome_metadata_regex_add", &regex, &key,
			&value, &vallen))
    return NULL;
  gnome_metadata_regex_add(regex, key, vallen, value);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__metadata_regex_remove(PyObject *self, PyObject *args) {
  char *regex, *key;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_regex_remove", &regex, &key))
    return NULL;
  gnome_metadata_regex_remove(regex, key);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__metadata_type_add(PyObject *self, PyObject *args) {
  char *type, *key, *value;
  int vallen;
  if (!PyArg_ParseTuple(args, "sss#:gnome_metadata_type_add", &type, &key,
			&value, &vallen))
    return NULL;
  gnome_metadata_type_add(type, key, vallen, value);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__metadata_type_remove(PyObject *self, PyObject *args) {
  char *type, *key;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_type_remove", &type, &key))
    return NULL;
  gnome_metadata_type_remove(type, key);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_metadata_set) PyObject *gnome__metadata_set(
					PyObject *self, PyObject *args);
%native(gnome_metadata_remove) PyObject *gnome__metadata_remove(
					PyObject *self, PyObject *args);
%native(gnome_metadata_list) PyObject *gnome__metadata_list(
					PyObject *self, PyObject *args);
%native(gnome_metadata_get) PyObject *gnome__metadata_get(
					PyObject *self, PyObject *args);
%native(gnome_metadata_get_fast) PyObject *gnome__metadata_get_fast(
					PyObject *self, PyObject *args);
%native(gnome_metadata_rename) PyObject *gnome__metadata_rename(
					PyObject *self, PyObject *args);
%native(gnome_metadata_copy) PyObject *gnome__metadata_copy(
					PyObject *self, PyObject *args);
%native(gnome_metadata_delete) PyObject *gnome__metadata_delete(
					PyObject *self, PyObject *args);
%native(gnome_metadata_regex_add) PyObject *gnome__metadata_regex_add(
					PyObject *self, PyObject *args);
%native(gnome_metadata_regex_remove) PyObject *gnome__metadata_regex_remove(
					PyObject *self, PyObject *args);
%native(gnome_metadata_type_add) PyObject *gnome__metadata_type_add(
					PyObject *self, PyObject *args);
%native(gnome_metadata_type_remove) PyObject *gnome__metadata_type_remove(
					PyObject *self, PyObject *args);

/* gnome-mime.h */

//void gnome_mime_init();
char *gnome_mime_type(char *filename);
char *gnome_mime_type_or_default(char *filename, char *ddef);
// gnome_mime_default_entry
// gnome_mime_entries
char *gnome_mime_program(char *mime_type);
char *gnome_mime_description(char *mime_type);
char *gnome_mime_nametemplate(char *mime_type);
char *gnome_mime_test(char *mime_type);
char *gnome_mime_composetyped(char *mime_type);
int gnome_mime_copiousoutput(char *mime_type);
int gnome_mime_needsterminal(char *mime_type);


/* gnome_score.h */
int gnome_score_init(char *gamename);
%{
static PyObject *gnome__score_log(PyObject *self, PyObject *args) {
  double score;
  char *level = NULL;
  int high_to_low;
  if (!PyArg_ParseTuple(args, "fzi:gnome_score_log", &score, &level,
			&high_to_low))
    return NULL;
  return PyInt_FromLong(gnome_score_log(score, level, high_to_low));
}
static PyObject *gnome__score_get_notable(PyObject *self, PyObject *args) {
  char *gamename = NULL, *level = NULL, **names;
  gfloat *scores;
  time_t *scoretimes;
  PyObject *ret;
  int len, i;
  if (!PyArg_ParseTuple(args, "zz:gnome_score_get_notable", &gamename, &level))
    return NULL;
  len = gnome_score_get_notable(gamename, level, &names, &scores, &scoretimes);
  ret = PyList_New(len);
  for (i = 0; i < len; i++) {
    PyList_SetItem(ret, i, Py_BuildValue("(sfi)", names[i], scores[i],
					 scoretimes[i]));
    g_free(names[i]);
  }
  g_free(names);
  g_free(scores);
  g_free(scoretimes);
  return ret;
}
%}
%native(gnome_score_log) PyObject *gnome__score_log(PyObject *self,
						    PyObject *args);
%native(gnome_score_get_notable) PyObject *gnome__score_get_notable(
					PyObject *self, PyObject *args);

/* gnome-triggers.h */
void gnome_triggers_init();
int gnome_triggers_readfile(char *filename);
%{
static PyObject *gnome__triggers_add_trigger(PyObject *self, PyObject *args) {
  int len, i;
  struct _GnomeTrigger nt;
  PyObject *two, *supinf, *item;
  char **supinfo;

  if (!PyArg_ParseTuple(args, "iOsO:gnome_triggers_add_trigger", &(nt.type),
			&two, &(nt.level), &supinf))
    return NULL;
  switch (nt.type) {
  case GTRIG_NONE:
    break;
  /*GTRIG_FUNCTION:*/
  case GTRIG_COMMAND:
    if (!PyString_Check(two)) {
      PyErr_SetString(PyExc_TypeError, "second arg not a string");
      return NULL;
    }
    nt.u.command = PyString_AsString(two);
    break;
  case GTRIG_MEDIAPLAY:
    if (!PyString_Check(two)) {
      PyErr_SetString(PyExc_TypeError, "second arg not a string");
      return NULL;
    }
    nt.u.mediafile = PyString_AsString(two);
    break;
  default:
    PyErr_SetString(PyExc_TypeError, "unsupported trigger type");
    return NULL;
  }
  if (!PySequence_Check(supinf)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(supinf);
  supinfo = g_new(char *, len+1);
  supinfo[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(supinf, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(supinfo);
      return NULL;
    }
    supinfo[i] = PyString_AsString(item);
  }
  gnome_triggers_vadd_trigger(&nt, supinfo);
  g_free(supinfo);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__triggers_do(PyObject *self, PyObject *args) {
  PyObject *supinf, *item;
  int len, i;
  char *msg, *level, **supinfo;

  if (!PyArg_ParseTuple(args, "ssO:gnome_triggers_do", &msg, &level, &supinf))
    return NULL;
  if (!PySequence_Check(supinf)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(supinf);
  supinfo = g_new(char *, len+1);
  supinfo[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(supinf, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(supinfo);
      return NULL;
    }
    supinfo[i] = PyString_AsString(item);
  }
  gnome_triggers_vdo(msg, level, supinfo);
  g_free(supinfo);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_triggers_add_trigger) PyObject *gnome__triggers_add_trigger(
					PyObject *self, PyObject *args);
%native(gnome_triggers_do) PyObject *gnome__triggers_do(PyObject *self,
							PyObject *args);
