""" Demonstration of the Pmw ScrolledListBox megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create and pack the ScrolledListBox.
	self.box = Pmw.ScrolledListBox(parent,
		listbox_selectmode='single',
		items=('Sydney', 'Melbourne', 'Brisbane'),
		label_text='Cities',
		labelpos='nw',
		vscrollmode = 'static',
		selectioncommand=self.selectionCommand,
		dblclickcommand=self.defCmd)
	self.box.pack(fill = 'both', expand = 'yes', padx = 10, pady = 10)

	items = ('AndaMooka', 'Coober Pedy', 'Innamincka', 'Oodnadatta')
	self.box.setlist(items)

	self.box.insert(2, 'Wagga Wagga', 'Perth')
	self.box.insert('end', 'Darwin')
	index = list(self.box.get(0, 'end')).index('Wagga Wagga')
	self.box.delete(index)
	self.box.delete(6, 7)
	self.box.insert('end', 'Bulli', 'Alice Springs')
	apply(self.box.insert, ('end',) + tuple(range(10)))

    def selectionCommand(self):
	sels = self.box.getcurselection()
	if len(sels) == 0:
	    print 'No selection'
	else:
	    print 'Selection:', sels[0]

    def defCmd(self):
	sels = self.box.getcurselection()
	if len(sels) == 0:
	    print 'No selection for double click'
	else:
	    print 'Double click:', sels[0]

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw ScrolledListBox demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
