/* $Id: visual.c,v 1.11 1998/10/18 15:52:33 becka Exp $
***************************************************************************

   Graphics library for GGI. Generic RAMDAC via IOCTL driver

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>

#ifdef _AIX
#include <sys/types.h>
#include <unistd.h>
#endif

#include <ggi/internal/ggi-dl.h>
#include <kgi/ioctl.h>

int GGIdlinit(ggi_visual *vis, const char *version,void *argptr)
{
	int err;

	DPRINT("generic-ramdac: Init.\n");

	if ((GT_SCHEME(LIBGGI_GT(vis)) != GT_TRUECOLOR) &&
	    (GT_DEPTH(LIBGGI_GT(vis)) > 8)) {
		fprintf(stderr, "generic-ramdac: too many colors (%d)\n",
			1 << GT_DEPTH(LIBGGI_GT(vis)));
		return -1;
	}

#if 0  /* default colormap ??? */
	{
		ggi_color testmap[256];

		err=_ggiSendKGICommand(vis, (int)RAMDAC_GETCLUT, testmap);

		if (err<0) {
			fprintf(stderr,"generic-ramdac: Can't get "
				"default colormap\n");
			return -1;
		}
	}
#endif
		
#if 0  /* rely on generic-color */
	visual->opcolor->getpalvec=GGIgetpalvec;
#endif
	visual->opcolor->setpalvec=GGIsetpalvec;

	return GGI_DL_OPCOLOR;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
