/* 
 *  rectangle drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

static void	drawRect(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2)
{
	GGI2D_FUNC(vis)->hLine(vis, x1, x2, y1);
	GGI2D_FUNC(vis)->vLine(vis, x1, y1, y2);
	GGI2D_FUNC(vis)->hLine(vis, x1, x2, y2);
	GGI2D_FUNC(vis)->vLine(vis, x2, y1, y2);
}

static void	drawRect_st(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2)
{
	int	append = GGI2D_GC_APPEND(vis);
	if (!append)	ggi2dSetAppendMode(vis, 1);
	drawRect(vis, x1, y1, x2, y2);
	if (!append)	ggi2dSetAppendMode(vis, 0);
}

void	GGIEXP(fillRect)(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2)
{
	ggi_sint	y;
	void 	(*scanline)(ggi_visual_t, ggi_sint, ggi_sint, ggi_sint) 
		= GGI2D_FUNC(vis)->scanline;
    
	CLIPRECT(vis, x1, y1, x2, y2, y);
	for (y = y1; y <= y2; y++)
		scanline(vis, x1, x2, y);
}

void	(*GGIEXP(drawRect)[2])(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2) =
{
	drawRect,
	drawRect_st
};

/*----------------------------------------------------------------------*/
