/*
 * Written by J.T. Conklin <jtc@netbsd.org>.
 * Public domain.
 */

#include <machine/asm.h>

RCSID("$NetBSD: s_log1p.S,v 1.7 1995/05/09 00:10:58 jtc Exp $")

#ifdef __ELF__
	.section .rodata
#else
	.text
#endif
	.align ALIGNARG(4)
	/* The fyl2xp1 can only be used for values in
		-1 + sqrt(2) / 2 <= x <= 1 - sqrt(2) / 2
	   0.29 is a safe value.
	*/
limit:	.double 0.29
one:	.double 1.0

/*
 * Use the fyl2xp1 function when the argument is in the range -0.29 to 0.29,
 * otherwise fyl2x with the needed extra computation.
 */
	.text
ENTRY(__log1p)
	fldln2

	fldl	4(%esp)

#ifdef	PIC
	call	1f
1:	popl	%edx
	addl	$_GLOBAL_OFFSET_TABLE_+[.-1b], %edx
#endif

	fld	%st
	fabs
#ifdef PIC
	fcompl	limit@GOTOFF(%edx)
#else
	fcompl	limit
#endif
	fnstsw
	sahf
	jc	2f

#ifdef PIC
	faddl	one@GOTOFF(%edx)
#else
	faddl	one
#endif
	fyl2x
	ret

2:	fyl2xp1
	ret

END (__log1p)
weak_alias (__log1p, log1p)
