#include <Xm/BulletinB.h>
#include <Xm/ComboBoxP.h>
#include <Xm/PushB.h>

#if !defined(CB_List)
#define CB_List(w) \
        (((XmComboBoxWidget)(w))->combo_box.list)
#endif

/* This test sees how the combobox insert child routine handles 
   adding one child.

   RESULT: This test exposes a bug with the OSF/Motif 2.0 
   combobox.  The insert child routine should spit out an error
   but instead puts the push button at position 0,0 in the combobox.  
   This is probably because the child widget count is still at three.  
   Also, this tells us the layout routine only handles the textfield and 
   the scrolled window only and does not loop through its child list when
   doing the layout.  Run test3 to see the error it should spit
   out.
 */

int
main(int argc, char **argv)
{
  Widget toplevel, widget, bb, list, label, push;
  XtAppContext app;
  XmString item;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "ComBox", NULL, 0, &argc, argv, NULL, NULL);

  bb = XmCreateBulletinBoard(toplevel, "bb", NULL, 0);
  XtManageChild(bb);

  widget = XmCreateComboBox(bb, "combo", NULL, 0);

  /* add a push button to the combobox */
  push = XmCreatePushButton(widget, "push", NULL, 0);
  XtManageChild(push);

  /* use list routine to add items */
  list = CB_List(widget);

  item = XmStringCreateSimple("Item 1");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 2");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 3");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 4");
  XmListAddItem(list,item,0);
  item = XmStringCreateSimple("Item 5");
  XmListAddItem(list,item,0);

  XmComboBoxUpdate(widget);

  XtManageChild(widget);

  XtRealizeWidget(toplevel);

  XtAppMainLoop(app);

  exit(0);
}
