/*   cn3dopen.c
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*            National Center for Biotechnology Information (NCBI)
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government do not place any restriction on its use or reproduction.
*  We would, however, appreciate having the NCBI and the author cited in
*  any work or product based on this material
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
* ===========================================================================
*
* File Name:  cn3dopen.c
*
* Author:  Christopher Hogue
*
* Version Creation Date:   1/31/96
*
* $Revision: 6.14 $
*
* File Description: Cn3d file opening routines 
*                   
*
* Modifications:  
* --------------------------------------------------------------------------
* Date     Name        Description of modification
* -------  ----------  -----------------------------------------------------
* $Log: cn3dopen.c,v $
* Revision 6.14  1998/05/27 22:15:16  ywang
* add Cn3dObjRegister() to several places
*
 * Revision 6.13  1998/05/18  22:09:14  ywang
 * move codes around
 *
 * Revision 6.12  1998/05/12  21:47:05  lewisg
 * stricter conservation coloring
 *
* Revision 6.11  1998/05/12 16:34:01  ywang
* take strucseq mime data
*
 * Revision 6.10  1998/05/06  23:50:24  lewisg
 * fixed launching problem with sequin
 *
* Revision 6.9  1998/05/06 14:20:09  lewisg
* get rid of NULL structure bugs
*
* Revision 6.8  1998/04/28 22:47:21  lewisg
* master/slave color in sync
*
* Revision 6.7  1998/04/28 19:40:01  lewisg
* codewarrior fixes
*
* Revision 6.6  1998/04/28 19:38:39  lewisg
* codewarrior fixes
*
* Revision 6.5  1998/04/28 18:53:25  ywang
* take NcbiMimeAsn1_alignseq to view alignment only
*
 * Revision 6.4  1998/04/28  15:20:37  kans
 * cast needed on FileGets for CodeWarrior
 *
* Revision 6.3  1998/04/28 15:14:29  lewisg
* moved OpenMimeFileWithDeletion to cn3dopen
*
* Revision 6.2  1998/04/27 23:23:06  lewisg
* added ability to open mime files
*
* Revision 6.1  1998/04/16 00:32:25  lewisg
* corrected neighbor mode bugs
*
* Revision 6.0  1997/08/25 18:13:38  madden
* Revision changed to 6.0
*
* Revision 5.0  1996/05/28 14:05:44  ostell
* Set to revision 5.0
*
 * Revision 1.5  1996/04/18  17:01:10  hogue
 * Fixed calls to FetchBS for later integration into Entrez, added feature to turn off redundant backbone model for faster spinning...
 *
 * Revision 1.4  1996/03/30  23:41:01  hogue
 * Redraw now saves camera
 *
 * Revision 1.3  1996/03/29  20:01:24  hogue
 * Added call to reset active structure upon opening.
 *
 * Revision 1.2  1996/02/02  19:40:19  hogue
 * Initial Revision
 *
*
* ==========================================================================
*/

#include <vibrant.h>
#include <math.h>
#include <mmdbapi.h>
#include <objmime.h>
#include <accentr.h>
#include <objalign.h>
#include <objseq.h>
#include <objmgr.h>
#include <sequtil.h>
#include <saledit.h>
#include <lsqfetch.h>
#include <cn3dopen.h>
#include <cn3dmain.h>
#include <algorend.h>
#include <cn3dmsg.h>



static Boolean  Cn3D_Open_InUse = FALSE;
static WindoW	Cn3D_wNetOpen;
static TexT     Cn3D_tOpen;
static GrouP	Cn3D_gAccType;
static ButtoN	Cn3D_bOpenAccept;
static GrouP	Cn3D_gMdlLvl;
static GrouP	Cn3D_gMdlNo;

static WindoW   Cn3D_wOpen;
static ButtoN	Cn3D_bOpenBrowse;
static GrouP	Cn3D_gBinAscii;

Boolean viewalign_only = FALSE;

Boolean OpenMimeFileWithDeletion(CharPtr filename, Boolean removeIt)
{
  Boolean retval = FALSE;
  BiostrucFeaturePtr pbsfThis;
  ChemGraphAlignmentPtr pcgaSlave;
  ChemGraphPntrsPtr pcgpThis;
  ValNodePtr pvnThis = NULL;
  ValNodePtr pvnListMaster = NULL, pvnListSlave = NULL;
  PMSD  pmsdSlave = NULL, pmsdMaster = NULL;
  PDNMS pdnmsMaster = NULL, pdnmsSlave = NULL;
  PFB   pfbMaster = NULL, pfbSlave = NULL;
  BiostrucAlignSeqPtr pbsasThis = NULL;
  SeqAnnotPtr sap = NULL;
  SeqAlignPtr salp = NULL;

  WatchCursor();

  do {{ /* TRY */
    AsnIoPtr aip;
    Char buf[50];
    CharPtr title;
    NcbiMimeAsn1Ptr mime;
    EntrezGeneralPtr egp;
    BiostrucAlignPtr pbsaThis;
    BiostrucSeqPtr   bssp;
    PDNMS pdnms = NULL;
    PMSD  pmsdThis = NULL;
    PDNML pdnmlThis = NULL;
    PMLD  pmldThis = NULL;
    PMLD  pmldOne = NULL;
    PMLD  pmldAll = NULL;
    ValNodePtr pvnAlignment;
    PDNTRN pdnTransform = NULL;
    PARS parsThis;
    BiostrucPtr pbsThis;



    FILE *fp = FileOpen(filename, "r");
    if ( !fp )
      break; /* THROW */

    FileRead(buf, 1, StrLen(PRINT_FORM_MIME_NAME), fp);
    FileClose( fp );
    if (StrNCmp(buf, PRINT_FORM_MIME_NAME, StrLen(PRINT_FORM_MIME_NAME)) == 0)
      aip = AsnIoOpen(filename, "r");
    else
      aip = AsnIoOpen(filename, "rb");
    if ( !aip ) break; /* THROW */

    mime = NcbiMimeAsn1AsnRead(aip, NULL);
    AsnIoClose( aip );
    if (!mime ) break; /* THROW */
    switch (mime->choice) {
      
    case NcbiMimeAsn1_entrez:
      egp = (EntrezGeneralPtr)mime->data.ptrvalue;
      if (!egp  ||  !egp->Data_data) break; /* THROW */
      
      retval = TRUE;
      title = egp->title ? egp->title : "MIME Display";
      switch ( egp->Data_data->choice )
      {
      case Data_data_structure:
        pdnms = MakeAModelstruc( (BiostrucPtr)egp->Data_data->data.ptrvalue );
        if ( !pdnms ) break;
        
        pmsdThis = (PMSD)pdnms->data.ptrvalue;
        pdnmlThis = pmsdThis->pdnmlModels;
        /* set up for doing one model or animation */
        while ( pdnmlThis )
        {
          pmldThis = (PMLD)pdnmlThis->data.ptrvalue;
          if (pmldThis->iType == Model_type_ncbi_backbone)
            pmldOne = pmldThis;
          if (pmldThis->iType == Model_type_ncbi_all_atom)
            pmldAll = pmldThis;
          pdnmlThis = pdnmlThis->next;
        }
        
        if (pmldOne  &&  pmldAll)
          pmldOne->bSelected &= (Byte)0xFE;
        Cn3D_ResetActiveStrucProc();
        break;
        
      case Data_data_nuc:
      case Data_data_prot:
      case Data_data_ml:
      case Data_data_genome:
      default:
        break;
      }
      break;
                         /* yanli start */
      case NcbiMimeAsn1_strucseq:
        bssp = (BiostrucSeqPtr)mime->data.ptrvalue;
        pdnms = MakeAModelstruc( (BiostrucPtr)bssp->structure);
        if ( !pdnms ) break;

        pmsdThis = (PMSD)pdnms->data.ptrvalue;
        pdnmlThis = pmsdThis->pdnmlModels;
        /* set up for doing one model or animation */
        while ( pdnmlThis )
        {
          pmldThis = (PMLD)pdnmlThis->data.ptrvalue;
          if (pmldThis->iType == Model_type_ncbi_backbone)
            pmldOne = pmldThis;
          if (pmldThis->iType == Model_type_ncbi_all_atom)
            pmldAll = pmldThis;
          pdnmlThis = pdnmlThis->next;
        }

        if (pmldOne  &&  pmldAll)
          pmldOne->bSelected &= (Byte)0xFE;
        Cn3D_ResetActiveStrucProc();
        break;
        
      case NcbiMimeAsn1_alignseq:
        pbsasThis = (BiostrucAlignSeqPtr) mime->data.ptrvalue;
        sap = pbsasThis->seqalign;
        salp = sap->data;
        if(salp != NULL) {
           SalsaRegister();
           LaunchSalsa(salp);
           retval = TRUE;
        }
        viewalign_only = TRUE;
        ArrowCursor();
        return retval;
                         /* yanli end */
      case NcbiMimeAsn1_alignstruc:   /* this is the code that received alignments */
        pbsaThis = (BiostrucAlignPtr)mime->data.ptrvalue;
        if (!pbsaThis ) break; /* THROW */
      retval = TRUE;

        /* load in the master */
        pdnmsMaster = MakeAModelstruc( (BiostrucPtr)pbsaThis->master );  /* grab the master struc */
        if ( !pdnmsMaster ) break;

        pmsdMaster = (PMSD)pdnmsMaster->data.ptrvalue;
        parsThis = NewAlignRenderSet();
        pmsdMaster->pExtra = parsThis;
        pmsdMaster->bVisible = TRUE;
        pdnmlThis = pmsdMaster->pdnmlModels;
        /* set up for doing one model or animation */
        while ( pdnmlThis )
        {
          pmldThis = (PMLD)pdnmlThis->data.ptrvalue;
          if (pmldThis->iType == Model_type_ncbi_backbone)
            pmldOne = pmldThis;
          if (pmldThis->iType == Model_type_ncbi_all_atom)
            pmldAll = pmldThis;
          pdnmlThis = pdnmlThis->next;
        }
        
        if (pmldOne  &&  pmldAll)
          pmldOne->bSelected &= (Byte)0xFE;


        /* add the alignment seq annot ptr, etc. */
        pmsdMaster->psaAlignment = pbsaThis->seqalign;
        pmsdMaster->pseSequences = pbsaThis->sequences;  
        pmsdMaster->pseqaSeqannot = pbsaThis->seqalign;


      SetNeighborOn(); /* turn on neighbor mode */

      SetMasterModelstruc(pdnmsMaster);

        /* do a slave */

        pbsThis =  (BiostrucPtr)pbsaThis->slaves;
        pbsfThis = (BiostrucFeaturePtr)pbsaThis->alignments->features->features;
        pvnAlignment = NULL;

        while(pbsThis) 
        {
          pdnmsSlave = MakeAModelstruc( pbsThis );
          if ( !pdnmsSlave ) break;
          pmsdSlave = (PMSD)pdnmsSlave->data.ptrvalue;
          pmsdSlave->bMaster = FALSE;  /* this is not a master struct */
          pmsdMaster->bAligned++;
          pmsdSlave->pbAligned = &(pmsdMaster->bAligned);
          pdnmlThis = pmsdSlave->pdnmlModels;
          /* set up for doing one model or animation */
          pmldOne = NULL;
          pmldThis = NULL;
          while ( pdnmlThis )
          {
            pmldThis = (PMLD)pdnmlThis->data.ptrvalue;
            if (pmldThis->iType == Model_type_ncbi_backbone)
              pmldOne = pmldThis;
            if (pmldThis->iType == Model_type_ncbi_all_atom)
              pmldAll = pmldThis;
            pdnmlThis = pdnmlThis->next;
          }
          
          if (pmldOne  &&  pmldAll)
            pmldOne->bSelected &= (Byte)0xFE;
          
          /* find the corresponding alignment */       
          pvnAlignment = ValNodeFindNext(pbsfThis->Location_location, NULL, Location_location_alignment);  
          if (pvnAlignment == NULL) break;
          

          pcgaSlave = pvnAlignment->data.ptrvalue;
          pvnThis = pcgaSlave->alignment;
          if (pvnThis)
          {
            pcgpThis = ( ChemGraphPntrsPtr ) pvnThis;
            pvnListMaster = MakeChemGraphNodeList(pdnmsMaster, pcgpThis);
            pcgpThis = ( ChemGraphPntrsPtr ) pvnThis->next;
            pvnListSlave = MakeChemGraphNodeList(pdnmsSlave, pcgpThis);
            if (!pvnListMaster) break;
            if (!pvnListSlave) break;
            while (pvnListMaster && pvnListSlave)
            {
              pfbMaster = (PFB) pvnListMaster->data.ptrvalue;
              pfbMaster->bReserved++;
              pfbSlave = (PFB) pvnListSlave->data.ptrvalue;
              pfbSlave->bReserved++;
              ((PMGD)pfbSlave)->pbMasterReserved =  & (pfbMaster->bReserved);  /* use unused feature pointer to point slave back at master */
              pvnListSlave = pvnListSlave->next;
              pvnListMaster = pvnListMaster->next;
            }  /* while pvnListMaster */
            ValNodeFree(pvnListMaster);
            ValNodeFree(pvnListSlave);
          }  /* while pvnThis */



          pdnTransform = NULL;
          /* create the spatial transformation */
          TransformToDNTRN(&pdnTransform,  ((ChemGraphAlignmentPtr)pvnAlignment->data.ptrvalue)->transform);
          if(pdnTransform == NULL) break;
          /* loop over the slave's models with the transformation */
          pdnmlThis = pmsdSlave->pdnmlModels;
          
          while (pdnmlThis)
          {
            TraverseAtoms( pdnmsSlave, pdnmlThis->choice, 0, pdnTransform, DoApplyTransform);
            TraverseSolids( pdnmsSlave, pdnmlThis->choice, 0, pdnTransform, DoApplyTransform);
            pdnmlThis = pdnmlThis->next;
          }
          
          pmsdSlave->pExtra = parsThis;  
          pmsdSlave->bVisible = TRUE;
          FreeDNTRN(pdnTransform);
          pbsThis = pbsThis->next;
          pbsfThis = pbsfThis->next;
          /* turn the transform into a dvalnode for the traverse */
        } /*while pbsThis */
        

        Cn3D_ResetActiveStrucProc();

        
        break;
      default:
        break;
    }
    
  }} while ( 0 ); /* End-of-TRY-block */
  
  if (removeIt){
    FileRemove( filename );
  }
  ArrowCursor();

  Cn3dObjRegister();        /*  yanli  */

  return retval;
}


static void Cn3D_OpenEnableProc(TexT t)
{
    Char str[32];
    GetTitle(Cn3D_tOpen, str, sizeof(str));
    if (StringLen(str) == 0)
      {
        Disable(Cn3D_bOpenAccept);
      }
    else
      {
        Enable(Cn3D_bOpenAccept);
      }
    return;
}

static void Cn3D_NetOpenAcceptProc(ButtoN b)
{
  Char str[32]; 
  BiostrucPtr pbsBiostruc = NULL;
  PDNMS pdnmsModelstruc = NULL;
  PMSD  pmsdThis = NULL;
  Int4 MdlNo,  MdlLvl;
  PDNML pdnmlThis = NULL;
  PDNML pdnmlFirst = NULL;
  PMLD pmldThis = NULL;
  PMLD pmldOne = NULL;
  PMLD pmldAll = NULL;
  PMLD pmldVec = NULL;
 
  WatchCursor();
  SetNeighborOff();   /* we don't load in neighbors thru this route */
  Cn3D_SaveActiveCam();
  GetTitle(Cn3D_tOpen, str, sizeof(str));
   
  switch (GetValue(Cn3D_gMdlLvl))
    {
	case 1: MdlLvl = ONECOORDATOM;
		break;
	case 2: MdlLvl = ONECOORDRES;
		break;
	case 3: MdlLvl = ALLMDL;
		break;
	case 4: MdlLvl = VECMODEL;
		break;
	case 5: MdlLvl = ALLSIMPLEMDL;
		break;
        case 6: MdlLvl = BSEVERYTHING;
                break;
	default: MdlLvl = ONECOORDATOM; /* set from config-file default */
    } 
  switch (GetValue(Cn3D_gMdlNo))
    {
	case 1: MdlNo = 1;
		break;
	case 2: MdlNo = 2;
		break;
	case 3: MdlNo = 5;
		break;
	case 4: MdlNo = 10;
		break;
	case 5: MdlNo = 15;
		break;
	case 6: MdlNo = 20;
		break;
	case 7: MdlNo = MAX_MDLNO;
		break;
	 case 8:
	default: MdlNo = 1; /* set from config-file default */
    }
  if (GetValue(Cn3D_gMdlLvl) == 6) MdlNo = MAX_MDLNO; /* get all */
  if (GetValue(Cn3D_gAccType) == 1) /* PDB */
    {   
      pbsBiostruc = FetchBiostrucPDB(str, MdlLvl, MdlNo);
    }
  else  /* MMDB */
    {   
      pbsBiostruc = FetchBS(str,  INP_GI, MdlLvl, MdlNo, GetMMDBAPIbExtent());
    }  
  ArrowCursor();  
  if (pbsBiostruc != NULL)
   {
     WatchCursor();
     pdnmsModelstruc= MakeAModelstruc(pbsBiostruc);	
     ArrowCursor();  
   }	
  if (pdnmsModelstruc == NULL)
   {
    /* return a not found error here */
    Remove(Cn3D_wNetOpen);
    Cn3D_EnableFileOps();
    Cn3D_Open_InUse = FALSE;
    return;
   }    
  if (GetValue(Cn3D_gMdlLvl) == 5)
    {  /* turn off backbone model if "All" models present */
        pmsdThis = (PMSD) pdnmsModelstruc->data.ptrvalue;
        pdnmlThis = pmsdThis->pdnmlModels;
        /* set up for doing one model or animation */
        while (pdnmlThis)
         {
           pmldThis = (PMLD) pdnmlThis->data.ptrvalue;
           if (pmldThis->iType == Model_type_ncbi_vector)
              pmldVec = pmldThis;
	   if (pmldThis->iType == Model_type_ncbi_backbone)
	      pmldOne = pmldThis;
	   if(pmldThis->iType == Model_type_ncbi_all_atom)
	      pmldAll = pmldThis;
           pdnmlThis = pdnmlThis->next;
	 }
      if ((pmldOne != NULL) && (pmldAll != NULL))
          pmldOne->bSelected &= (Byte) 0xFE;
   }
    
  Remove(Cn3D_wNetOpen);
  Cn3D_EnableFileOps();
 
  /*CALL TO initialize the view */
 
  Cn3D_Open_InUse = FALSE;
  Cn3D_ResetActiveStrucProc();
  
  Cn3dObjRegister();

  return;
}


static void Cn3D_NetOpenCancelProc(GraphiC g)
{
  Remove(Cn3D_wNetOpen);
  Cn3D_EnableFileOps();
  Cn3D_Open_InUse = FALSE;
  return;
}

static void Cn3D_NetOpenBiostruc(IteM i)
{
    GrouP g, hg;
    ButtoN b;
    
    if (Cn3D_Open_InUse) return;
    else Cn3D_Open_InUse = TRUE;


    Cn3D_wNetOpen = FixedWindow(-30, -20,  -10,  -10, " Internet retrieve from MMDB ",  NULL);
    hg = HiddenGroup(Cn3D_wNetOpen, 3, 0, NULL);
    SetGroupSpacing(hg, 30, 30);
    g = NormalGroup(hg, 1, 0," Enter accession code:", systemFont,  NULL); 
    SetGroupMargins(g, 10, 15);
    Cn3D_tOpen = DialogText(g,"",10, (TxtActnProc) Cn3D_OpenEnableProc);
    Cn3D_gAccType = NormalGroup(hg, 1, 2, " accession type", systemFont,  NULL);
    SetGroupMargins(Cn3D_gAccType, 10, 10);
    RadioButton(Cn3D_gAccType, "PDB Code");
    RadioButton(Cn3D_gAccType, "MMDB ID");
    
    g = HiddenGroup(hg, 1, 2, NULL);  
    SetGroupSpacing(g, 15, 15);
    Cn3D_bOpenAccept = DefaultButton(g, "OK", (BtnActnProc) Cn3D_NetOpenAcceptProc);
    b = PushButton(g, "Cancel", (BtnActnProc) Cn3D_NetOpenCancelProc);
 
    Cn3D_gMdlLvl = NormalGroup(Cn3D_wNetOpen, 2, 3, " model complexity", systemFont, NULL);
    SetGroupMargins(Cn3D_gMdlLvl, 10, 10);
    SetGroupSpacing(Cn3D_gMdlLvl, 10, 5);
    RadioButton(Cn3D_gMdlLvl, "a) NCBI one XYZ per atom model");
    RadioButton(Cn3D_gMdlLvl, "c) NCBI backbone model");
    RadioButton(Cn3D_gMdlLvl, "b) original PDB models 1-n");
    RadioButton(Cn3D_gMdlLvl, "d) NCBI vector model");
    RadioButton(Cn3D_gMdlLvl, "Viewing Subset (a, c and d)");
    RadioButton(Cn3D_gMdlLvl, "Everything");
    
    Cn3D_gMdlNo = NormalGroup(Cn3D_wNetOpen, 7, 0, " n = ", systemFont, NULL);
    RadioButton(Cn3D_gMdlNo, "1");
    RadioButton(Cn3D_gMdlNo, "2");
    RadioButton(Cn3D_gMdlNo, "5");
    RadioButton(Cn3D_gMdlNo, "10");
    RadioButton(Cn3D_gMdlNo, "15");
    RadioButton(Cn3D_gMdlNo, "20");
    RadioButton(Cn3D_gMdlNo, "maximum");
    
   
    SetValue(Cn3D_gMdlNo, 7);
    SetValue(Cn3D_gAccType, 1);
    SetValue(Cn3D_gMdlLvl, 5);
    Disable(Cn3D_bOpenAccept);
    Cn3D_DisableFileOps();
    Select(Cn3D_tOpen);
    Show(Cn3D_wNetOpen);
    return;
}

/*********************************************/
/* below this are the file i/o open-er procs */
/*********************************************/

static void Cn3D_OpenBrowseProc(GraphiC g)
{
    Char path[PATH_MAX];
    
     path[0] = '\0';
    
    if (GetInputFileName (path, sizeof(path), NULL, NULL))
      { 
        SetTitle(Cn3D_tOpen, path);  
	Cn3D_OpenEnableProc(NULL);
      }

    return;   
}


static void Cn3D_OpenCancelProc(ButtoN b)
{
  Remove(Cn3D_wOpen);
  Cn3D_EnableFileOps();
  Cn3D_Open_InUse = FALSE;
  return;
}


static void Cn3D_OpenAcceptProc(ButtoN b)
{
  Char str[PATH_MAX];
  unsigned char szBegin[10], sCompare; 
  BiostrucPtr pbsBiostruc;
  PDNMS pdnmsModelstruc;
  Int4 MdlNo = MAX_MDLNO;
  FILE * hFile;
  
  WatchCursor();
  SetNeighborOff(); /* we don't load in slaves here */
  Cn3D_SaveActiveCam();
  GetTitle(Cn3D_tOpen, str, sizeof(str));
  hFile = FileOpen(str, "rb");
  FileGets((CharPtr) szBegin, 2, hFile);
  if (hFile == NULL) szBegin[0] = (Char) 0;
  FileClose(hFile);
  sCompare = 159;
  if(szBegin[0] > sCompare)  /* mime */
  {
    if(!OpenMimeFileWithDeletion(str, FALSE))
    {
      Remove(Cn3D_wOpen);
      Cn3D_EnableFileOps();
      if (GetFirstModelstruc != NULL) Cn3D_EnableFileOps();
      Cn3D_Open_InUse = FALSE;
      return;
    }
  }
  else  /* not mime */
  {
    /* get binary or ascii here */ 
    if (GetValue(Cn3D_gBinAscii) == 1) /* ASCII */
    {   /* these get everything in the file , ignoring modellevel */
      pbsBiostruc = FetchBS(str, INP_ASCII_FILE, BSEVERYTHING, MdlNo,  CONVERT_ALL);
    }
    else  /* Binary */
    {   
      pbsBiostruc = FetchBS(str,  INP_BINARY_FILE, BSEVERYTHING,  MdlNo, CONVERT_ALL);
    }   
    ArrowCursor();
    if (pbsBiostruc != NULL)
    {
      WatchCursor();
      pdnmsModelstruc= MakeAModelstruc(pbsBiostruc);	
      ArrowCursor();
    }	
    else
    {
      /* return a not found error here */
      
      Remove(Cn3D_wOpen);
      Cn3D_EnableFileOps();
      if (GetFirstModelstruc != NULL) Cn3D_EnableFileOps();
      Cn3D_Open_InUse = FALSE;
      return;
    }  
  } /* switch between mime and non-mime */
  Remove(Cn3D_wOpen);
  Cn3D_EnableFileOps();
  /* initialize the view */
  Cn3D_Open_InUse = FALSE;
  Cn3D_ResetActiveStrucProc();

  Cn3dObjRegister();

  return;
}






static void Cn3D_OpenBiostruc(IteM i)
{
    GrouP   g;
    ButtoN  b;
    
    if (Cn3D_Open_InUse) return;
    else Cn3D_Open_InUse = TRUE;
    
    Cn3D_wOpen = FixedWindow(-30, -20,  -10,  -10, " Open a local Biostruc ",  NULL);
    g = NormalGroup(Cn3D_wOpen, 2, 1, " Enter Biostruc file name:",  systemFont, NULL);
    SetGroupMargins(g, 10, 10);
    SetGroupSpacing(g, 10, 20);  
    Cn3D_tOpen = DialogText(g,"",25, (TxtActnProc) Cn3D_OpenEnableProc);
    Cn3D_bOpenBrowse = PushButton(g, " browse...", (BtnActnProc) Cn3D_OpenBrowseProc);
   
    g = HiddenGroup(Cn3D_wOpen, 3, 1, NULL);
    SetGroupMargins(g, 10, 10);
    SetGroupSpacing(g, 30, 30);
 
    Cn3D_gBinAscii = NormalGroup(g, 2, 1, "file mode", systemFont,  NULL);
    SetGroupMargins(Cn3D_gBinAscii, 10, 10);
    RadioButton(Cn3D_gBinAscii, "Ascii");
    RadioButton(Cn3D_gBinAscii, "Binary");
    SetValue(Cn3D_gBinAscii, 1);
    
    b = PushButton(g, "Cancel", (BtnActnProc) Cn3D_OpenCancelProc);
    Cn3D_bOpenAccept = DefaultButton(g, "OK", (BtnActnProc) Cn3D_OpenAcceptProc);
   
    Disable(Cn3D_bOpenAccept);
    Cn3D_DisableFileOps();
    Select(Cn3D_tOpen );
    Show(Cn3D_wOpen);
    return;
}

/*
static void Cn3D_OpenFeature(IteM i)
{
  return;
}
*/


static void Cn3D_NeighborProc(IteM i)
{
  return;
} 



MenU LIBCALL Cn3D_OpenSub (MenU m)
{
  IteM i;
  MenU s;

  s = SubMenu (m, "Open");
  i = CommandItem (s, "Biostruc - MMDB/N", Cn3D_NetOpenBiostruc);
  i = CommandItem (s, "Biostruc - Local/B", Cn3D_OpenBiostruc);
/* i = CommandItem (s, "Feature-set/F", Cn3D_OpenFeature); */
 
  return s;
}
