/*   spattern.h
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* File Name:  spattern.h
*
* Author:  Epstein
*
* Version Creation Date:   1/4/94
*
* $Revision: 6.0 $
*
* File Description:
*       Sequence-specific pattern matching
*
* Modifications:
* --------------------------------------------------------------------------
* Date     Name        Description of modification
* -------  ----------  -----------------------------------------------------
*
* $Log: spattern.h,v $
* Revision 6.0  1997/08/25 18:54:46  madden
* Revision changed to 6.0
*
* Revision 1.3  1997/01/28 20:45:33  epstein
* add C++ directives
*
 * Revision 1.2  1996/06/21  14:10:46  epstein
 * add boilerplate and run 'indent'
 *
*
* ==========================================================================
*/

#include <ncbi.h>
#include <objseq.h>
#include <gpattern.h>

#ifndef _SPATTERN_H_
#define _SPATTERN_H_

#ifdef _cplusplus
extern "C" {
#endif

typedef struct {
    CharPtr         enzymeName;
    CharPtr         recognitionSeq;
                    Int2 cutSites[2];
    Int2            enzymeType;
}               CutsiteInfo, PNTR CutsiteInfoPtr;

Int4 LIBCALL PatternMatchSeqLoc (CompiledPattern compPat, SeqLocPtr slp, Boolean is_na, Int4 maxMatches, Int4 maxRange, Uint1 seqLocType, Int4 offset, SeqLocPtr PNTR seqLocs);
SeqAnnotPtr LIBCALL FindCutSitesAsSeqAnnot (SeqLocPtr querySlp, CutsiteInfoPtr cutsites, CharPtr cutDbName, Int2 numPermittedPartialMatches);

#ifdef _cplusplus
}
#endif

#endif				/* _SPATTERN_H_ */
