#ifndef _URKEPI__
#define _URKEPI__

#include <ncbi.h>
#include <seqport.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct LowComplexityData
{
  Int4       window, linker, method;
  FloatHi    percentcut;
  Int4Ptr    epiarray;
  FloatHiPtr score;
} EpiDat, PNTR EpiDatPtr;

/*
 caller responsibiliity
  epip = EpiDatNew ();
  probability_scores = PredictEpi...
  MemFree (probability_scores);
  EpiDatFree (epip);
*/

extern EpiDatPtr EpiDatNew (void);
extern EpiDatPtr EpiDatFree (EpiDatPtr epip);

extern FloatHiPtr PredictEpi (CharPtr seq, Int4 start, Int4 end,
                              EpiDatPtr epip);

extern FloatHiPtr PredictEpiSeqPort (SeqPortPtr spp,
                                     Int4 start, Int4 end,
                                     EpiDatPtr epip);

extern FloatHiPtr PredictEpiBioseq (BioseqPtr bsp,
                                    Int4 start, Int4 end,
                                    EpiDatPtr epip);

extern FloatHiPtr PredictEpiSeqLoc (SeqLocPtr slp,
                                    EpiDatPtr epip);

extern SeqLocPtr FilterEpi (EpiDatPtr pepi, Int4 length, SeqIdPtr sip,
                            Boolean flagHighPass);

#ifdef __cplusplus
}
#endif

#endif
