//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//                                                     VV         VV       //
//  VV       VV     V - A Portable C++ GUI Framework    VV       VV        //
//   VV     VV           designed and written by         VV     VV         //
//    VV   VV                                             VV   VV          //
//     VV VV              Bruce E. Wampler, Ph.D.          VV VV           //
//      VVV               e-mail: bruce@objectcentral.com   VVV            //
//       V                                                   V             //
//                                                                         //
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//                                                                         //
// vos.cpp - Interface to OS dependent stuff (For Windows)                 //
//                                                                         //
// Copyright (C) 1998  Bruce E. Wampler                  //
//                                                                         //
// This file is part of the V C++ GUI Framework.                           //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
#include <v/vos.h>
#include <windows.h>

const int MaxCompNameLen = 256;

//=========================>>> vOS::vOS <<<==========================
  vOS::vOS()
  {
    // Constructor
    // This will be used to determing which OS we are running
    // under: e.g., NT vs 95
  }

//=========================>>> vOS::~vOS <<<==========================
  vOS::~vOS()
  {
    // Destructor
  }

//=========================>>> vOS::vDeleteFile <<<==========================
  int vOS::vDeleteFile(const char* filename)
  {
     return ::DeleteFile(filename) == TRUE;
  }

//=========================>>> vOS::vChDrive <<<==========================
  int vOS::vChDrive(int drive)
  {
    char temp [3] = "-:";
    temp[0] = drive + 'A';
    return ::SetCurrentDirectory(temp);
  }

//=========================>>> vOS::vGetUserName <<<==========================
  int vOS::vGetUserName( char* s, int len)
  {
    // Set s to user name

    char UserName[MaxCompNameLen+1];
    DWORD cch = sizeof UserName;

    if (::GetUserName(UserName, &cch))
      {
	strncpy(s, UserName, len);
	return 1;
      }
    s[0] = 0;
    return 0;
  }


//=========================>>> vOS::vGetHostName <<<==========================
  void vOS::vGetHostName(char* s, int len)
  {
    // Get host name

    char HostName[MaxCompNameLen+1];
    DWORD cch = MaxCompNameLen;

    if (::GetComputerName(HostName, &cch))
      {
	strcpy(s,HostName);
      }
    else
	strcpy(s, "PC_Win32");
  }

//=========================>>> vOS::vGetPid <<<==========================
  long vOS::vGetPid()
  {
    // return process ID

    return (long) ::GetCurrentProcessId();
  }


//=========================>>> vOS::vGetCWD <<<==========================
  int vOS::vGetCWD(char* buf, int len)
  {
    // Get name of current directory

    int rv = ::GetCurrentDirectory(len, buf);

    return rv;
  }

//=========================>>> vOS::vChDir <<<==========================
  int vOS::vChDir(char *path)
  {
    if (path[0] == 0)		/* just checking... */
	return 0;

    if (*path == 0)		/* drive name only */
	return 0;

    return ::SetCurrentDirectory(path);	       /* let the normal chdir() do the rest */
  }

//=========================>>> vOS::vRunProcess <<<==========================
  int vOS::vRunProcess(const char* cmd, const char* StdOut, const char* StdErr,
      const int Wait, const int minimize)
  {
    STARTUPINFO		si;
    PROCESS_INFORMATION pi;
    DWORD		ret = 0;

    si.cb = sizeof(si);
    si.lpReserved = NULL;
    si.lpDesktop = NULL;
    si.lpTitle = NULL;
    si.dwFlags = 0;
    si.cbReserved2 = 0;
    si.lpReserved2 = NULL;
    si.dwFlags = STARTF_USESHOWWINDOW;
    if (minimize)
        si.wShowWindow = SW_MINIMIZE;
    else
        si.wShowWindow = SW_SHOWNORMAL;

    HANDLE hStderr = ::GetStdHandle(STD_ERROR_HANDLE); // get current stderr
    HANDLE hNewStderr = INVALID_HANDLE_VALUE;
    HANDLE hStdout = ::GetStdHandle(STD_OUTPUT_HANDLE); // get current stderr
    HANDLE hNewStdout = INVALID_HANDLE_VALUE;

    if (StdErr && *StdErr)	// they specified a stderr out
      {
        hNewStderr = ::CreateFile(
          StdErr,			// address of name of the file
    	  GENERIC_WRITE	,		// access (read-write) mode
    	  (DWORD) 0,			// share mode
          (LPSECURITY_ATTRIBUTES) 0,	// address of security descriptor
    	  CREATE_ALWAYS	,		// how to create
    	  FILE_ATTRIBUTE_NORMAL,	// file attributes
          (HANDLE) 0 		// handle of file with attributes to copy
          );
        if (hNewStderr != INVALID_HANDLE_VALUE)
          {
            ::SetStdHandle(STD_ERROR_HANDLE,hNewStderr);
          }
      }
    if (StdOut && *StdOut)	// they specified a stderr out
      {
        hNewStdout = ::CreateFile(
          StdOut,			// address of name of the file
    	  GENERIC_WRITE	,		// access (read-write) mode
    	  (DWORD) 0,			// share mode
          (LPSECURITY_ATTRIBUTES) 0,	// address of security descriptor
    	  CREATE_ALWAYS	,		// how to create
    	  FILE_ATTRIBUTE_NORMAL,	// file attributes
          (HANDLE) 0 		// handle of file with attributes to copy
          );
        if (hNewStdout != INVALID_HANDLE_VALUE)
          {
            ::SetStdHandle(STD_OUTPUT_HANDLE,hNewStdout);
          }
      }

    // Now, run the command
    if (!::CreateProcess (NULL,		/* Executable name */
	    (char *)cmd,		/* Command to execute */
	    NULL,			/* Process security attributes */
	    NULL,			/* Thread security attributes */
	    FALSE,			/* Inherit handles */
            0,				/* Creation flags */
	    NULL,			/* Environment */
	    NULL,			/* Current directory */
	    &si,			/* Startup information */
	    &pi))			/* Process information */
        return 99;

    if (!Wait)
        return 0;


    /* Wait for the command to terminate before continuing */
    ::WaitForSingleObject(pi.hProcess, INFINITE);

    /* Get the command exit code */
    ::GetExitCodeProcess(pi.hProcess, &ret);

    /* Close the handles to the subprocess, so that it goes away */
    ::CloseHandle(pi.hThread);
    ::CloseHandle(pi.hProcess);

    if (hNewStderr != INVALID_HANDLE_VALUE)
      {
        ::SetStdHandle(STD_ERROR_HANDLE,hStderr);
        ::CloseHandle(hNewStderr);
      }
    if (hNewStdout != INVALID_HANDLE_VALUE)
      {
        ::SetStdHandle(STD_OUTPUT_HANDLE,hStdout);
        ::CloseHandle(hNewStdout);
      }

    return ret;
  }
