//	videapp.h:	Header for videApp class
//=======================================================================

#ifndef videAPP_H
#define videAPP_H

// Include standard V files as needed

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include <v/vapp.h>
#include <v/vawinfo.h>

#include "videcmdw.h"	// we use videCommandWindow

    enum Emulation {
        Generic,
        See,
        Vi,
        Emacs,
        Epsilon,
        WordStar
      };

    class videApp : public vApp
      {
	friend int AppMain(int, char**);	// allow AppMain access

      public:		//---------------------------------------- public

	videApp(char* name, int sdi = 0, int h = 0, int w = 0);
	virtual ~videApp();

	// Routines from vApp that are normally overridden

	virtual vWindow* NewAppWin(vWindow* win, char* name, int w, int h,
		vAppWinInfo* winInfo = 0);

	virtual void Exit(void);

	virtual int CloseAppWin(vWindow*);

	virtual void AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType);

	virtual void KeyIn(vWindow*, vKey, unsigned int);

      	// New routines for this particular app

        videCmdWindow* GetMsgWindow() { return _videCmdWin; }
        void SetMkFile(char* mkf);
        char* GetMkFile() { return _videMkFile; }
        Emulation GetEmulation() { return _emulation; }
        void SetEmulation(Emulation em) { _emulation = em; }

      protected:	//--------------------------------------- protected

      private:		//--------------------------------------- private

        Emulation _emulation;
	videCmdWindow* _videCmdWin;		// Pointer to instance of first window
        char _videMkFile[maxFileNameSize];
      };
#endif
