/*
 * Copyright (c) 1997, 1998 Akira Yoshiyama <yosshy@debian.or.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licenses as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

struct table_lower_t {
  unsigned char key;
  unsigned char *mbc;
  struct table_lower_t *next;
};

struct table_upper_t {
  unsigned char key;
  struct table_lower_t *table_lower;
  struct table_upper_t *next;
};

#define NEW(type) (type *)malloc(sizeof(type))
#define NEWSTR(n) (unsigned char *)malloc((size_t)(n))

char *progname;
int mbcnum;

struct table_upper_t *newupper(unsigned char key)
{
  struct table_upper_t *n;
  if ((n=NEW(struct table_upper_t))==NULL) {
    fprintf(stderr,"%s: newupper: can't allocate memory for table_upper\n", progname);
    exit(1);
  }
  n->key=key;
  n->next=NULL;
  return n;
}

struct table_lower_t *newlower(unsigned char key, unsigned int mbc)
{
  struct table_lower_t *n;
  int i;
  if ((n=NEW(struct table_lower_t))==NULL) {
    fprintf(stderr,"%s: newlower: can't allocate memory for table_lower\n", progname);
    exit(1);
  }
  n->key=key;
  n->next=NULL;
  n->mbc=NEWSTR(mbcnum);
  for (i=mbcnum-1; i>=0; i--) {
    n->mbc[i]=(unsigned char)(mbc & 0xFF);
    mbc >>= 8;
  }
  return n;
}

void main(int argc, char **argv)
{
  char buffer[BUFSIZ], *p,*p1,*p2,*dummy,*symbol;
  unsigned int cucs, cmbc, count, i, mask;
  unsigned char cucs_upper, cucs_lower;
  struct table_upper_t *start=NULL, *ct_upper, *tmp_upper;
  struct table_lower_t *ct_lower, *tmp_lower;

  progname=argv[0];
  symbol="";

  switch (argc) {
  case 4:
    mask=(unsigned int)strtol(argv[3],&dummy,0);
  case 3:
    symbol=argv[2];
  case 2:
    mbcnum=(int)strtol(argv[1],&dummy,0);
    break;
  default:
    fprintf(stderr,"usage: %s <MBC number> [ <symbol name> [ <mask> ]]\n",progname);
    exit(1);
  }

  while (fgets(buffer, BUFSIZ, stdin)!=NULL) {
    for (p=buffer; isspace(*p); p++); 
    if (*p=='#') continue;
    if (*p=='\n') continue;
    if (*p=='\0') continue;
    if ((p1=strtok(p," \t\n"))==NULL) continue;
    if ((p2=strtok(NULL," \t\n"))==NULL) continue;
    cmbc=(unsigned int)strtol(p1,&dummy,0)|mask;
    cucs=(unsigned int)strtol(p2,&dummy,0);
    cucs_upper=(unsigned char)((cucs & 0xFF00) >> 8);
    cucs_lower=(unsigned char)( cucs & 0xFF);

    if (!(start)) {
      start=newupper(cucs_upper);
      start->table_lower=newlower(cucs_lower, cmbc);
      continue;
    }
    if (start->key > cucs_upper) {
      tmp_upper=newupper(cucs_upper);
      tmp_upper->table_lower=newlower(cucs_lower, cmbc);
      tmp_upper->next=start;
      start=tmp_upper;
      continue;
    }
    for (ct_upper=start;; ct_upper=ct_upper->next) {
      if (ct_upper->key==cucs_upper) {
        if (ct_upper->table_lower->key > cucs_lower) {
          tmp_lower=newlower(cucs_lower, cmbc);
          tmp_lower->next=ct_upper->table_lower;
          ct_upper->table_lower=tmp_lower;
          goto exit_while;
        }
        for (ct_lower=ct_upper->table_lower;; ct_lower=ct_lower->next) {
          if (ct_lower->key==cucs_lower) {
            fprintf(stderr,"%s: duplicated entry: %x\n",progname,cucs);
            exit(1);
          }
          if (ct_lower->next==NULL) {
            ct_lower->next=newlower(cucs_lower, cmbc);
            goto exit_while;
          }
          if (ct_lower->next->key > cucs_lower) {
            tmp_lower=newlower(cucs_lower, cmbc);
            tmp_lower->next=ct_lower->next;
            ct_lower->next=tmp_lower;
            goto exit_while;
          }
        }
      }
      if (ct_upper->next==NULL) {
        ct_upper->next=newupper(cucs_upper);
        ct_upper->next->table_lower=newlower(cucs_lower, cmbc);
        goto exit_while;
      }
      if (ct_upper->next->key > cucs_upper) {
        tmp_upper=newupper(cucs_upper);
        tmp_upper->table_lower=newlower(cucs_lower, cmbc);
        tmp_upper->next=ct_upper->next;
        ct_upper->next=tmp_upper;
        goto exit_while;
      }
    }
  exit_while:
  }

  /**
    upper table: (char)key, (u_16)pointer
    lower table: (char)key, (char *)mbc
   **/

  count=0;
  printf("upper_table_t ut_%s[]={\n",symbol);
  for (ct_upper=start; ct_upper; ct_upper=ct_upper->next) {
    printf("{0x%02x, %d},\n", ct_upper->key, count);
    for (ct_lower=ct_upper->table_lower; ct_lower; ct_lower=ct_lower->next)
      count++;
  }
  printf("{0,%d}\n};\n",count);

  printf("char lt_%s[]={\n",symbol);
  for (ct_upper=start; ct_upper; ct_upper=ct_upper->next)
    for (ct_lower=ct_upper->table_lower; ct_lower; ct_lower=ct_lower->next) {
      printf("0x%02x, ", ct_lower->key);
      for (i=0; i<mbcnum; i++)
        printf("0x%02x, ",ct_lower->mbc[i]);
      printf(" /* 0x%02x%02x */\n", ct_upper->key, ct_lower->key);
    }
  printf("0};\n");

  exit(0);
}
