/*  -------------------------------------------------------------------

This program is the property of:

                             Cornell University 
                        Center for Applied Mathematics 
                              Ithaca, NY 14853

and may be used, modified and distributed freely, subject to the 
following restrictions:

       Any product which incorporates source code from the dstool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.

DsTool is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of FITNESS 
FOR A PARTICULAR PURPOSE.  The software is provided as is without 
any obligation on the part of Cornell faculty, staff or students to 
assist in its use, correction, modification or enhancement.

  -----------------------------------------------------------------  */
/*
 * mult_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `mult.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "mult_cui.h"

/*
 * Initialize an instance of object `win'.
 */
mult_win_objects *
mult_win_objects_initialize(ip, owner)
	mult_win_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (mult_win_objects *) calloc(1, sizeof (mult_win_objects))))
		return (mult_win_objects *) NULL;
	if (!ip->win)
		ip->win = mult_win_win_create(ip, owner);
	if (!ip->pan)
		ip->pan = mult_win_pan_create(ip, ip->win);
	if (!ip->forwards)
		ip->forwards = mult_win_forwards_create(ip, ip->pan);
	if (!ip->backwards)
		ip->backwards = mult_win_backwards_create(ip, ip->pan);
	if (!ip->contin)
		ip->contin = mult_win_contin_create(ip, ip->pan);
	if (!ip->images)
		ip->images = mult_win_images_create(ip, ip->pan);
	if (!ip->load)
		ip->load = mult_win_load_create(ip, ip->pan);
	if (!ip->copy)
		ip->copy = mult_win_copy_create(ip, ip->pan);
	if (!ip->info)
		ip->info = mult_win_info_create(ip, ip->pan);
	if (!ip->loadchoice)
		ip->loadchoice = mult_win_loadchoice_create(ip, ip->pan);
	if (!ip->transparam)
		ip->transparam = mult_win_transparam_create(ip, ip->pan);
	if (!ip->label)
		ip->label = mult_win_label_create(ip, ip->pan);
	return ip;
}

/*
 * Create object `win' in the specified instance.

 */
Xv_opaque
mult_win_win_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	void		mult_done_proc();
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 316,
		XV_HEIGHT, 286,
		XV_LABEL, "Multiple Orbits",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_DONE_PROC, mult_done_proc,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `pan' in the specified instance.

 */
Xv_opaque
mult_win_pan_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `forwards' in the specified instance.

 */
Xv_opaque
mult_win_forwards_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mult_forwards_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 8,
		XV_WIDTH, 74,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Forwards",
		PANEL_NOTIFY_PROC, mult_forwards_notify,
		NULL);
	return obj;
}

/*
 * Create object `backwards' in the specified instance.

 */
Xv_opaque
mult_win_backwards_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mult_backwards_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 8,
		XV_WIDTH, 82,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Backwards",
		PANEL_NOTIFY_PROC, mult_backwards_notify,
		NULL);
	return obj;
}

/*
 * Create object `contin' in the specified instance.

 */
Xv_opaque
mult_win_contin_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mult_continue_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 204,
		XV_Y, 8,
		XV_WIDTH, 74,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Continue",
		PANEL_NOTIFY_PROC, mult_continue_notify,
		NULL);
	return obj;
}

/*
 * Create object `images' in the specified instance.

 */
Xv_opaque
mult_win_images_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	mult_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 36,
		XV_WIDTH, 161,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Images:",
		PANEL_VALUE_X, 74,
		PANEL_VALUE_Y, 36,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 9999,
		PANEL_MIN_VALUE, 1,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, mult_text_notify,
		NULL);
	return obj;
}

/*
 * Create object `load' in the specified instance.

 */
Xv_opaque
mult_win_load_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mult_load_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 64,
		XV_WIDTH, 88,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Load Points",
		PANEL_NOTIFY_PROC, mult_load_notify,
		NULL);
	return obj;
}

/*
 * Create object `copy' in the specified instance.

 */
Xv_opaque
mult_win_copy_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		mult_copy_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 128,
		XV_Y, 64,
		XV_WIDTH, 139,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Copy Final to Initial",
		PANEL_NOTIFY_PROC, mult_copy_notify,
		NULL);
	return obj;
}

/*
 * Create object `info' in the specified instance.

 */
Xv_opaque
mult_win_info_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 96,
		XV_WIDTH, 103,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "No points loaded",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `loadchoice' in the specified instance.

 */
Xv_opaque
mult_win_loadchoice_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		mult_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 116,
		XV_WIDTH, 101,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 56,
		PANEL_VALUE_Y, 116,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Load:",
		PANEL_NOTIFY_PROC, mult_settings_notify,
		PANEL_CHOICE_STRINGS,
			"Rectangle",
			"Region",
			0,
		NULL);
	return obj;
}

/*
 * Create object `transformation' in the specified instance.

 */
Xv_opaque
mult_win_transformation_create(ip, owner, n)
	caddr_t		ip;
	Xv_opaque	owner;
        int n;
{
	extern int		mult_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 144,
		XV_WIDTH, 204,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 132,
		PANEL_VALUE_Y, 144,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, n,
		PANEL_LABEL_STRING, "Transformation:",
		PANEL_NOTIFY_PROC, mult_settings_notify,
		PANEL_CHOICE_STRING, 0, "Identity",
		NULL);
	return obj;
}

/*
 * Create object `transparam' in the specified instance.

 */
Xv_opaque
mult_win_transparam_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
  extern Panel_setting mult_text_notify();
  
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 172,
		XV_WIDTH, 146,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Parameter:",
		PANEL_VALUE_X, 130,
		PANEL_VALUE_Y, 172,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
			PANEL_NOTIFY_PROC, mult_text_notify,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `label' in the specified instance.

 */
Xv_opaque
mult_win_label_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 200,
		XV_WIDTH, 185,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "Size           Number of Points",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `radius' in the specified instance.

 */
Xv_opaque
mult_win_radius_create(ip, owner,i)
	caddr_t		ip;
	Xv_opaque	owner;
        int i;
{
	extern Panel_setting	mult_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 224,
		XV_WIDTH, 80,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "x",
		PANEL_VALUE_X, 72,
		PANEL_VALUE_Y, 224+20*i,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, mult_text_notify,
		NULL);
	return obj;
}

/*
 * Create object `points' in the specified instance.

 */
Xv_opaque
mult_win_points_create(ip, owner,i)
	caddr_t		ip;
	Xv_opaque	owner;
        int i;
{
	extern Panel_setting	mult_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 224,
		XV_WIDTH, 76,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, ":",
		PANEL_VALUE_X, 180,
		PANEL_VALUE_Y, 224+20*i,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, mult_text_notify,
		NULL);
	return obj;
}

