/*
   hello.c
   Copyright (C) 1998 Ulric Eriksson <ulric@edu.stockholm.se>
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Label.h>

static Widget topLevel;

/* Plugin stuff */
static void win(char *p)
{
	printf("250 %lx\n", (unsigned long) XtWindow(topLevel));
}

static void quit(char *p)
{
	printf("221 Over and out\n");
	exit(0);
}

static struct {
	char *verb;
	void (*cb) (char *);
} plugin_cmds[] = {
	{"WIN", win},
	{"QUIT", quit},
	{ NULL, NULL }
};

static void read_plugin_cmd(XtPointer client_data, int *fid, XtInputId * id)
{
	char b[1024], *p;
	int i, n;

	if ((n = read(*fid, b, 1020)) == -1)
		return;

	b[n] = '\0';
	if ((p = strchr(b, '\n')) == NULL) {
		printf("501 Incomplete command\n");
		fflush(stdout);
		return;
	}
	*p = '\0';
	for (i = 0; plugin_cmds[i].verb; i++) {
		if (!strncmp(b, plugin_cmds[i].verb,
			     strlen(plugin_cmds[i].verb)))
			break;
	}
	if (plugin_cmds[i].verb)
		(*plugin_cmds[i].cb) (b + strlen(plugin_cmds[i].verb));
	else
		printf("500 What are you talking about\n");
	fflush(stdout);
}

void mainloop(void)
{
	XtAppAddInput(XtWidgetToApplicationContext(topLevel),
		fileno(stdin), (XtPointer) XtInputReadMask,
		read_plugin_cmd, NULL);
	printf("220 Hello plugin\n");
	fflush(stdout);

	XtAppMainLoop(XtWidgetToApplicationContext(topLevel));
}


int main(int argc, char **argv)
{
	XtAppContext ac;

	topLevel = XtAppInitialize(&ac, "Hello",
		NULL, 0, &argc, argv, NULL, NULL, 0);
	XtVaCreateManagedWidget("hello",
		labelWidgetClass, topLevel,
		XtNlabel, "Hello, World", (char *)0);
	XtRealizeWidget(topLevel);

	mainloop();
	return 0;
}

