#!/usr/bin/perl
#  rep-txn-by-cat.pl - Prints a report of the transactions sorted by category.
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: shrt-by-cat.pl,v 1.1.1.1 1999/12/18 02:07:09 curt Exp $


package CBB;

use strict;    # don't take no guff


my($tmp, $temp, $cbb_incl_dir);
my($credit_total, $debit_total);
my($subtotal);
my($result, $amt, $cmt, $lkey, $lcat);
my($tamt, $tcat, $tcom);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($nicecat, $cutdesc, $mon, $day, $year, $nicedate);
my(@keys, @splits);
my($name, $account);


# specify the installed location of the necessary pieces.
BEGIN {
$CBB::cbb_incl_dir = "..";
unshift(@INC, $CBB::cbb_incl_dir);
}

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] accounts";


# process arguments

my($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

my(%ALLTRANS) = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

my(%tmp_cat) = ();

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

            $ALLTRANS{"$key$name"} = $result;

            if ( substr($cat, 0, 1) ne "|" ) {
                $tmp_cat{$cat} .= "$key$name" . "," . $amt . ",";
            } else {
                # process split

                @splits = split(/\|/, $cat);
                shift(@splits);

                $tmp = 0;
                while ( $#splits >= 0 ) {
                    $tcat = shift(@splits);
                    $tcom = shift(@splits);
                    $tamt = shift(@splits);

                    $tmp += $tamt;

                    # print "processing $tcat $tamt\n";
                    $tmp_cat{$tcat} .= "$key$name" . "," . $tamt . ",";
                }
                if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
                    printf("WARNING:  Incorrect splits in $date: $desc\n");
                    printf("    %.2f != %.2f\n\n", $tmp, $amt);
                }
            }
        }

        $result = &next_trans();
    }
}


$credit_total = 0.00;
$debit_total = 0.00;

foreach $lcat (sort keys(%tmp_cat)) {
    chop($tmp_cat{$lcat});  # Delete final comma

    &spad($lcat,35);

    @keys = split(/,/, $tmp_cat{$lcat});

    $subtotal = 0.00;

    while ( $#keys >= 0 ) {
        $lkey = shift(@keys);
        $amt  = shift(@keys);

        $result = $ALLTRANS{$lkey};

        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $subtotal = $subtotal + $amt;
        if ( $amt > 0 ) {
            $credit_total = $credit_total + $amt;
        } else {
            $debit_total = $debit_total + $amt;
        }

        &format_line( $result, $amt );
    }

    printf(" = %9.2f\n", $subtotal);
}

printf("                                      ---------\n" );
printf("                      Total Credits = %9.2f\n\n", $credit_total);

# printf("                                         ---------\n" );
printf("                       Total Debits = %9.2f\n\n", $debit_total);

# printf("                                         ---------\n" );
printf("                            Balance = %9.2f\n\n", 
       $credit_total + $debit_total);


# $foo is the string to write, $num is the number of spaces to pad
# note:  it does not print a newline.
sub spad {
    my($foo, $num) = @_;
    my($i);

    for ( $i = length($foo); $i < $num; $i++) {
                print " ";
    }
    print "$foo";
}


sub format_line {
    my($result, $amt) = @_;

    my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $result);

    ($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    $year = substr($year, 2, 4);
    if ( $date_fmt == 1 ) {
	$nicedate = "$mon/$day/$year";
    } else {
	$nicedate = "$day.$mon.$year";
    }
    $cutdesc = substr($desc, 0, 20);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

#   printf("  %5s  %-8s  %-20s  %9.2f  %-1s\n",
#         $check, $nicedate, $cutdesc, $amt, $cleared);
}
