/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * pr_synch.c,v 3.3 1998/03/29 23:03:12 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"


/*
 * In the PJL manual, Chapter 9, Section: Determining if printer status
 * readback is available it states that if the application does not
 * receive a response within three seconds, then the application can 
 * assume printer status readback is currently unavailable.
 */

int pr_synch(int fd, int timeout)
{
	int   synchronised = 0, fftries = 0;
	char buf[MAXLINE+1];
	char sync[MAXLINE+1];
	char timed[MAXLINE+1];
	int len;
	int i = 0;
	long starttime, newtime, inittime;
	int delay;

	if( wait_time <= 0 ) wait_time = 30;
	if( timeout <= 0 ) timeout = wait_time;

	log(2,"Synchronisation attempt starting, %d sec timeout", timeout);
	
	starttime = time( (time_t *)0 );
	inittime = starttime;
	/* Table 4.1 of the PCL Printer Technical Manual indicates this order */
	query[i++]=UEL;
	if( !nopjl) query[i++]=UELPJL;
	/* There are reports that the USTPJLOFF command causes screwups
	   with status reports */
	/* query[i++]=USTPJLOFF; */
	query[i++]=USTPJLDEV;
	query[i++]=USTPJLJOB;
	if( true_eoj ) query[i++]=TRUEEOJ;
	(void)plp_snprintf(timed,sizeof(timed)-1,USTPJLTIMED, wait_time);
	query[i++]=timed;
	(void)plp_snprintf(sync,sizeof(sync)-1,"Seq %d",getpid());
	(void)plp_snprintf(buf,sizeof(buf)-1,"@PJL ECHO %s\r\n",sync);
	query[i++]=buf;
	if( infostatus ) query[i++]=INFOSTATUS; /* job status on */

	delay = 5;
	do{
		pr_query(fd, i);
		log(2,"Synchronization: waiting %d, attempt %d", delay, ++fftries );
		len = readpipe((int *)0,delay);
		if( len < 0 ){
			break;
		}
		if( strstr(readprin,sync) ) {
			synchronised = TRUE;
		} else if( strstr(readprin, "@PJL ECHO") ) {
			log(3,"pr_synch: synch from previous job '%s'", readprin);
		}
		if( !synchronised ){
			/* increase the waiting time */
			if( delay < timeout ) delay += delay;
			newtime = time( (time_t *)0 );
			if( (newtime - starttime) > timeout ){
				starttime = newtime;
				len = newtime - inittime;
				log(0,"No response from printer for %d secs; offline?", len );
			}
		}
	} while( !synchronised );
	if( synchronised ) log(2,"Synchronised with printer");
	return( synchronised );
}

void header_info()
{
	int i = 0;
	if (model != IIISi) {
		query[i++]=UEL;
		if( !nopjl) query[i++]=UELPJL;
	}
	pr_query(STDOUT, i);
}

void trailer_info()
{
	int i = 0;
	if (model != IIISi) {
		query[i++]=UEL;
		if( !nopjl) query[i++]=UELPJL;
	}
	pr_query(STDOUT, i);
}
