/*
 * lftp and utils
 *
 * Copyright (c) 1998 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LISTINFO_H
#define LISTINFO_H

#include "SMTask.h"
#include "FileSet.h"

class ListInfo : public SMTask
{
protected:
   bool done;
   char *error_text;
   FileSet *result;

   const char *path;
   regex_t *rxc_exclude;
   regex_t *rxc_include;

   void SetError(const char *);

   unsigned need;
   bool use_cache;
   bool follow_symlinks;

public:
   ListInfo();
   virtual ~ListInfo();

   virtual int Do() = 0;
   bool Done() { return done; }
   bool Error() { return error_text!=0; }
   const char *ErrorText() { return error_text; }

   virtual const char *Status() = 0;
   virtual void SetExclude(const char *p,regex_t *x,regex_t *i);

   FileSet *GetResult()
      {
	 FileSet *tmp=result;
      	 result=0;
	 return tmp;
	 // miss := (assign and return old value) :(
      	 // return result:=0;
      }

   void Need(unsigned mask) { need|=mask; }
   void NoNeed(unsigned mask) { need&=~mask; }
   void UseCache() { use_cache=true; }
   void FollowSymlinks() { follow_symlinks=true; }
};

#endif//LISTINFO_H
