!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  basicio.S
!* Purpose: Basic I/O functions for DOS simulator
!* Entries: dos01, dos02, dos03, dos04, dos05, dos06, dos07, dos08, dos09,
!*          dos0A, dos0B, dos0C
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./dospriv.inc"


!
!**************************************************************************
!
! Miscalleneous equates
!
AUX_INIT	equ	$A3		! AUX port initialization value:
					!  2400 Baud, no parity, 1 stop bit,
					!  8 data bits


!
!**************************************************************************
!
! BSS segment
!
	.bss

	extrn	dos1_regs
	extrn	dos2_regs

#ifdef NEEDEXTIO
! BSS gets initialized to zero automatically, so no need to specify a
! data value here.
	.comm	auxflag,1		! flag if serial port initialized
	.comm	prnflag,1		! flag if printer port initialized
#endif


!
!**************************************************************************
!
! Start code segment.
!
	.text

#ifdef NEEDLINEIO
#ifdef NEEDFILEIO
	extrn	dos3F
#endif
#endif

	public	dos01, dos02, dos03	! define entry points
	public	dos04, dos05, dos06
	public	dos07, dos08, dos09
	public	dos0A, dos0B, dos0C


!
!**************************************************************************
!
! Read character from keyboard and then send it to the screen
! Input:  none
! Output: AL  -  character
! Registers changed: AL
!
dos08:
dos07:
dos01:

	push	bx
	mov	bh,ah			! save AH
	call	keywait			! wait for character from keyboard
	mov	bl,al
	cmp	bh,#1			! only print character with fn $01
	jne	dos011
	int	$29			! print character
dos011:	mov	ax,bx			! restore AH
	pop	bx
	ret


!
!**************************************************************************
!
! Print character onto screen
! Input:  DL  -  character
! Output: none
! Registers changed: none
!
dos02:

	push	ax
	mov	al,dl
	int	$29			! print character
	pop	ax
	ret


!
!**************************************************************************
!
! Receive character on serial port COM1
! Input:  none
! Output: AL  -  character
! Registers changed: AL
!
dos03:

#ifdef NEEDEXTIO
	push	bx
	mov	bh,ah
	mov	al,#DEV_AUX
	call	devinit			! initialize serial device
	mov	ah,#$02
	int	$14			! receive character
	mov	ah,bh			! restore AH
	pop	bx
#endif

	ret


!
!**************************************************************************
!
! Send character to serial port COM1
! Input:  DL  -  character
! Output: none
! Registers changed: none
!
dos04:

#ifdef NEEDEXTIO
	push	ax
	push	dx
	mov	al,#DEV_AUX
	call	devinit			! initialize serial device
	pop	ax
	push	ax			! restore character
	mov	ah,#$01
	int	$14			! send character
	pop	dx
	pop	ax
#endif

	ret


!
!**************************************************************************
!
! Send character to printer port
! Input:  DL  -  character
! Output: none
! Registers changed: none
!
dos05:

#ifdef NEEDEXTIO
	push	ax
	push	dx
	mov	al,#DEV_PRN
	call	devinit			! initialize parallel port
	pop	ax
	push	ax			! restore character
	xor	ah,ah
	int	$17			! send character
	pop	dx
	pop	ax
#endif

	ret


!
!**************************************************************************
!
! Direct console I/O
! Input:  DL  -  character for console output, or $0FF for console input
! Output: AL  -  character from console input, or 0 for console output
! Changed registers: AL
!
dos06:

	xor	al,al
	cmp	dl,#$0FF		! check for function
	jne	dos02			! print character

	call	keycheck		! get character from keyboard
	jz	dos068			! got no character
	xor	ah,ah
	int	$16			! get character from buffer
	or	dl,dl			! reset zero flag
	jmp	dos069
dos068:	xor	al,al			! set return value 0
dos069:	mov	ah,#$06			! restore AH
	ret


!
!**************************************************************************
!
! Print character string onto screen. String is terminated by '$' character.
! Input:  DS:DX  -  pointer to string
! Output: none
! Registers changed: none
!
dos09:

	cld
	push	ax
	push	si
	push	es
	mov	es,old_ds[bp]		! get callers DS
	mov	si,dx
dos091:	seg	es
	lodsb				! get next character
	cmp	al,#$24			! end of string?
	je	dos092
	int	$29			! print character
	jmp	dos091			! proceed with next character

dos092:	pop	es
	pop	si
	pop	ax
	ret


!
!**************************************************************************
!
! Read string from keyboard. The first character of the buffer contains
! the buffer size, the next character will receive the actual number
! of characters read.
! Input:  DS:DX  -  pointer to buffer
! Output: none
! Registers changed: none
!
dos0A:

#ifndef NEEDLINEIO

	push	es
	push	bx
	mov	es,old_ds[bp]
	mov	bx,dx			! simply mark the buffer as
	seg	es			! empty
	mov	byte ptr [bx+1],#0
	pop	bx
	pop	es
	ret

#else					! NEEDLINEIO

	push	ax
	push	bx
	push	di
	push	es
	mov	es,old_ds[bp]
	mov	di,dx
	xor	bx,bx			! BX - offset into buffer

dos0A1:	seg	es
	cmp	bl,[di]			! end of buffer reached?
	jae	dos0A4
	call	keywait			! get next character

	cmp	al,#CHR_BS		! backspace?
	jne	dos0A2
	or	bx,bx			! dont delete past beginning of
	jz	dos0A1			! buffer
	dec	bx			! kill character in the buffer and
	jmp	dos0A5			! on the screen

dos0A2:	cmp	al,#CHR_RET		! carriage return?
	je	dos0A3
	seg	es
	mov	[di+bx+2],al		! save character
	inc	bx
dos0A5:	int	$29			! and print it
	jmp	dos0A1

dos0A3:	int	$29
	mov	al,#CHR_LF		! print CR/LF
	int	$29
dos0A4:	seg	es
	mov	[di+1],bl		! save length in the buffer
	pop	es
	pop	di
	pop	bx
	pop	ax
	ret

#endif					! NEEDLINEIO


!
!**************************************************************************
!
! Get keyboard status
! Input:  none
! Output: AL  -  $0FF -> key pressed, 000h -> no key pressed
! Changed registers: AL
!
dos0B:

	call	keycheck		! check BIOS keyboard buffer
	jz	dos0B9			! no character in buffer
	mov	al,#$0FF		! yes, we have a character available
dos0B9:	mov	ah,#$0B			! restore AH
	ret


!
!**************************************************************************
!
! Clear input buffer and then call input routine.
! Input:  AL  -  input function number
! Output: AL  -  input character
! Registers changed: depending on input function
!
dos0C:

	push	ax
dos0C1:	mov	ah,#$01			! get keyboard status (dont use
	int	$16			! keycheck here - not necessary)
	jz	dos0C2			! no more characters in buffer
	xor	ah,ah
	int	$16			! get character from input buffer
	jmp	dos0C1			! repeat until buffer empty

dos0C2:	pop	ax
	cmp	al,#$06
	je	dos06			! call DOS function 06
	cmp	al,#$0A
	je	dos0A			! call DOS function 0A

dos0C6:	mov	ah,al
	jmp	dos01			! call DOS function 01


!
!**************************************************************************
!
! Check BIOS for a key press
! Input:  none
! Output: AL  -  character
!         Zero flag reset if character found in buffer
! Registers changed: AX
!
keycheck:

	cmp	bp,#dos1_regs
	jne	keych1
	push	es
	push	ds
	pushall
	int	$28			! care for "multitasking" interrupt
	popall				! only if the correct stack is active
	pop	ds
	pop	es
keych1:	mov	ah,#$01
	int	$16			! check BIOS keyboard buffer
	jnz	keych9			! found character in buffer
	xor	al,al			! no character found in buffer
keych9:	ret


!
!**************************************************************************
!
! Wait for a key press
! Input:  none
! Output: AL  -  character
! Registers changed: AX
!
keywait:

keyw1:	call	keycheck		! wait for key to be pressed
	jz	keyw1
	xor	ah,ah
	int	$16			! get character from keyboard
	ret


#ifdef NEEDEXTIO
!
!**************************************************************************
!
! Initialize a device.
! Input:  AL  -  device type (CON, AUX, PRN)
! Output: none
! Registers changed: AX
!
devinit:

	push	dx
	mov	ah,#1			! default device flag
	xor	dx,dx			! default device number

! Initialize serial port

	cmp	al,#DEV_AUX
	jne	devin2
	xchg	ah,auxflag		! already initialized?
	or	ah,ah
	jnz	devin9
	mov	ax,#AUX_INIT
	int	$14			! initialize serial port
	jmp	devin9

! Initialize parallel port

devin2:	cmp	al,#DEV_PRN
	jne	devin9
	xchg	ah,prnflag		! already initialized?
	or	ah,ah
	jnz	devin9
	mov	ah,#$01
	int	$17			! initialize printer port

devin9:	pop	dx
	ret

#endif					! NEEDEXTIO


!
!**************************************************************************
!
	end

