/*
 * io.c  -  Terminal I/O routines
 *
 * Copyright (C) 1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include "romcheck.h"



/*
 * Flush the input and output queues and wait for a character
 */
char waitchar()
{
  /* This routine is in module bios_vid.o only in the standalone library */
  extern int bios_getc __P((void));

  fflush(stdout);
  fflush(stdin);
  return(tolower(bios_getc() & 0x00ff));
}



/*
 * Read a decimal integer number.
 */
int readint(prompt, minval, maxval, defval)
char *prompt;
int minval, maxval, defval;
{
  int i, num;

  while (TRUE) {
	if (prompt != NULL)
		printf("%s [%d to %d]: ", prompt, minval, maxval);
	fflush(stdout);
	fflush(stdin);
	if ((i = scanf("%d", &num)) == EOF)
		return(defval);
	else if (i != 1)
		printf("You have to enter a decimal number\n");
	else if (num < minval || num > maxval)
		printf("Entry out of range\n");
	else
		return(num);
  }
}



/*
 * Read an unsigned hex integer number.
 */
unsigned int readhex(prompt, minval, maxval, defval)
char *prompt;
unsigned int minval, maxval, defval;
{
  unsigned int num;
  int i;

  while (TRUE) {
	if (prompt != NULL)
		printf("%s [%04X to %04X hex]: ", prompt, minval, maxval);
	fflush(stdout);
	fflush(stdin);
	if ((i = scanf("%x", &num)) == EOF)
		return(defval);
	else if (i != 1)
		printf("You have to enter a hex number\n");
	else if (num < minval || num > maxval)
		printf("Entry out of range\n");
	else
		return(num);
  }
}

