/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include "main.h"
#include <ctype.h>

extern void set_tty(int);
extern void warranty(void);

void shost(int num, int *portn, short strnum)
{
   char *name=NULL, str[SONAME], *tmpstr=NULL, *stra=NULL, *stre=NULL;
   FILE *fp=NULL;
   int i, port=0;

   if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) {
      fprintf(stderr, "**\n** There is no pftp resource file in your home directory. Please, rtfm!\n**\n");
      exit(1);
   }
   fgets(str, SONAME, fp);
   if (!atoi(str)) rewind(fp);
   num++;
   for (i=1; i < num && fgets(str, SONAME, fp); i++) {
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) {
         i--;
         continue;
      }
      if (!strncmp("PFTP", str, 4)) i--;
   }

   /*
    * Get host name.
    */
   if (i == num) {
      MEM_CHECK((name = (char *) calloc(SONAME, sizeof(char))));
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (*stre) port = atoi(stre);
      strcpy(name, stra);
      for (tmpstr=name; *tmpstr && *tmpstr != ':' && *tmpstr != '@'; tmpstr++);
      if (*tmpstr == ':') {
         char *tmpp=NULL;
         MEM_CHECK(((*statstr)->rlogin = (char *) calloc(SONAME, sizeof(char))));
         MEM_CHECK(((*statstr)->rpass = (char *) calloc(SONAME, sizeof(char))));
         *tmpstr = '\0';
         tmpp = ++tmpstr;
         strcpy((*statstr)->rlogin, name);
         for (; *tmpstr && *tmpstr != '@'; tmpstr++);
         if (*tmpstr == '@') {
            *tmpstr = '\0';
            strcpy((*statstr)->rpass, tmpp);
            strcpy(name, ++tmpstr);
         }
         else {
            fclose(fp);
            if (slfp) fprintf(slfp, "** invalid host name entry.");
            exit(1);
         }
      }
      else if (*tmpstr == '@') {
         MEM_CHECK(((*statstr)->rlogin = (char *) calloc(SONAME, sizeof(char))));
         *tmpstr = '\0';
         strcpy((*statstr)->rlogin, name);
         strcpy(name, ++tmpstr);
      }
   }
   else {
      fclose(fp);
      if (slfp) fprintf(slfp, "** Host number %d is not registered in your host name list!\n", (int)num);
      exit(1);
   }

   /*
    * Set host name.
    */
   if ((*statstr)->_HOSTNAME_) free((*statstr)->_HOSTNAME_);
   MEM_CHECK(((*statstr)->_HOSTNAME_ = (char *) calloc(SONAME, sizeof(*name))));
   strcpy((*statstr)->_HOSTNAME_, name);

   free(name);

   if (port) *portn = port;
   fclose(fp);
}


void lhost(char *name, int *portn, short strnum)
{
   FILE *fp;
   char c=0, str[SONAME], *stra=NULL, *stre=NULL, *tmpstr=NULL;
   char *blankline=NULL, *listentry[HUNAME], **ltmp=NULL;
   int tmp, num=0, endnum=0;
   long position=0;

   if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) {
      if (getuid()) {
         if (slfp) fprintf(slfp, "**\n** There is no pftp resource file in your home directory. Please, rtfm!\n**\n");
         exit(1);
      }
      else if (!getuid()) {
         *portn = INETD_PORT;
         pftpnoroot = 1;
         return;
      }
   }

   /*
    * Read first line for compatibility with older pftprcs.
    */
   *str = '\0';
   fgets(str, SONAME, fp);
   if ((tmp = atoi(str))) {
      if (*portn < 1) {
         *portn = tmp ? tmp : 0;
         if (getuid()) return;
      }
   }
   else rewind(fp);

   /*
    * Get variables from resource file.
    */
   while (!c) {
      tmp = 0;
      position = ftell(fp);
      if (!fgets(str, SONAME, fp)) break;
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) continue;
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      /*
       * Check variables.
       */
      if (!strcmp("PFTPLOGFILE", stra)) {
         (*statstr)->lognames = atoi(stre)? 1: 0;
      }
      else if (!strcmp("PFTPNOROOT", stra)) {
         pftpnoroot = atoi(stre)? 1: 0;
      }
      else if (!strcmp("PFTPPORT", stra)) {
         if (*portn < 1) {
            if (*stre) *portn = atoi(stre);
            return;
         }
      }
      else if (!strcmp("PFTPLOG", stra)) {
         if (!(pftplog = getenv("PFTPLOG")) && !strcmp("PFTPLOG", stra)) {
            if (!pftplog && *stre) {
               char *tu=stre;
               for (stre++; *stre && *stre != ' ' && *stre != '\t'; stre++);
               *stre = '\0';
               if (*tu) {
                  MEM_CHECK((pftplog = (char *) calloc(SONAME, sizeof(char))));
                  strcpy(pftplog, tu);
               }
            } 
         }
      }
      else if (!strncmp("PFTP", stra, 4));
         /* The following variables are recognized:
          *    
          *    PFTPCLIENTS
          *    PFTPBANDWID
          *    PFTPSFILTER
          *    PFTPCFILTER
          *    PFTPRECEIVE
          *    PFTPUPLIMIT
          *    PFTPEDITOR
          *    PFTPNETBUF
          *    PFTPPAGER
          *    PFTPPASS
          *    PFTPSLOG
          */
      else {
         if (fseek(fp, position, 0)) {
            fprintf(stderr, "** %s: %s\n", (*(statstr+strnum))->home, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         break;
      }
   }

   /*
    * Read host name list entries.
    */
   for (ltmp=listentry, endnum=0; fgets(str, SONAME, fp); endnum++) {
      tmp = *portn;
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) {
         --endnum;
         continue;
      }
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (*stre && atoi(stre)) tmp = atoi(stre);
      for (tmpstr=str; *tmpstr && *tmpstr != ':' && *tmpstr != '@'; tmpstr++);
      if (*tmpstr == ':') {
         *tmpstr = '\0';
         for (tmpstr++; *tmpstr && *tmpstr != '@'; tmpstr++);
         if (*tmpstr == '@') strcat(str, tmpstr);
      }
      MEM_CHECK((*ltmp = (char *) calloc(SONAME, sizeof(char))));
      sprintf(*ltmp, " %3d) %-36.36s %6d", endnum+1, str, tmp);
      for (stra=*ltmp; *stra; stra++);
      for (; stra - *ltmp < _WINCOLS_ - 1; stra++) *stra = ' ';
      *stra = '\n';
      *++stra = '\0';
      ltmp++;
   }
   *ltmp = NULL;
   fclose(fp);
   endnum--;

   /*
    * Create host name list.
    */
   if (name) {
      if (*name == 'l') {
         char hn[14], *pattern=NULL, ch='\0';
         int i=0, j=0, h, height=0, plength=0, last=0, defhost=0;
         int scrollup=0, scrolldown=0;
         c = '0';
         num = 0;

         MEM_CHECK((pattern = (char *) calloc(SONAME, sizeof(char))));
         *pattern = '\0';
         MEM_CHECK((blankline = (char *) calloc(SONAME, sizeof(char))));
         for (num=1; num < _WINCOLS_ && num < SONAME; num++) *(blankline+num-1) = ' ';
         *(blankline+num-1) = '\r';
         *(blankline+num) = '\0';
         num = 0;

         /*
          * Check if running in non-silent mode.
          */
         if (!slfp) {
            fprintf(stderr, "** Started in silent mode: Cannot output the host list.\n");
            exit(1);
         }

         /*
          * Set _WINROWS_.
          */
         set_tty(2);

         /*
          * Print list on screen.
          */
         height = _WINROWS_ - 4;
         fprintf(stderr, "[H[J\r");
         for (;;) {
            if (num + height > endnum) {
               num = endnum-height+1;
               scrollup = 0;
            }
            if (num < 0) {
               num = 0;
               scrolldown = 0;
            }
            if (scrollup) {
               fprintf(stdout, "[3;%dr[4H>[%dH", _WINROWS_-1, scrollup+4);
            }
            else if (scrolldown) {
               fprintf(stdout, "[3;%dr[3HM[3H", _WINROWS_-2);
            }
            else {
               fprintf(stdout, "[1;%dr", _WINROWS_);
               if (num + height > endnum && endnum >= height) fprintf(stdout, "[%dH** End of list reached.", _WINROWS_-1);
               else fprintf(stdout, "[%dH%s", _WINROWS_-1, blankline);
               fprintf(stdout, "[H******* Host name(s) ****************** Port number(s) [%d] ******",*portn);
               fprintf(stdout, "[%dH", scrollup+3);
            }
            for (j=num+scrollup; j < height + num - scrolldown && j <= endnum; j++) {
               fprintf(stdout, "%s%s", defhost == j ? ">": " ", *(listentry+j));
            }
            fprintf(stdout, "[%dH%3d%% <q> quit, </> search, < > more, <b> back, <NUM> select host[%d]: ",
            _WINROWS_, height <= endnum ? ((num+height-1)*100)/endnum: 100, defhost+1);
            fflush(stdout);

            c = '0'; i = 0; *hn = '\0';
            scrollup = scrolldown = 0;

            while (isdigit(c) || c == '' || c == '') {
               while ((c = fgetc(stdin)) == '' || c == '[');
               switch(c) {
                  case 'G':
                     num = endnum;
                     break;
                  case 'g':
                     num = 0;
                     break;
                  case 'q':
                     for (ltmp=listentry+endnum; ltmp+1 != listentry; ltmp--) free(*ltmp);
                     fprintf(stdout, "quit[1;%dr[%dH\n", _WINROWS_, _WINROWS_);
                     set_tty(0);
                     exit(0);
                     break;
                  case '':
                     fprintf(stdout, "[H[J\r");
                     break;
                  case 'k': case 'A':
                     if (num) {
                        fprintf(stdout, "    ");
                        if (num + height > endnum) fprintf(stdout, "[%dH%s", _WINROWS_-1, blankline);
                        num--;
                        fprintf(stdout, "[%dH \n", defhost-num+2);
                        scrolldown = height - 1;
                     }
                     else c = '0';
                     break;
                  case 'j': case 'B':
                     if (endnum - num < height) c = '0';
                     else {
                        fprintf(stdout, "    ");
                        scrollup = height - 1;
                        num++;
                     }
                     break;
                  case 'b':
                     if (!num) c = '0';
                     else num -= height;
                     break;
                  case ' ':
                     if (endnum - num < height) c = '0';
                     else num += height;
                     break;
                  case '': case '':
                     if (i > 0) {
                        fputs("\b \b", stdout); 
                        hn[--i] = '\0';
                     }
                     break;
                  case '\n':
                     for (ltmp=listentry+endnum; ltmp+1 != listentry; ltmp--) free(*ltmp);
                     fprintf(stdout, "[1;%dr[%dH", _WINROWS_, _WINROWS_);
                     fprintf(stdout, "\r%s", blankline);  
                     fflush(stdout);
                     h = atoi(hn) ? atoi(hn) : defhost+1;
                     if (blankline) free(blankline);
                     if (pattern) free(pattern);
                     shost(h, portn, 0);
                     set_tty(0);
                     return;
                  case 'N':
                     last = num;
                     defhost--;
                     if (*pattern && (plength = strlen(pattern))) {
                        for (ltmp=listentry+defhost; ltmp+1 != listentry && plength; ltmp--) {
                           for (stra=*ltmp; *(stra+1); stra++) {
                              if (!strncmp(pattern, stra, plength)) {
                                 defhost = num = ltmp - listentry;
                                 plength = 0;
                              }
                           }
                        }
                     }
                     else {
                        fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                        fprintf(stderr, "** No search pattern.");
                        num = last;
                        c = '0';
                     }
                     if (plength) {
                        fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                        fprintf(stderr, "** `%s' not found.", pattern);
                        num = last;
                        c = '0';
                     }
                     break;
                  case 'n':
                     last = num;
                     defhost++;
                     if (*pattern && (plength = strlen(pattern))) {
                        for (ltmp=listentry+defhost; ltmp - listentry <= endnum && plength; ltmp++) {
                           for (stra=*ltmp; *(stra+1); stra++) {
                              if (!strncmp(pattern, stra, plength)) {
                                 defhost = num = ltmp - listentry;
                                 plength = 0;
                              }
                           }
                        }
                     }
                     else {
                        fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                        fprintf(stderr, "** No search pattern.");
                        num = last;
                        c = '0';
                     }
                     if (plength) {
                        fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                        fprintf(stderr, "** `%s' not found.", pattern);
                        num = last;
                        c = '0';
                     }
                     break;
                  case '/':
                     fprintf(stdout, "[%dH                                                                       \r", _WINROWS_);
                     fprintf(stdout, "[%s]: ", pattern);
                     plength = 0;
                     last = num;
                     stra = str;
                     *stra = '\0';
                     do {
                        ch = fgetc(stdin);
                        switch(ch) {
                           case '\n':
                              *stra = '\0';
                              ch = '\0';
                              break;
                           case '':
                              *str = '\0';
                              plength = -1;
                              break;
                           case '': case '':
                              if (stra > str) {
                                 fprintf(stderr, "\b \b");
                                 *--stra = '\0';
                              }
                              plength--;
                              break;
                           default:
                              if (isprint(ch)) {
                                 plength++;
                                 *stra++ = ch;
                                 fprintf(stderr, "%c", ch);
                              }
                              break;
                        }
                     } while (ch && plength >= 0);
                     if ((!*pattern && !plength) || plength < 0) break;
                     if ((plength = strlen(str))) strcpy(pattern, str);
                     if ((plength = strlen(pattern))) {
                        defhost++;
                        for (ltmp=listentry+defhost; ltmp - listentry <= endnum && plength; ltmp++) {
                           for (stra=*ltmp; *(stra+1); stra++) {
                              if (!strncmp(pattern, stra, plength)) {
                                 defhost = num = ltmp - listentry;
                                 plength = 0;
                              }
                           }
                        }
                     }
                     if (plength) {
                        defhost--;
                        fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                        fprintf(stderr, "** `%s' not found.", pattern);
                        num = last;
                        c = '0';
                     }
                     break;
                  case 'w':
                     fprintf(stderr, "[?25l");
                     warranty();
                     fprintf(stderr, "[?25h\r");
                     break;
                  default:
                     if (isdigit(c) && i < 10) {
                        fputc(c, stdout);
                        hn[i++] = c;
                        hn[i] = '\0';
                     }
                     else c = '0';
               }
               if (c != '' && c != 'n' && c != 'N' && c != '/') {
                  defhost = num - (c == 'G' || c == 'g' ? height: 1) + 1;
                  if (defhost < 0) defhost = 0;
                  if (c == ' ' && defhost > endnum - height + 1) defhost = endnum - height + 1;
               }
            }
         }
      }
      else if (isdigit(*name)) {
            num = atoi(name);
            shost(num, portn, strnum);
            return;
      }
   }
}


short get_var_from_pftprc(const char *name, char *value, short strnum)
{
   FILE *fp=NULL;
   char *str=NULL, *stra=NULL, *stre=NULL;
   *value = '\0';

   if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) {
      return 0;
   }

   MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));

   while (!*value) {
      if (!fgets(str, SONAME, fp)) break;
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) continue;
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (!*stre) continue;
      if (!strcmp(name, stra)) {
         strcpy(value, stre);
         if (str) free(str);
         fclose(fp);
         return 1;
      }
   }
   if (str) free(str);
   fclose(fp);
   return 0;
}
