
# Description:  The Tcl/Tk code you find here realizes some 
#               CTCP-commands like LEAVE, OP, BANS, etc.?
#               If you installed it, send yourself a CTCP-HELP
#               with `/ctcp <nick> help' and you will understand.
#
# Date:         10.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      10.03.98  Small bug fixed for CTCP-XBANS.
#               03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
#               06.11.97  CTCP-XBANS altered. (%1%)
#               18.10.97  Empty baninfos after netjoin fixed.
#               17.10.97  Little bug in CTCP-INVITE fixed.
#               09.09.97  Some improvements done. =:^)
#               07.09.97  CTCP-INVITE added. Matching bans will be removed
#                         and an /invite will be executed.
#               28.08.97  Minor bug fixed. Sometimes nicknames with "^"
#                         were not correctly displayed. 
#               01.08.97  Leave-message on CTCP-LEAVE implemented.
#                 [..]
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/ctcp-support.tcl'
#               2. edit lists `ctcp_xlist' and `ctcp_nooplist'
#                  (see the examples below)
#               3. reload your tkircrc or restart tkirc


# ctcp_xlist: Here you can add the address-pattern of users you want to
#             allow the usage of your ctcp-commands. Don't pay attention to
#             the prefixes used by IRC-servers ("^~+=-")!
global ctcp_xlist
set ctcp_xlist {
 "atte@gecko.north.de" "*@all.users.of.host" "user@does.not.exist"
}

# ctcp_nooplist: The CTCP-OP command has two optional parameters (`<nick2>'
#                and `<nick3>'). If someone (a member of your `ctcp_xlist')
#                sends you a CTCP-OP with additional nicknames and the 
#                addresses of these users match an element of your 
#                `ctcp_nooplist', they won't automatically get a `+o' from
#                you. -- Don't pay attention to the prefixes used by
#                IRC-servers ("^~+=-")!
global ctcp_nooplist
set ctcp_nooplist {
 "sucker@does.not.exist"
}

# ctcp_xtest: Does the address match one pattern of your
#             `ctcp_xlist'?
proc ctcp_xtest {address} {
  global ctcp_xlist
  set address "[StripAddressPrefix "$address"]"
  foreach x "$ctcp_xlist" {
    if {[strmatch "$x" "$address"]} { 
      return 1
    }
  }
  return 0
}

# ctcp_nooptest: Does the address match one pattern of your
#                `ctcp_nooplist'?
proc ctcp_nooptest {address} {
  global ctcp_nooplist
  set address "[StripAddressPrefix "$address"]"
  foreach x "$ctcp_nooplist" {
    if {[strmatch "$x" "$address"]} { 
      return 1
    }
  }
  return 0
}

# on_ctcprequest_ctcpextras: Members of `ctcp_xlist' can request an automatic
#                     reply or action for the following ctcp-commands:
#
#                     1. BANS <channel>
#                     2. [CH]OP <channel> [<nick2>] [<nick3>]
#                     3. LEAVE <channel>
#                     4. REJOIN <channel>
#                     5. INVITE <channel>
#                     6. XBANS <channel>
proc on_ctcprequest_ctcpextras { } {
  global on_args chan win nickname choplist

  if {[strcmp "$on_args(to)" "$nickname"] != 0} {
    return
  }
  switch -regexp -- "$on_args(command)" {
    {^(CH|)OP} {
      if {[ctcp_xtest "$on_args(address)"]} {
	if {[lLength "$on_args(rest)"] < 1} {
	  send2irc "/notice $on_args(nick) Usage: /ctcp $nickname op <channel> \[<nick2>\] \[<nick3>\]"
	} else {
	  set channel "[lIndex "$on_args(rest)" 0]"
	  set last "[cutwords "$on_args(rest)" 1]"
	  set i [lSearch "$last" "$on_args(nick)"]
	  if {$i != -1} {
	    set last "[lreplace "$last" $i $i]"
	  }
	  print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $channel ($on_args(nick)) $last"
	  AddToFilterQueue "\*\*\*?Unknown *"
	  set cnum [GetChannelNumber "$channel"]
	  if {$cnum != -1} {
	    if {[isOpOnChannel $cnum "$nickname"]} {
	      set os "" ; set nicks ""
	      set last "[expand "$on_args(nick) $last"]"
	      set len [llength "$last"]
	      for {set i 0} {$i < $len} {incr i} {
		# Ist der User berhaupt auf dem Kanal?
		if {[UserNumOfChannel $cnum [lindex "$last" $i]] != -1} {
		  # Ist der User evtl. schon Kanal-Operator?
		  if {[isOpOnChannel $cnum [lindex "$last" $i]] == 0} {
		    set adr "[AddressOfNick [lindex "$last" $i]]"
		    if {[string length "$adr"] && [ctcp_nooptest "$adr"]} {
		      continue
		    }
		    if {[lSearch "$nicks" "[lIndex "$last" $i]"] != -1} { 
		      continue
		    }
		    append os "o"
		    append nicks "[lindex "$last" $i] "
		    if {[string length "$os"] > 2} {
		      break
		    }
		  } elseif {$i == 0} {
		    send2irc "/notice $on_args(nick) Error: You are already operator on channel $channel"
		    return
		  }
	        } elseif {$i == 0} {
		  send2irc "/notice $on_args(nick) Error: You are not on channel $channel"
		  return
		}
 	      }
	      # If less than 3 nicks were selected and you have also installed
	      # the tkirc-script `chops.tcl', tkirc tries to find other users
	      # which are worth to op.
	      if {[string length "$os"] < 3} {
		set lo "[string tolower "$channel"]"
		if {[info exists choplist($lo)]} {
		  set len [llength "$chan($cnum,addresses)"]
		  for {set i 0} {$i < [llength "$choplist($lo)"]} {incr i} {
		    for {set j 0} {$j < $len} {incr j} {
		      if {[strmatch "[lindex "$choplist($lo)" $i]" "[lindex "$chan($cnum,addresses)" $j]"]} {
			set new "[lindex "$chan($cnum,nicks)" $j]"
			if {[lindex "$chan($cnum,olist)" $j] == 0 && [lsearch "$last" "$new"] == -1} {
			  set adr "[lindex "$chan($cnum,addresses)" $j]"
			  if {[string length "$adr"] && [ctcp_nooptest "$adr"]} {
			    continue
			  }
			  if {[lSearch "$nicks" "[lIndex "$chan($cnum,nicks)" $j]"] != -1} {
			    continue
			  }
			  append os "o"
			  append nicks "$new "
			  if {[string length "$os"] > 2} {
			    break
			  }
			}
		      }
		    }
		  }
		}
	      }
	      if {[string length "$os"] > 0} {
		send2irc "/mode $channel +$os $nicks"
	      }
	    } else {
	      send2irc "/notice $on_args(nick) I'm not operator on channel $channel"
	    }
	  } else {
	    send2irc "/notice $on_args(nick) I'm not on channel $channel"
	  }
	}
      }
    }
    {^HELP} {
      if {[ctcp_xtest "$on_args(address)"]} {
	print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $on_args(rest)"
	send2irc "/notice $on_args(nick) Following CTCP-commands are available for you:"
	after 2000 [list send2irc "/notice $on_args(nick) BANS <channel>, \[CH\]OP <channel> \[<nick2>\] \[<nick3>\],  LEAVE <channel>,"]
	after 4000 [list send2irc "/notice $on_args(nick) REJOIN <channel>, INVITE <channel>, XBANS <channel>"]
	AddToFilterQueue "\*\*\*?Unknown *"
	for {set i 0} {$i < 3} {incr i} {
	  AddToFilterQueue "[expand "-$on_args(nick)-?*"]"
	}
      }
    }
    {^LEAVE} {
      if {[ctcp_xtest "$on_args(address)"]} {
	if {[lLength "$on_args(rest)"] < 1} {
	  send2irc "/notice $on_args(nick) Usage: /ctcp $nickname leave <channel>"
	} else {
	  print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $on_args(rest)"
	  AddToFilterQueue "\*\*\*?Unknown *"
	  set channel "[lIndex "$on_args(rest)" 0]"
	  set i [GetChannelWindow "$channel"]
	  if {$i != -1} {
	    send2irc "/notice $on_args(nick) Please use '/ctcp $nickname rejoin $channel $i', when you've finished."
	    send2irc "/quote part $channel :leave request by $on_args(nick)"
	  }
	}
      }
    }
    {^REJOIN} {
      global crapwindow
      if {[ctcp_xtest "$on_args(address)"]} {
	if {[lLength "$on_args(rest)"] < 1} {
	  send2irc "/notice $on_args(nick) Usage: /ctcp $nickname rejoin <channel>"
	} else {
	  print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $on_args(rest)"
	  AddToFilterQueue "\*\*\*?Unknown *"
	  if {[lLength "$on_args(rest)"] > 1 && [lSearch "$win(list)" "[lIndex "$on_args(rest)" 1]"] != -1} {
  	    lappend chan(tojoin) "[lIndex "$on_args(rest)" 0]"
	    lappend win(tojoin) "[lIndex "$on_args(rest)" 1]"
	  }
	  send2irc "/join [lIndex "$on_args(rest)" 0]"
	}
      }
    }
    {^INVITE} {
      if {[ctcp_xtest "$on_args(address)"]} {
	AddToFilterQueue "\*\*\*?Unknown *"
	if {[lLength "$on_args(rest)"] != 1} {
	  send2irc "/notice $on_args(nick) Usage: /ctcp $nickname invite <channel>"
	} else {
	  set channel "[lIndex "$on_args(rest)" 0]"
	  print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $on_args(rest)"
	  set cnum [GetChannelNumber "$channel"]
	  if {$cnum != -1} {
	    if {[isOpOnChannel $cnum "$nickname"]} {
	      set len [lLength "$chan($cnum,banpatterns)"]
	      if {$len} {
		for {set i 0} {$i < $len} {incr i} {
		  set pattern "[lindex "$chan($cnum,banpatterns)" $i]"
		  set cut [string first "!" "$pattern"]
		  if {$cut != -1} {
		    # Pattern mit Ausrufezeichen
		    if {[strmatch "[string range "$pattern" 0 [expr $cut-1]]" "$on_args(nick)"] && [strmatch "[string range "$pattern" [expr $cut+1] end]" "$on_args(address)"]} {
		      send2irc "/mode $channel -b $pattern"
		    }
		  } else {
		    # Nickname-Pattern
		    if {[strmatch "$pattern" "$on_args(nick)"]} {
		      send2irc "/mode $channel -b $pattern"
		    }
 		  }
	        }
	      }
	      send2irc "/invite $on_args(nick) $channel"
	    } else {
	      send2irc "/notice $on_args(nick) I'm not operator on channel $channel"
	    }
	  } else {
	    send2irc "/notice $on_args(nick) I'm not on channel $channel"
	  }
	}
      }
    }
    {^BANS} {
      if {[ctcp_xtest "$on_args(address)"]} {
	AddToFilterQueue "\*\*\*?Unknown *"
	if {[lLength "$on_args(rest)"] != 1} {
	  send2irc "/notice $on_args(nick) Usage: /ctcp $nickname bans <channel>"
	} else {
	  set channel "[lIndex "$on_args(rest)" 0]"
	  print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $on_args(rest)"
	  set cnum [GetChannelNumber "$channel"]
	  if {$cnum != -1} {
	    set len [lLength "$chan($cnum,banpatterns)"]
	    if {$len} {
	      send2irc "/notice $on_args(nick) Baninfos of channel $channel"
	      for {set i 0} {$i < $len} {incr i} {
		set address "[lindex "$chan($cnum,banusers)" $i]"
		set pattern "[lindex "$chan($cnum,banpatterns)" $i]"
		set comment "[lindex "$chan($cnum,bancomments)" $i]"
		set date "[lindex "$chan($cnum,bantimes)" $i]"
		if {"$date" == "0"} {
		  set date "00.00.00  00:00:00"
		} else {
		  set date "[longdate $date]"
		}
		set j [string first "!" "$address"]
		if {$j == 0 || [string length "$address"] < 2} {
		  set user "<unknown>"
		} else {
		  set user "[string range "$address" 0 [expr $j-1]]"
		}
		after [expr $i*2000] [list send2irc "/notice $on_args(nick) [format " %2d.  $date  %-9s  %s" "[expr $i+1]" "$user" "$pattern  ($comment)"]"]
	      }
	    } else {
	      send2irc "/notice $on_args(nick) +++ There are no baninfos for channel $channel"
	    }
	  } else {
	    send2irc "/notice $on_args(nick) I'm not on channel $channel"
	  }
	}
      }
    }
    {^XBANS} {
      if {[ctcp_xtest "$on_args(address)"]} {
	AddToFilterQueue "\*\*\*?Unknown *"
	if {[lLength "$on_args(rest)"] != 1} {
	  send2irc "/notice $on_args(nick) Usage: /ctcp $nickname xbans <channel>"
	} else {
	  set channel "[lIndex "$on_args(rest)" 0]"
	  print2crap "+++ $on_args(nick)!$on_args(address) : $on_args(command) $on_args(rest)"
	  set i 0
	  set cnum [GetChannelNumber "$channel"]
	  if {$cnum != -1} {
	    set len [lLength "$chan($cnum,banpatterns)"]
	    if {$len} {
	      set gmtdiff [expr [clock scan 0]-[clock scan 0 -gmt true]]
	      for {set i 0} {$i < $len} {incr i} {
		set address "[lindex "$chan($cnum,banusers)" $i]"
		set pattern "[lindex "$chan($cnum,banpatterns)" $i]"
		set time "[lindex "$chan($cnum,bantimes)" $i]"
		if {$time != 0} {
		  set time "[expr $time+$gmtdiff]"
		}
		set comment "[lindex "$chan($cnum,bancomments)" $i]"
		if {[string length "$address"] > 1} {
		  after [expr $i*2000] [list send2irc "/notice $on_args(nick) %1%bancomment $channel $time $address $pattern $comment"]
		} else {
		  after [expr $i*2000] [list send2irc "/notice $on_args(nick) %1%bancomment $channel $time $address $pattern $comment"]
		}
	      }
	    }
	  }
	  after [expr $i*2000] [list send2irc "/notice $on_args(nick) %1%end-of-bancomments $channel"]
	}
      }
    }
  }
}

# on_privnotice_ctcpextras: Maybe you receive some private notices as
#                           reply for your `/ctcp <nick> xbans <channel>'.
#                           The received bancomments will be added to 
#                           your baninfos of channel <channel>.
#                           (See also command `/baninfos'!)
#
# These notices looks like:
# `%1%bancomment <channel> <timestamp> <nick>!<address> <banpattern> <comment>'
proc on_privnotice_ctcpextras { } {
  global chan on_args bancomment_count

  if {![info exists bancomment_count]} {
    set bancomment_count 0
  }
  if {[string match "%1%bancomment *" "$on_args(rest)"]} {
    set line "[expand "$on_args(rest)"]"
    set channel "[lindex "$line" 1]"
    set cnum [GetChannelNumber "$channel"]
    if {$cnum != -1} {
      set gmtdiff [expr [clock scan 0]-[clock scan 0 -gmt true]]
      set len [lLength "$chan($cnum,banpatterns)"]
      set timestamp "[lindex "$line" 2]"
      if {$timestamp != 0} {
	set timestamp "[expr $timestamp-$gmtdiff]"
      }
      set address "[lindex "$line" 3]"
      set pattern "[lindex "$line" 4]"
      set comment "[reduce "[lrange "$line" 5 end]"]"
      for {set i 0} {$i < $len} {incr i} {
	if {[string compare "$pattern" "[lindex "$chan($cnum,banpatterns)" $i]"] == 0 && "$comment" == ""} {
	  if {[expr $timestamp + 150] > [lindex "$chan($cnum,bantimes)" $i] \
	   || [string first "!" "[lindex "$chan($cnum,banusers)" $i]"] == 0 \
	   || [lindex "$chan($cnum,bantimes)" $i] == 0} {
	    incr bancomment_count
	    set chan($cnum,bantimes) "[lreplace "$chan($cnum,bantimes)" $i $i "$timestamp"]"
	    set chan($cnum,banusers) "[lreplace "$chan($cnum,banusers)" $i $i "$address"]"
	    set chan($cnum,banpatterns) "[lreplace "$chan($cnum,banpatterns)" $i $i "$pattern"]"
	    set chan($cnum,bancomments) "[lreplace "$chan($cnum,bancomments)" $i $i "$comment"]"
	    break
	  }
	}
      }
    }
  } elseif {[string match "%1%end-of-bancomments *" "$on_args(rest)"]} {
    set bancomment_count 0
  }
}
