
# Description:  This script allows you to play definable sounds on
#               certain events. It's also a nice example for using
#               tkirc's on-procedures. Please see the comments below!
#
# Date:         10.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/sound.tcl'
#               2. edit the following audio-variables
#                  (see examples and comments below)
#               3. reload your tkircrc or restart tkirc

global audio

# The following variable defines the program that will play
# your modules on certain events.

set audio(snd_program)        "/usr/local/bin/wavplay"

# Below you see module-settings for all events that tkirc knows. These
# modules are just examples. If you want to hear some of them, you must
# download it from somewhere in space or internet! =:^)

set audio(snd_join)           "/usr/local/audio/tada.wav"
set audio(snd_leave)          "/usr/local/audio/taps.wav"
#set audio(snd_signoff)        ""
#set audio(snd_disconnect)     ""
#set audio(snd_topic)          ""
#set audio(snd_modechange)     ""
#set audio(snd_nick)           ""
set audio(snd_kick)           "/usr/local/audio/ugh.wav"
#set audio(snd_ctcprequest)    ""
#set audio(snd_ctcpreply)      ""
#set audio(snd_dcc)            ""
#set audio(snd_privaction)     ""
#set audio(snd_pubaction)      ""
set audio(snd_privmessage)    "/usr/local/audio/bong.wav"
#set audio(snd_pubmessage)     ""
#set audio(snd_servermessage)  ""
#set audio(snd_privnotice)     ""
#set audio(snd_pubnotice)      ""
#set audio(snd_servernotice)   ""
#set audio(snd_invite)         ""
#set audio(snd_notify_signon)  ""
#set audio(snd_notify_signoff) ""
#set audio(snd_url_detect)     ""
#set audio(snd_msgid_detect)   ""

#set audio(snd_tkircstart)     ""
#set audio(snd_ircIIstart)     ""
#set audio(snd_connect)        ""

proc on_event_snd { } {
  global on_args audio

  if {[info exists audio(snd_$on_args(event))]} {
    if {[string length "$audio(snd_$on_args(event))"]} {
      catch {
        eval exec -- $audio(snd_program) $audio(snd_$on_args(event)) &
      }
    }
  }
}
