/*
libutil -- deal with active file

Written by Arnt Gulbrandsen <agulbra@troll.no> and copyright 1995
Troll Tech AS, Postboks 6133 Etterstad, 0602 Oslo, Norway, fax +47
22646949.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>
and Randolf Skerka <rskerka@metronet.de>.
Copyright of the modifications 1997.
Modified by Kent Robotti <robotti@erols.com>. Copyright of the
modifications 1998.
Modified by Markus Enzenberger <enz@cip.physik.uni-muenchen.de>.
Copyright of the modifications 1998.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>.
Copyright of the modifications 1998.

See file COPYING for restrictions on the use of this software.
*/

#include <fcntl.h>
#include <sys/uio.h>
#include <sys/param.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdlib.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <dirent.h>

#include "leafnode.h"

#define   STRNCMPEQ(s1, s2, n)    (*(s1) == *(s2) && strncmp((s1), (s2), n) == 0)

extern int errno;
extern int h_errno;
extern struct state _res;

struct newsgroup * active;
struct newsgroup * blocked;

/* insert or update a newsgroup in the global list */
void insertgroup(const char * name, int first, int last, const char * desc,
		 int age ) {
    struct newsgroup ** a;
    int c;

    if ( !desc )
	desc = "";

    a = &active;
    while(a) {
	if (*a) {
	    c = strcmp((*a)->name, name);
	    if (c<0)
		a = &((*a)->left);
	    else if (c>0)
		a = &((*a)->right);
	    else {
	    	/* update newsgroup description, nothing else */
		if (desc && *desc) {
		    /* This leaks memory if the new desc > old one, but I
		       cannot see a way round this... */
		    if (strlen((*a)->desc) >= strlen(desc))
			strcpy((*a)->desc, desc);
		    else
			(*a)->desc = strdup( desc );
		}
		return;
	    }
	} else {
	    /* create new newsgroup entry */
	    *a = (struct newsgroup *)
		 critmalloc(sizeof(struct newsgroup) + 2 +
			    strlen( name ) + strlen( desc ),
			    "Building newsgroups info list");
	    if (!*a)
		return;
	    (*a)->left = (*a)->right = NULL;
	    (*a)->first = first;
	    (*a)->last = last;
	    (*a)->age = age;
	    (*a)->name = (char*)(1+*a);
	    strcpy( (*a)->name, name);
	    (*a)->desc = strlen((*a)->name)+1+((*a)->name);
	    strcpy( (*a)->desc, desc );
	    return;
	}
    }
}


/* find a group by name */
struct newsgroup * findgroup(const char* name) {
    struct newsgroup * a;
    int c;

    a = active;
    while ( a ) {
	c = strcmp( a->name, name );
	if ( c < 0 )
	    a = a->left;
	else if ( c > 0 )
	    a = a->right;
	else
	    return a;
    }
    return a;
}


/* find a blocked group by name */
/* from leafnode-1.5(enz)
int findblocked(const char* name) {
    struct newsgroup * a;
    int c;

    a = blocked;
    while ( a ) {
        c = strcmp( a->name, name );
        if ( c < 0 )
            a = a->left;
        else if ( c > 0 )
            a = a->right;
        else
            return TRUE;
    }
    return FALSE;
}
*/

static void freeactive( struct newsgroup * g ) {
    if ( g ) {
	freeactive( g->right );
	freeactive( g->left );
	free( (char*)g );
    }
}


/* this uses a nifty technique for building a binary tree from a
   sorted list... the basic observation is that if you count from one
   end, with 1 being the rightmost node, then the number of nodes
   between N and the leaf nodes is equal to the number of zero bits
   at the small end of N.  this tree probably doesn't make it obvious:

   1 2 3 4 5 6 7

         1
     1   0   1
   1 0 1 0 1 0 1
   | | | | | | + no zeroes: leaf node
   | | | | | +-- one zero: one step up
   | | | | +---- no zeroes: leaf node
   | | | +------ two zeroes: two steps up
   | | +-------- no zeroes: leaf node
   | +---------- one zero: one step up
   +------------ no zeroes: leaf node

   this can be used to build a smallest-height tree, and with a bit more
   care, a _perfectly_ balanced tree */

void readactive( void ) {
    char * p;
    char * q;
    int first, last;
    time_t age;
    int fd;
    struct newsgroup * g;
    struct stat st;

    int line;
    struct newsgroup *levels[32]; /* theoretically finite size :) */
    int l;

    static char * stuff;

    if ( stuff ) {
	freeactive( active );
	active = NULL;
	free( (char*)stuff );
	stuff = NULL;
    }

    strcpy(s, spooldir);
    strcat(s, "/leaf.node/groupinfo");
    fd = open( s, O_RDONLY );
    if ( stat( s, &st ) ) {
	syslog( LOG_ERR, "can't stat %s: %m", s );
	return;
    }
    stuff = critmalloc( st.st_size+1, "Reading group info" );
    if ( (fd=open( s, O_RDONLY))<0 ||
	 (read( fd, stuff, st.st_size ) < st.st_size) ) {
	syslog( LOG_ERR, "can't open/read %s: %m", s );
	return;
    } else {
	close( fd );
	stuff[st.st_size] = '\0'; /* 0-terminate string */
    }

    line = 1;
    for( l=0; l<32; levels[l++] = NULL )
	;

    p = stuff;
    while ( p && *p ) {
	q = p;
	p = strchr(p, ' ');
	if (p && *p)
	    *p++ = '\0';
	else {
	    syslog( LOG_ERR, "groupinfo file may be corrupted" );
	    *q = '\0' ;		/* skip defective group */
	}
	if ( *q ) {
	    last = p ? strtol( p, &p, 10 ) : 0;
	    first = p ? strtol( p, &p, 10 ) : 1;
	    age = p ? strtol( p, &p, 10 ) : 1;
	    while (p && *p && isspace(*p))
		p++;
	    if (first < 1)
		first = 1;

	    g = (struct newsgroup *) critmalloc(sizeof(struct newsgroup),
						"reading groupinfo");
	    g->right = g->left = NULL;
	    g->first = first;
	    g->last = last;
	    g->age = age;
	    g->name = q;
	    g->desc = p;

	    for( l=0; (line&(1<<l))==0; l++ )
		;
	    if ( l ) {
		g->right = levels[l-1];
	    }
	    if ( active == g->right )
		active = g;
	    if ( l<31 && levels[l+1] && !levels[l+1]->left )
		levels[l+1]->left = g;
	    levels[l] = g;

	    p = strchr( p, '\n' );
	    if ( p )
		*p++ = '\0';
	    line++;
	} else {
	    p = strchr( p, '\n' );
	    if ( p )
		p++;
	}
    }
    g = NULL;
    for ( l=0; l<31; l++ ) {
	if ( levels[l] ) {
	    if ( g && levels[l] &&
		 levels[l]->left == NULL && levels[l]->right != g ) {
		levels[l]->left = g;
		g = NULL;
	    }
	    if ( !levels[l+1] ||
		 ( levels[l] != levels[l+1]->left &&
		   levels[l] != levels[l+1]->right ) ) {
		if ( g )
		    syslog( LOG_ERR, "2+5=2" );
		g = levels[l];
	    }
	}
    }
}

/* from leafnode-1.5(enz). This is more-or-less copied from readactive()
void readblocked( void ) {
    char * p;
    char * q;
    int fd;
    struct newsgroup * g;
    struct stat st;

    int line;
    struct newsgroup *levels[32];
    int l;
    int skiptoeol;

    static char * stuff;

    if ( stuff ) {
        freeactive( blocked );
        free( (char*)stuff );
        stuff = NULL;
    }
    blocked = NULL;

    strcpy(s, spooldir);
    strcat(s, "/leaf.node/blocked");
    fd = open( s, O_RDONLY );
    if ( stat( s, &st ) ) {
        return;
    }
    stuff = critmalloc( st.st_size+1, "Reading blocked group info" );
    if ( (fd=open( s, O_RDONLY))<0 ||
         (read( fd, stuff, st.st_size ) < st.st_size) ) {
        syslog( LOG_ERR, "can't open/read %s: %m", s );
        return;
    } else {
        close( fd );
        stuff[st.st_size] = '\0';
    }

    line = 1;
    for( l=0; l<32; levels[l++] = NULL )
        ;

    p = stuff;
    while ( p && *p ) {
        q = p;
        while (!isspace(*p)) { p++; }
        skiptoeol = (*p != '\n');
        *p++ = '\0';
        if ( *q ) {
            g = (struct newsgroup *) critmalloc(sizeof(struct newsgroup),
                                                "reading blocked");
            g->right = g->left = NULL;
            g->first = 0;
            g->last = 0;
            g->name = q;
            g->desc = NULL;

            for( l=0; (line&(1<<l))==0; l++ )
                ;
            if ( l ) {
                g->right = levels[l-1];
            }
            if ( blocked == g->right )
                blocked = g;
            if ( l<31 && levels[l+1] && !levels[l+1]->left )
                levels[l+1]->left = g;
            levels[l] = g;

            if (skiptoeol) {
                p = strchr( p, '\n' );
                if ( p )
                    *p++ = '\0';
            }
            line++;
        } else {
            if (skiptoeol) {
                p = strchr( p, '\n' );
                if ( p )
                    *p++ = '\0';
            }
        }
    }
    g = NULL;
    for ( l=0; l<31; l++ ) {
        if ( levels[l] ) {
            if ( g && levels[l] &&
                 levels[l]->left == NULL && levels[l]->right != g ) {
                levels[l]->left = g;
                g = NULL;
            }
            if ( !levels[l+1] ||
                 ( levels[l] != levels[l+1]->left &&
                   levels[l] != levels[l+1]->right ) ) {
                if ( g )
                    syslog( LOG_ERR, "2+5=2" );
                g = levels[l];
            }
        }
    }
}
*/

/*
 * returns 1 if something could be written, 0 otherwise
 */
static int helpwriteactive ( struct newsgroup *g, FILE * f ) {
    if (g) {
        if ( helpwriteactive (g->right, f) ) {
            if ( fprintf(f, "%s %d %d %lu %s\n", g->name, g->last, g->first,
                 g->age, g->desc && *(g->desc) ? g->desc : "-x-" ) ) {
        	if ( helpwriteactive (g->left, f) )
		    return 1;
		else
		    return 0;
	    } else
		return 0;
	} else
	    return 0;
    }
    return 1;
}

void writeactive( void ) {
    FILE * a;
    char c[PATH_MAX];
    int err;

    strcpy(s, spooldir);
    strcat(s, "/leaf.node/groupinfo.new");
    a = fopen( s, "w" );
    if (!a) {
	syslog( LOG_ERR, "cannot open new groupinfo file: %m" );
	return;
    }
    err = helpwriteactive( active, a );
    fclose( a );

    if ( err != 0 ) {
	strcpy(c, spooldir);
        strcat(c, "/leaf.node/groupinfo");
	rename( s, c );
    } else {
	syslog( LOG_ERR, "error writing groupinfo file (disk full?)" );
	unlink(s);
    }
}

/*
 * fake an active file if the groupinfo file is corrupted
 */
void fakeactive( void ) {
    DIR * d;
    struct dirent * de;
    DIR * ng;
    struct dirent * nga;
    int i;

    int first, last;

    strcpy( s, spooldir );
    strcat( s, "/interesting.groups" );
    
    d = opendir( s );
    if ( !d ) {
	syslog( LOG_ERR, "cannot open directory %s: %m", s );
	return;
    }
    while ( (de = readdir(d)) ) {
	if ( isalnum( *(de->d_name) ) ) {
	    /* get first and last article from the directory. This is
	     * the most secure way to get to that information since the
	     * .overview files may be corrupt as well
	     */
	    chdirgroup( de->d_name );
	    first = INT_MAX;
	    last = 0;

	    ng = opendir( "." );
	    while ( ( nga = readdir( ng ) ) != NULL ) {
		if ( isdigit ( *(nga->d_name ) ) ) {
		    i = strtol( nga->d_name, NULL, 10 );
		    if ( i < first )
			first = i;
		    if ( i > last )
			last = i;
		}
	    }
	    if ( first > last ) {
		first = 0;
		last = 1;
	    }
	    closedir( ng );
	    syslog( LOG_DEBUG, "parsed directory %s: first %d, last %d",
		    de->d_name, first, last );
	    insertgroup( de->d_name, first, last, NULL, 0 );
	}
    }
}
