/* $Id: leafnode.h,v 1.13 1997/07/20 00:34:23 agulbra Exp $ */

#ifndef LEAFNODE_H
#define LEAFNODE_H

/* I wish the world were a happy place */
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

#include <errno.h>
#include <sys/errno.h>

/* uncomment this if you get errors 

extern     int sys_nerr;
extern     char *sys_errlist[];
extern     int errno;

also complain to your vendor */

#define HAVE_STRDUP

#ifdef ultrix
#undef HAVE_STRDUP
#endif

#ifndef HAVE_STRDUP
char * strdup (const char *);
#endif


/* limits.h is supposed to contain PATH_MAX, we include sys/param.h too */
#include <limits.h>
#ifndef PATH_MAX
#include <sys/param.h>
#define PATH_MAX MAXPATHLEN
#endif

/* add LOG_NEWS where it doesn't exist */
#include <syslog.h>
#if !defined( LOG_NFACILITIES )
#error "Leafnode does not compile with BSD 4.2 syslog"
#endif
#if !defined( LOG_NEWS )
#define LOG_NEWS LOG_DAEMON
#endif
#if !defined( LOG_CONS )
#define LOG_CONS 0 /* if it isn't supported, make do without */
#endif

#include <stdio.h> /* FILE * */


/* don't fetch threads that nobody've read in this many seconds */
#define TIMEOUT_LONG 604800
/* don't fetch threads that have been "read" only once in this many seconds */
#define TIMEOUT_SHORT 172800
/* time interval in seconds for completely rereading newsgroups list */
#define READ_INTERVALL ( 90 * 24 * 3600 )
/* Limit on the number of message bodies marked for download per group. */
#define BODY_DOWNLOAD_LIMIT 2048

/* converts a message-id to a file name, the return value points into
   a static array */
const char * lookup (const char *);
/* reads one line, regardless of length */
char * getaline(FILE *f);

/* changes (and optionally creates) directory */
void chdirgroup(const char *group);

/*
 * newsgroup management
 */
struct newsgroup {
    struct newsgroup * left;
    struct newsgroup * right;
    int first;
    int last;
    int alive;
    char * name;
    char * desc;
    time_t age;
};

void insertgroup(const char * name, int first, int last, const char * desc,
	int date );
struct newsgroup * findgroup(const char* name);
void readactive( void );
void writeactive( void );
void fakeactive( void );

/* newsgroup blocking */
int findblocked(const char* name);
void readblocked( void );
extern struct newsgroup * blocked;

extern struct newsgroup * active;

/* translation from message-id to article number, used in fetch and expire */

void clearidtree( void );
void insertmsgid( const char * msgid, int art );
int findmsgid( const char* msgid );

/* -----------here starts the new stuff-----------------*/

/*
 * xover stuff -- for nntpd.c
 */
struct xoverinfo {
    char * text;
    int mallocd;
    int exists;
};

extern struct xoverinfo * xoverinfo;
extern int xfirst;
extern int xlast;

int getxover( void );	/* set xoverinfo, return 0 on error, nonzero else */
int legalxoverline ( char * xover );	/* return 1 if xoverline is legal */

/*
 * the strings in config.c
 */
extern const char * spooldir;
extern const char * libdir;
extern const char * bindir;
extern const char * version;
extern const char * lockfile;

/*
 * global variables from config file. These are defined in configutil.c
 */
struct expire_entry {
    int xtime;
    struct expire_entry *next;
    char * group;
};

struct serverlist {
    struct serverlist * next;
    char name[1] ;
};

extern char * upstream;	/* upstream news server */
extern char * username;	/* authinfo user name */
extern char * password;	/* authinfo password */
extern time_t expire;	/* articles not touched since this time get deleted */
extern struct expire_entry * expire_base;
			/* expire for certain groups */
extern int artlimit;	/* max # of articles to read per group in one go */
extern int initiallimit;
			/* max # of articles to read at first time */
extern int crosspostlimit;
			/* crossposting limit, to reduce spam */
extern int delaybody;	/* delay download of message body */
extern int scarce_links;
			/* create only necessary hardlinks */
extern int maxage;	/* max age of articles */
extern int maxlines;	/* max length of articles in lines */
extern int nntpport;	/* NNTP port to connect to */
extern struct serverlist * postserver;
			/* list of servers to post through */
extern struct serverlist * readserver;
			/* list of servers to read from */

/*
 * other global variables
 */
extern char last_command[1025];
extern char lineout[1025];

/* defined in nntputil.c */
extern FILE *nntpin;
extern FILE *nntpout;

extern char s[];
extern char fqdn[];		/* my name, and my naming myself */

extern int verbose;		/* verbosity level, for fetch and texpire */
extern int debug;		/* debug level */

/*
 * misc prototypes
 */
void putaline( void );
void retry( void );
int authenticate( void );
void readexpire( void );
int lookup_expire(char *group);
void free_expire( void );
int readconfig( void );
void whoami( void );
char * critmalloc(size_t size, const char* message);
char * critrealloc(char *a, size_t size, const char* message);

int nntpreply( void );		/* decode an NNTP reply number -- nntputil.c */
int nntpconnect( const char * upstream );
				/* connect to upstream server -- nntputil.c */

FILE * buildpseudoart(const char * grp);
			/* build a pseudo article for triggering fetches etc */
const char* rfctime(void);	/* An rfc type date */

#endif
