/*
nntpd -- the NNTP server

Written by Arnt Gulbrandsen <agulbra@troll.no> and copyright 1995
Troll Tech AS, Postboks 6133 Etterstad, 0602 Oslo, Norway, fax +47
22646949.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>
and Randolf Skerka <rskerka@metronet.de>.
Copyright of the modifications 1997.
Modified by Kent Robotti <robotti@erols.com>. Copyright of the
modifications 1998.
Modified by Markus Enzenberger <enz@cip.physik.uni-muenchen.de>.
Copyright of the modifications 1998.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>.
Copyright of the modifications 1998.

See file COPYING for restrictions on the use of this software.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <syslog.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>

const int verbose = 0;

#include "leafnode.h"

int write2(int fd, const char *msg);
int hash (const char *);
FILE * fopenart(const char *);
FILE * fopenpseudoart(const char * arg, const int article_num);
void list(struct newsgroup *, int);
void rereadactive(void);

void parser(void);
void error(const char *msg);
void doarticle(const char *, int);
void dogroup(const char *);
void dohelp(void);
void domove(int);
void domove(int);
void dolist(const char *);
void donewgroups(const char *);
void dopost( void );
void doxhdr(char *);
void doxover(const char *);
void dolistgroup( const char * );
void markinterest( void );


struct newsgroup * group; /* current group, initially none */
struct newsgroup * xovergroup;
int artno = 0; /* current article number, initially 0 and almost unused */
char *cmd; /* current command line */
struct newsgroup * active;
time_t activetime;
char fqdn[64];
static int justaftergroup;

int debug = 1;

void rereadactive(void) {
    struct stat st;

    strcpy(s, spooldir);
    strcat(s, "/leaf.node/groupinfo");

    if ( (!stat(s, &st) && (st.st_mtime > activetime)) ||
	 (active==NULL) ) {
	syslog( LOG_DEBUG, "rereading %s", s );
	readactive();
	activetime = st.st_mtime;
    }
}



void error(const char *msg) {
    printf("%s: %s\r\n", msg, 
	   (errno > sys_nerr) ? "unknown error" : sys_errlist[errno]);
}


void parser(void) {
    char *arg;
    int n;

    while(1) {
	if (!(cmd=getaline( stdin ))) {
	    error("421 Network error");
	    return;
	}

	n = 0;
	while(isalpha(cmd[n]) && n<1000) {
	    cmd[n] = tolower(cmd[n]);
	    n++;
	}

	if ( n == 0 )
	    continue; /* outside the spec, but let's do it anyway */

	if ( n>999 ) {
	    syslog( LOG_DEBUG, ">400 Dazed and confused" ); 
	    printf("400 Dazed and confused\r\n");
	    return;
	}

	while(isspace(cmd[n]) && n<1000)
	    cmd[n++] = '\0';

	arg = cmd+n;

	while(cmd[n] && n<1000)
	    n++;
	n--;

	while(isspace(cmd[n]))
	    cmd[n--] = '\0';

	if (!strcasecmp(cmd, "article")) {
	    doarticle(arg, 3);
	} else if (!strcasecmp(cmd, "head")) {
	    doarticle(arg, 2);
	} else if (!strcasecmp(cmd, "body")) {
	    doarticle(arg, 1);
	} else if (!strcasecmp(cmd, "stat")) {
	    doarticle(arg, 0);
	} else if (!strcasecmp(cmd, "help")) {
	    dohelp();
	} else if (!strcasecmp(cmd, "ihave")) {
	    printf("500 IHAVE is for big news servers\r\n");
	} else if (!strcasecmp(cmd, "last")) {
	    domove(-1);
	} else if (!strcasecmp(cmd, "next")) {
	    domove(1);
	} else if (!strcasecmp(cmd, "list")) {
	    dolist(arg);
	} else if (!strcasecmp(cmd, "mode")) {
	    syslog( LOG_DEBUG, ">200 Modal interfaces are for losers" );
	    printf("200 Modal interfaces are for losers\r\n");
	} else if (!strcasecmp(cmd, "newgroups")) {
	    donewgroups(arg);
	} else if (!strcasecmp(cmd, "newnews")) {
	    syslog( LOG_DEBUG,
		    ">500 NEWNEWS is meaningless for this server\r\n" );
	    printf( "500 NEWNEWS is meaningless for this server\r\n" );
	} else if (!strcasecmp(cmd, "post")) {
	    dopost();
	} else if (!strcasecmp(cmd, "quit")) {
	    printf("205 Always happy to serve!\r\n");
	    return;
	} else if (!strcasecmp(cmd, "slave")) {
	    syslog( LOG_DEBUG, ">202 Cool - I always wanted a slave" );
	    printf("202 Cool - I always wanted a slave\r\n");
	} else if (!strcasecmp(cmd, "xhdr")) {
	    doxhdr(arg);
	} else if (!strcasecmp(cmd, "xover")) {
	    doxover(arg);
	} else if (!strcasecmp(cmd, "listgroup")) {
	    dolistgroup(arg);
	} else if (!strcasecmp(cmd, "group")) {
	    dogroup(arg);
	} else {
	    syslog( LOG_DEBUG, ">500 Unknown command" );
	    printf("500 Unknown command\r\n");
	}
	fflush(stdout);
    }
}


/* open a pseudo art */
FILE * fopenpseudoart(const char * arg, const int article_num) {
    FILE *f = NULL;
    char msgidbuf[128];
    char * c;
    struct newsgroup * g;    

    syslog( LOG_DEBUG, "%s: first %d last %d artno %d",
    		group->name, group->first, group->last, article_num );
    if ( article_num && article_num == group->first &&
         group->first >= group->last ) {
	f = buildpseudoart(group->name);
    } else if ( !article_num ) {
	if (!strncmp(arg, "<leafnode:placeholder:", 22)) {
	    strncpy(msgidbuf, arg+22, 128);
	    msgidbuf[127] = '\0';
	    if ((c = strchr(msgidbuf, '@')) != NULL) {
		*c = '\0';
		g = findgroup(msgidbuf);
		if (g) {
		    f = buildpseudoart(g->name);
		}
	    }
	}
    }
    return f;
}


/* open an article by number or message-id */
FILE * fopenart(const char * arg) {
    int a;
    FILE *f;
    char *t;

    t = NULL;
    a = strtol(arg, &t, 10);
    if (a && t && !*t && group) {
	f = fopen(arg, "r");
	if (f)
	    artno = a;
	else
	    f = fopenpseudoart(arg, a);
	markinterest();
	/* else try message-id lookup */
    } else if ( arg && *arg=='<' ) {
	f = fopen(lookup(arg), "r");
	if ( !f )
	    f = fopenpseudoart(arg, a);
    } else if (group && artno) {
	sprintf(s, "%d", artno);
	syslog( LOG_DEBUG, "fopenart: %s\n", s );
	f = fopen(s, "r");
	if (!f)
	    f = fopenpseudoart(s, a);
	markinterest();
    } else {
	f = NULL;
    }
    return f;
}
    

/*
 * Mark an article for download by appending its number to the
 * corresponding file in interesting.groups
 */
static int markdownload( long id )
{
    int i;
    long n;
    FILE *f;

    snprintf( s, 1024,
              "%s/interesting.groups/%s", spooldir, group->name );
    if ( ( f = fopen( s, "r+" ) ) ) {
        i = 0;
        while ( fgets( s, 1024, f ) ) {
            if ( sscanf( s, "%ld", &n ) == 1 && n == id )
                return 0; /* already marked */
            ++i;
        }
        if ( i < BODY_DOWNLOAD_LIMIT ) {
            fprintf( f, "%ld\n", id );
            syslog( LOG_DEBUG, "Marking %s %ld for download",
                    group->name, id );
        }
        else {
            syslog( LOG_ERR, "Too many bodies marked in %s",
                    group->name );
        }
        fclose( f );
    }
    return 1;
}

/* display an article or somesuch */
void doarticle(const char *arg, int what) {
    FILE *f;
    char *p;
    long yuck;

    if ( !group ) {
	printf( "412 No newsgroup selected\r\n" );
	syslog( LOG_DEBUG, ">412 No newsgroup selected\r\n" );
	return;
    }

    f = fopenart(arg);
    if (!f) {
	if ( strlen( arg ) ) {
	    printf("430 No such article: %s\r\n", arg );
	    syslog( LOG_DEBUG, ">430 No such article: %s\r\n", arg );
	} else {
	    printf( "430 No such article: %d\r\n", artno );
	    syslog( LOG_DEBUG, ">430 No such article: %d\r\n", artno );
	} return;
    }

    yuck = strtol( arg, &p, 10 );
    if ( !p || *p )
	yuck = 0;

    printf("%3d %ld Text follows, then a line consisting of a single '.'\r\n",
	   223-what, yuck );
    syslog( LOG_DEBUG, ">%3d %ld Text follows, "
	       "then a line consisting of a single '.'\r\n",
	       223-what, yuck );

    while (fgets(s, 1024, f) && *s && (*s!='\n')) {
	if (what & 2) {
	    p = s;
	    if ( (p = strchr(p, '\n')) )
		*p = '\0';

	    printf("%s%s\r\n", *s=='.' ? "." : "", s); /* . on headers :( */
	}
    }

    if (what==3)
	printf("\r\n"); /* empty separator line */

    if ( what & 1 ) {
	if ( delaybody && *s != '\n' ) {
	    if ( ! markdownload( yuck ) ) {
		printf( "\r\n\r\n"
			"\t[ Leafnode: ]\r\n"
			"\t[ This message has already been "
			"marked for download. ]\r\n" );
	    } else {
		printf( "\r\n\r\n"
			"\t[ Leafnode: ]\r\n"
			"\t[ Message %ld of %s ]\r\n"
			"\t[ has been marked for download. ]\r\n",
			yuck, group->name );
	    }
	} else {
	    while ( fgets(s, 1024, f) && *s) {
		p = s;
		if ( (p = strchr(p, '\n')) )
		    *p = '\0';
		printf("%s%s\r\n", *s=='.' ? "." : "", s);
	    }
	}
    }
    if ( what )
	printf(".\r\n");
    fclose(f);

    return; /* OF COURSE there were no errors */
}


/* note bug.. need not be _immediately after_ GROUP */
void markinterest( void ) {
    int f;

    if ( !justaftergroup )
	return;
    sprintf( s, "%s/interesting.groups/%s", spooldir, group->name );
    if ( (f=open( s, O_WRONLY|O_CREAT|O_TRUNC, 0644)) >= 0 )
	close(f);
    justaftergroup = FALSE;
}
    


/* change to group - note no checks on group name */
void dogroup(const char *arg) {
    struct newsgroup * g;
    int f;

    rereadactive();
    g = findgroup(arg);
    if (g) {
	group = g;
	chdirgroup( g->name );
	if (g->last < g->first) {
	    syslog( LOG_DEBUG,
	           ">211 %d %d %d %s group selected (pseudo article)\r\n",
		   1, 1, 1, g->name);
	    printf("211 %d %d %d %s group selected (pseudo article)\r\n", 
		   1, 1, 1, g->name);
	} else {
	    syslog( LOG_DEBUG,
	    	   ">211 %d %d %d %s group selected\r\n",
		   g->last >= g->first ? g->last-g->first+1 : 0,
		   g->first, g->last, g->name);
	    printf("211 %d %d %d %s group selected\r\n", 
		   g->last >= g->first ? g->last-g->first+1 : 0, 
		   g->first, g->last, g->name);
	}
	artno = g->first;
	fflush( stdout );
	justaftergroup = TRUE;
/* I don't think nntpd needs this -- CK
	sprintf( s, "%s/interesting.groups/.%s", spooldir, group->name );
*/
	if ( (f=open( s, O_WRONLY|O_CREAT|O_TRUNC, 0644)) >= 0 )
	    close(f);
    } else {
    	syslog( LOG_DEBUG, ">411 No such group\r\n");
	printf("411 No such group\r\n");
    }
}


void dohelp(void) {
    printf("500 Read RFC 977 and 1036 for elucidation\r\n");
}


void domove( int by ) {
    if ( group ) {
	if (artno) {
	    artno += by;
	    if ( artno > group->last ) {
		artno = group->last;
		printf("421 There is no next article\r\n" );
		syslog( LOG_DEBUG, ">421 There is no next article" );
	    }
	    else if ( artno < group->first ) {
		artno = group->first;
		printf("421 There is no previous article\r\n" );
		syslog( LOG_DEBUG, ">421 There is no previous article" );
	    }
	    else {
	        printf( "223 Article number is now %d\r\n", artno);
		syslog( LOG_DEBUG, ">223 Article number is now %d", artno );
	    }
	} else {
	    printf( "420 There is no current article\r\n" );
	    syslog( LOG_DEBUG, ">420 There is no current article" );
	}
    } else {
	syslog( LOG_DEBUG, ">412 No newsgroup selected" );
	printf( "412 No newsgroup selected\r\n" );
    }
}



/* LIST ACTIVE if what==0, else LIST NEWSGROUPS */
void list(struct newsgroup *g, int what) {
    if (g) {
	list (g->right, what);
	if (what) {
	    printf( "%s\t%s\r\n", g->name, g->desc ? g->desc : "" );
	} else {
	    /* If the group is empty, but has server arts, fudge a
               dummy article in... */
	    if (g->last < g->first) {
		printf( "%s %010d %010d y\r\n", g->name, g->last, g->last);
	    } else {
		printf( "%s %010d %010d y\r\n", g->name, g->last, g->first);
	    }
	}
	list (g->left, what);
    }
}
	

void dolist(const char *arg) {

    rereadactive();
    if (chdir(spooldir)) {
	printf("503 News spool directory does not exist!\r\n");
	syslog( LOG_ERR, ">503 News spool directory does not exist!" );
    } else if (!active) {
	printf("503 Group information file does not exist!\r\n");
	syslog( LOG_ERR, ">503 Group information file does not exist!" );
    } else {
	if ( !*arg || !strcasecmp(arg, "active") ) {
	    printf("215 Newsgroups in form \"group high low flags\".\r\n");
	    syslog( LOG_DEBUG,
		    ">215 Newsgroups in form \"group high low flags\"." );
	    list ( active, 0 );
	    printf(".\r\n");
	} else if ( !strcasecmp(arg, "newsgroups") ) {
	    printf("215 Descriptions in form \"group description\".\r\n");
	    syslog( LOG_DEBUG,
		   ">215 Descriptions in form \"group description\"." );
	    list ( active, 1 );
	    printf(".\r\n");
	} else if ( !strcasecmp(arg, "extensions") ) {
	    printf("501 No extensions available.\r\n" );
	    syslog( LOG_DEBUG, ">501 No extensions available." );
	} else if ( !strcasecmp(arg, "overview.fmt") ) {
	    printf("215 information follows\r\n"
		   "Subject:\r\n"
		   "From:\r\n"
		   "Date:\r\n"
		   "Message-ID:\r\n"
		   "References:\r\n"
		   "Bytes:\r\n"
		   "Lines:\r\n"
		   "Xref:full\r\n"
	           ".\r\n");
	    syslog( LOG_DEBUG, ">215 information follows" );
	} else if ( !strcasecmp(arg, "active.times") ) {
	    printf("215 Placeholder - Leafnode will fetch groups on demand\r\n"
		   "news.announce.newusers 42 tale@uunet.uu.net\r\n"
		   "news.answers 42 tale@uunet.uu.net\r\n"
		   ".\r\n");
	    syslog( LOG_DEBUG,
		    ">215 Placeholder - Leafnode will fetch groups on demand" );
	} else {
	    printf( "501 Syntax error\r\n" );
	    syslog( LOG_DEBUG, ">501 Syntax error" );
	}
    }
}

static void helpdonewgroups( struct newsgroup *g, time_t age ) {
    if ( g ) {
	helpdonewgroups( g->right, age );
	if ( g->age >= age )
	    printf( "%s %d %d y\r\n", g->name, g->first, g->last );
	helpdonewgroups( g->left, age );
    }
}

void donewgroups(const char *arg) {
    struct tm timearray;
    time_t age;
    char * l;
    int a;

    l = NULL;
    a = strtol( arg, &l, 10 );
    timearray.tm_year = a / 10000;
    timearray.tm_mon  = (a % 10000 / 100) - 1 ;
    timearray.tm_mday = a % 100 ;
    while ( *l && isspace (*l) )
	l++;
    a = strtol( l, NULL, 10 );	/* we don't care about the rest of the line */
    timearray.tm_hour = a / 10000;
    timearray.tm_min  = a % 10000 / 100;
    timearray.tm_sec  = a % 100;
    age = mktime( &timearray ) ;

    printf( "231 List of new newsgroups follows\r\n" );
    syslog( LOG_DEBUG, ">231 List of new newsgroups follows" );
    helpdonewgroups( active, age );
    printf( ".\r\n" );
}

/* next bit is copied from INN 1.4 and modified ("broken") by agulbra

   mail to Rich $alz <rsalz@uunet.uu.net> bounced */

/* Scale time back a bit, for shorter Message-ID's. */
#define OFFSET	673416000L

static char ALPHABET[] = "0123456789abcdefghijklmnopqrstuv";

char * generateMessageID( void );

char * generateMessageID( void ) {
    static char buff[80];
    static time_t then;
    static unsigned int fudge;
    time_t now;
    char * p;
    int n;

    now = time(0); /* might be 0, in which case fudge will almost fix it */
    if ( now != then )
	fudge = 0;
    else
	fudge++;
    then = now;

    p = buff;
    *p++ = '<';
    n = (unsigned int)now - OFFSET;
    while( n ) {
	*p++ = ALPHABET[(int)(n & 31)];
	n >>= 5;
    }
    *p++ = '.';
    n = fudge * 32768 + (int)getpid();
    while( n ) {
	*p++ = ALPHABET[(int)(n & 31)];
	n >>= 5;
    }
    sprintf( p, ".ln@%s>", fqdn );
    return buff;
}

/* the end of what I stole from rsalz and then mangled */


void dopost( void ) {
    char * line;
    int havefrom = 0;
    int havepath = 0;
    int havedate = 0;
    int havenewsgroups = 0;
    int havemessageid = 0;
    int havesubject = 0;
    int err = 0;
    int len;
    int out;
    char outname[80];
    static int postingno; /* starts as 0 */

    sprintf( outname, "%s/out.going/%d-%d-%d", 
	     spooldir, (int)getpid(), (int)time(NULL), ++postingno );

    out = open( outname, O_WRONLY|O_EXCL|O_CREAT, 0444 );
    if ( out < 0 ) {
	char dir[80];
	sprintf( dir, "%s/out.going", spooldir );
	mkdir( dir, 0755 );
	out = open( outname, O_WRONLY|O_EXCL|O_CREAT, 0444 );
	if ( out < 0 ) {
	    printf( "440 Unable to open spool file %s\r\n", outname );
	    syslog( LOG_ERR, ">440 Unable to open spool file %s", outname );
	    return;
	}
    }

    printf( "340 Go ahead.\r\n" );
    syslog( LOG_DEBUG, ">340 Go ahead.\r\n" );
    fflush( stdout );

    do {
	int len;
	debug = 0;
	line = getaline( stdin );
	debug = 1;
	if ( !line ) {
	    unlink( outname );
	    exit( 0 );
	}
	if ( !strncasecmp( line, "From: ", 6 ) ) {
	    if ( havefrom )
		err = TRUE;
	    else
		havefrom = TRUE;
	}
	if ( !strncasecmp( line, "Path: ", 6 ) ) {
	    if ( havepath )
		err = TRUE;
	    else
		havepath = TRUE;
	}
	if ( !strncasecmp( line, "Message-ID: ", 12 ) ) {
	    if ( havemessageid )
		err = TRUE;
	    else
		havemessageid = TRUE;
	}
	if ( !strncasecmp( line, "Subject: ", 9 ) ) {
	    if ( havesubject )
		err = TRUE;
	    else
		havesubject = TRUE;
	}
	if ( !strncasecmp( line, "Newsgroups: ", 12 ) ) {
	    if ( havenewsgroups )
		err = TRUE;
	    else
		havenewsgroups = TRUE;
	}
	if ( !strncasecmp( line, "Date: ", 6 ) ) {
	    if ( havedate )
		err = TRUE;
	    else
		havedate = TRUE;
	}
	len = strlen( line );
	if ( len && line[len-1]=='\n' )
	    line[--len] = '\0';
	if ( len && line[len-1]=='\r' )
	    line[--len] = '\0';
	if ( len && line[len-1]=='\r' )
	    line[--len] = '\0';
	if ( len )
	    write( out, line, len );
	else {
	    if ( !havepath ) {
		write( out, "Path: ", 6 );
		write( out, fqdn, strlen( fqdn ) );
		write( out, "!nobody\r\n", 9 );
	    }
	    if ( !havedate ) {
		const char * l = rfctime();
		write( out, "Date: ", 6 );
		write( out, l, strlen( l ) );
		write( out, "\r\n", 2 );
	    }
	    if ( !havemessageid ) {
		char tmp[80];
		sprintf( tmp, "Message-ID: %s\r\n",
			 generateMessageID() );
		write( out, tmp, strlen( tmp ) );
	    }
	}
	write( out, "\r\n", 2 );
    } while ( *line );

    do {
	debug = 0;
	line = getaline( stdin );
	debug = 1;
	if ( !line ) {
	    unlink( outname );
	    exit( 1 );
	}

	len = strlen( line );
	if ( len && line[len-1]=='\n' )
	    line[--len] = '\0';
	if ( len && line[len-1]=='\r' )
	    line[--len] = '\0';
	if ( len && line[len-1]=='\r' )
	    line[--len] = '\0';
	if ( len > 1 && line[0] == '.' )
	    write( out, line+1, len-1 );
	else if ( len )
	    write( out, line, len );
	write( out, "\r\n", 2 );
    } while ( line[0] != '.' || line[1] != '\0' );
    close( out );

    if ( havefrom && havesubject && havenewsgroups && !err ) {
	printf( "240 Article posted, now be patient\r\n" );
	syslog( LOG_DEBUG, ">240 Article posted, now be patient\r\n" );
	return;
    }

    unlink( outname );
    printf( "440 Formatting error, article not posted\r\n" );
    syslog( LOG_DEBUG, ">440 Formatting error, article not posted\r\n" );
}



void doxhdr(char *arg) {
    char * h[] = { "Subject", "From", "Date", "Message-ID", "References",
		   "Bytes", "Lines"
    }; /* ugly emacs workaround */

    int n = 7;
    char * l;
    int a,b,c;
    FILE * f;

    l = arg;
    while( l && *l && !isspace(*l) )
	l++;
    if (l && *l)
	*l++ = '\0';
    while( l && *l && isspace(*l) )
	l++;

    if (l && *l=='<') { /* handle message-id form (well) */
	FILE * f;
	f = fopenart(l);
	if (!f) {
	    printf("430 No such article\r\n");
	    syslog( LOG_DEBUG, ">430 No such article" );
	    return;
	}
	do {
	    l = getaline( f );
	} while (l && *l && 
		 strncasecmp(arg, l, strlen(arg)) && 
		 l[strlen(arg)]!=':'); /* uh, space before : allowed? */
	while( l && *l && !isspace(*l) )
	    l++;
	while( l && *l && isspace(*l) )
	    l++;
	syslog( LOG_DEBUG, "221 First line of %s header follows:", arg );
	printf( "221 First line of %s header follows:\r\n%s\r\n.\r\n",
		arg, l ? l : "" ); /* dubious - if not found, "" */
	fclose( f );
	return;
    } else if (l && isdigit(*l) ) {
	b = a = strtol( l, &l, 10 );
	if (a && l && *l) {
	    while (l && isspace(*l))
		l++;
	    if ( *l == '-' ) {
		l++;
		if ( l && *l )
		    b = strtol( l, &l, 10 );
	    }
	    while (l && isspace(*l))
		l++;
	    if ( l && *l ) {
		syslog( LOG_DEBUG,
			">502 Usage: XHDR header first[-last] or XHDR header message-id\r\n" );
		printf( "502 Usage: XHDR header first[-last] or XHDR header message-id" );
		return;
	    }
	    if ( b==0 )
		b = xlast;
	}
    } else {
	a = b = artno;
    }

    if (!group) {
	syslog( LOG_DEBUG, ">412 Use the GROUP command first " );
	printf( "412 Use the GROUP command first\r\n" );
	return;
    }

    if ( !arg || !*arg ) {
	syslog( LOG_DEBUG,
		"502 Usage: XHDR header first[-last] or XHDR header message-id" );
	printf( "502 Usage: XHDR header first[-last] or XHDR header message-id\r\n" );
	return;
    }

    do {
	n--;
    } while( n>-1 && strncasecmp(arg, h[n], strlen(h[n])) );

    markinterest();

    if ( a < group->first )
	a = group->first;
    else if ( a > group->last )
	a = group->last;

    if ( b < a )
	b = a;
    else if ( b > group->last )
	b = group->last;

    if ( n >= 0 ) {
	syslog( LOG_DEBUG,
		"221 %s header (from overview) for postings %d-%d:", h[n],a,b );
	printf( "221 %s header (from overview) for postings %d-%d:\r\n",
		h[n], a, b );

	if ( xovergroup != group ) {
	    getxover();
	    xovergroup = group;
	}

	s[1023] = '\0';
	for( c=a; c<=b; c++ ) {
	    if ( xoverinfo &&
		 c >= xfirst && c <= xlast &&
		 xoverinfo[c-xfirst].text ) {
		char * l = xoverinfo[c-xfirst].text;
		int d;
		for( d=0; l && d<=n; d++ )
		    l = strchr(l+1, '\t');
		if (l) {
		    char * p;
		    strncpy( s, ++l, 1023 );
		    p = strchr(s, '\t');
		    if (p)
			*p = '\0';
		}
		printf("%d %s\r\n", c, l && *l ? s : "");
	    }
	}
    } else {
	syslog( LOG_DEBUG,
		">221 %s header (from overview) for postings %d-%d:",arg,a,b );
	printf( "221 %s header (from article files) for postings %d-%d:\r\n",
		arg, a, b );
	n = strlen( arg );
	for( c=a; c<=b; c++ ) {
	    sprintf( s, "%d", c );
	    f = fopen( s, "r");
	    while( f ) {
		l = getaline( f );
		if ( !l || !*l || *l == '\r' || *l == '\n' ) {
		    fclose( f );
		    f = 0;
		} else if ( l[n] == ':' &&
			    strncasecmp( arg, l, n ) == 0 ) {
		    printf("%d %s\r\n", c, l + n + 2 );
		}
	    }
	}
    }

    printf( ".\r\n" );
    return;
}


void doxover(const char *arg) {
    FILE * f;
    char * l;
    int a,b, art;

    if (!group) {
	printf( "412 Use the GROUP command first\r\n" );
	syslog( LOG_DEBUG, ">412 Use the GROUP command first" );
	return;
    }

    markinterest();

    l = NULL;
    b = a = strtol( arg, &l, 10 );
    if (a && l && *l) {
	while (l && isspace(*l))
	    l++;
	if ( *l=='-' )
	    b = strtol( ++l, &l, 10 );
	while (l && isspace(*l))
	    l++;
	if ( l && *l ) {
	    printf( "502 Usage: XOVER first[-last]\r\n" );
	    syslog( LOG_DEBUG, ">502 Usage: XOVER first[-last]" );
	    return;
	}
    }

    if ( xovergroup != group && !getxover() ) {
        if ( ( f = fopen(".overview", "r" ) ) != NULL ) {
	    syslog( LOG_DEBUG, "Overview file present but newsgroup unknown" );
	}
	printf( "224 Overview information (pseudo) for postings %d-%d:\r\n",
		a, b );
	syslog( LOG_DEBUG,
		">224 Overview information (pseudo) for postings %d-%d:",
	        a, b );
	printf( "%d\t"
	        "Leafnode placeholder for group %s\t"
		"nobody@%s (Leafnode)\t%s\t"
		"<leafnode.%s@%s>\t\t1000\t40\r\n",
		b, group->name, fqdn, rfctime(), group->name, fqdn );
	printf( ".\r\n" );
	syslog( LOG_DEBUG, ">%d\tLeafnode placeholder for group %s\t"
		"nobody@%s (Leafnode)\t%s\t<leafnode.%s@%s>\t\t1000\t40",
		b, group->name, fqdn, rfctime(), group->name, fqdn );
	return;
    }
    xovergroup = group;

    if ( b==0 )
	b = xlast;

    if ( a > xlast )
	b = xlast;
    if ( b > xlast )
	b = xlast;
    if ( a < xfirst )
	a = xfirst;
    if ( b < xfirst )
	b = xfirst;

    printf( "224 Overview information for postings %d-%d:\r\n", a, b );
    syslog( LOG_DEBUG, ">224 Overview information for postings %d-%d:",
            a, b );
    for( art=a; art<=b; art++ ) {
	if ( xoverinfo[art-xfirst].text )
	    printf( "%s\r\n", xoverinfo[art-xfirst].text );
    }
    printf( ".\r\n" );
}



void dolistgroup( const char * arg ) {
    struct newsgroup * g;
    int art;

    if ( justaftergroup && group && group->name ) {
	int f;
	/* mark the previous group as _possibly_ interesting */
	sprintf( s, "%s/interesting.groups/.%s", spooldir, group->name );
	if ( (f=open( s, O_WRONLY|O_CREAT|O_TRUNC, 0644)) >= 0 )
	    close(f);
    }

    rereadactive();	

    if ( arg && strlen(arg) ) {
	g = findgroup( arg );
	if ( !g ) {
	    printf( "412 No such group: %s\r\n", arg );
	    syslog( LOG_DEBUG, ">412 No such group: %s\r\n", arg );
	    return;
	} else {
	    group = g;
	    artno = g->first;
	    justaftergroup = TRUE; 
	}   
    } else if ( group ) {
	g = group;
    } else {
	printf( "412 No group specified\r\n" );
	syslog( LOG_DEBUG, ">412 No group specified\r\n" );
	return;
    }

    markinterest();
    group = g;
    chdirgroup( g->name );

    if ( (xovergroup != group || xovergroup == NULL) && !getxover() ) {
	printf( "211 Article list for %s follows (pseudo)\r\n", g->name );
	syslog( LOG_DEBUG,
		">211 Article list for %s follows (pseudo)", g->name );
	printf( "%d \r\n", g->last ? g->last : 1 );
	printf( ".\r\n" );
	return;
    }
    xovergroup = group;

    printf( "211 Article list for %s follows\r\n", g->name );
    syslog( LOG_DEBUG, ">211 Article list for %s follows", g->name );
    for( art=xfirst; art<=xlast; art++ ) {
	if ( xoverinfo[art-xfirst].text )
	    printf( "%d \r\n", art );
    }
    printf( ".\r\n" );

    if ( group )
	chdirgroup( group->name );
}
	


int main( int argc, char ** argv ) {
    int fodder;
    struct hostent *he;
    struct sockaddr_in sa;

    fodder = sizeof(struct sockaddr_in);
    if (getsockname(0, (struct sockaddr *)&sa, &fodder)) {
	strcpy( fqdn, "localhost" );
    } else {
	he = gethostbyaddr((char *)&sa.sin_addr.s_addr,
			   sizeof(sa.sin_addr.s_addr),
			   AF_INET);
	strncpy( fqdn, 
		 he && he->h_name ? he->h_name : inet_ntoa(sa.sin_addr),
		 63 );
    }
    if ( strncasecmp( fqdn, "localhost", 9 ) == 0 )
	whoami();

    umask(2);

    openlog( "leafnode", LOG_PID|LOG_CONS, LOG_NEWS );

    printf("200 Leafnode NNTP Daemon, version %s running at %s\r\n", 
	   version, fqdn);
    fflush(stdout);
 
    readconfig();

    rereadactive();

    parser();
    fflush(stdout);
    if ( nntpout )
	fprintf( nntpout, "QUIT\r\n" );

    exit(0);
}
