#ifndef _NVActiveDB_h_
#define _NVActiveDB_h_

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>

#include <iostream.h>
#include <NVHash.h>

#include "config.h"
#include "Debug.h"
#include "NSError.h"
#include "MPList.h"
#include "ActiveDB.h"

/* NVActiveDB {
 * public:
 * int get(group,gi)
 *   Stores informations of the newsgroup group in gi.
 *   Returns 0 on success and -1 if the requested group
 *   cannot be found
 * }
 */

/* System Dependent Data
 * Hashsize of the active database. Use number of groups/(3..10)
 * _Should_ be a prime
 * Eg 211, 503, 1009, 1709, 2903, 4099, 4801, 6007, 7901, 9001, 15013
 */
#define CONF_NVActiveDB_HASHSIZE 15013

#ifdef CONF_NVActiveDB_HASHSIZE
#define NVActiveDB_HASHSIZE CONF_NVActiveDB_HASHSIZE
#else
#define NVActiveDB_HASHSIZE 9001
#endif

class NVActiveDB: public ActiveDB, private NVHash {
protected:
  unsigned long hash(const char *strg);
  void sset(GroupInfo &gi, int flags=0);

public:
  NVActiveDB() : NVHash() {}
  NVActiveDB(char *dbname) : NVHash(dbname,NVActiveDB_HASHSIZE) {}

  int lock(int command, int block=Block) { 
    return NVHash::lock(command,block); 
  }
  int get_lock(void) { 
    return NVHash::get_lock(); 
  }
  
  void open(const char *dbname) { 
    NVHash::open(dbname,NVActiveDB_HASHSIZE); 
  }
  int is_open(void) { 
    return NVHash::is_open(); 
  }
  void close(void) {
    NVHash::close();
  }

  void setmtime(unsigned long tm, int force=0) {
    NVHash::setmtime(tm,force);
  }
  void getmtime(unsigned long *tm) {
    NVHash::getmtime(tm);
  }

  void clear(void) {
    NVHash::clear();
  }
  int is_empty(void) {
    return NVHash::is_empty();
  }

  void add(GroupInfo &gi);
  void set(GroupInfo &gi, int flags=0) {
    lock(ExclLock);
    sset(gi,flags);
    lock(UnLock);
  }
  int get(const char *group, GroupInfo *gi);
  int hasgroup(const char *group);

  void read(istream &is, const char *filter, int flags=0);
  void write(ostream &os, nvtime_t ctime=0, int mode=m_active, 
	     const char *filter=NULL);
  
  friend ostream& operator<<(ostream& os, NVActiveDB &adb) { 
    adb.write(os); return os; 
  }
};

#endif
