#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "config.h"
#include "Debug.h"
#include "sstream.h"

void sstream::connect(char *name, char *service)
{
  char buf[1024];
  int srvr;
  struct sockaddr_in srvr_addr;
  struct hostent *nhost;
  struct servent *cport;

  if(is_connected()) disconnect();
  strcpy(_name,name);
  strcpy(_service,service);

  if ((srvr=socket(AF_INET, SOCK_STREAM, 0))<0) {
    setstate(ios::badbit);
    return;
  }
  
  srvr_addr.sin_family=AF_INET;
  if ((nhost=gethostbyname(name))==NULL) {
    sprintf(buf,"cannot resolve hostname %s",name);
    setstate(ios::badbit);
    return;
  }
  memcpy((char*)&srvr_addr.sin_addr,nhost->h_addr,nhost->h_length);
  if(service[0]!='#') {
    if ((cport=getservbyname(service,"tcp"))==NULL) {
      sprintf(buf,"cannot resolve service %s/tcp \n",service);
      setstate(ios::badbit);
      return;
    }
    srvr_addr.sin_port=cport->s_port;
  } else {
    srvr_addr.sin_port=htons(atoi(service+1));
  }

  if (::connect(srvr,(struct sockaddr*)&srvr_addr,sizeof(srvr_addr))<0) {
    sprintf(buf,"cannot connect to %s (%s)\n",
	    inet_ntoa(srvr_addr.sin_addr),name);
    ::close(srvr);
    setstate(ios::badbit);
    return;
  }
  clear();
  attach(srvr);
}

void sstream::disconnect()
{
  fstream::close();
  _name[0]='\0';
  _service[0]='\0';
}
