// modifier.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "modifier.h"


ModifierChain::ModifierLink::ModifierLink(Modifier* m)
		: modifier(m), next(nil) {
}

ModifierChain::ModifierLink::~ModifierLink() {
	delete modifier;
}

//********

ModifierChain::ModifierChain(Modifier* m1, Modifier* m2, Modifier* m3)
		: list(nil) {
	list = new ModifierLink(m1);
	list->next = new ModifierLink(m2);
	if(m3)
		list->next->next = new ModifierLink(m3);
}

ModifierChain::~ModifierChain() {
	for(ModifierLink* link = list; link != nil; ) {
		ModifierLink* next = link->next;
		delete link;
		link = next;
	}
}

boolean
ModifierChain::configure(Controller *c) {
	if(!isConfigured()) {
		Status status = Fail;
		for(ModifierLink* link = list; link != nil; ) {
			status = link->modifier->configure(c);
			link = link->next;
			if(status != Succeed) break;
		}
		if(status == true)
			initialize();
	}
	return isConfigured();
}

int
ModifierChain::apply() {
	int status = false;
	for(ModifierLink* link = list; link != nil; ) {
		status = link->modifier->apply();
		link = link->next;
		if(status != true) break;
	}
	return status;
}

// create reverse-order chain of reverse Modifiers

Modifier *
ModifierChain::createUnDo() {
	Modifier* unDoer = nil;
	if(list != nil) {
		Modifier* m1 = (list->next->next) ?
			list->next->next->modifier->createUnDo()
			: list->next->modifier->createUnDo();
		Modifier* m2 = (list->next->next) ?
			list->next->modifier->createUnDo() : list->modifier->createUnDo();
		Modifier* m3 = (list->next->next) ?
			list->modifier->createUnDo() : nil;
		unDoer = new ModifierChain(m1, m2, m3);
	}
	return unDoer;
}
