/*
 *  Instrument configuration header file.
 */

#include <stdarg.h>
#include "../../../../include/libgus.h"
#include "../../../../include/gusfiles.h"

#define GUS_ICFG_ACTION_LOAD	0x0000
#define GUS_ICFG_ACTION_PRELOAD	0x0001
#define GUS_ICFG_ACTION_INFO	0x0002

#define GUS_ICFG_FVAR_NONE	0x0000
#define GUS_ICFG_FVAR_STRING	0x0001
#define GUS_ICFG_FVAR_INTEGER	0x0002
#define GUS_ICFG_FVAR_BOOL	0x0004
#define GUS_ICFG_FVAR_TYPE	(GUS_ICFG_FVAR_STRING|GUS_ICFG_FVAR_INTEGER|GUS_ICFG_FVAR_BOOL)
#define GUS_ICFG_FVAR_GLOBAL	0x0100

#define GUS_ICFG_MAX_CONDITION	64

struct gus_icfg_variable {
  unsigned short flags;
  char *name;
  union {
    char *s_value;
    int i_value;
  } data;
  struct gus_icfg_variable *next;
};

struct gus_icfg_config_stru {
  int device;
  char *filename;
  struct gus_icfg_gf1path *gf1paths;
  struct gus_icfg_iwfile *iwfiles;
  struct gus_icfg_instrument *instruments;
  struct gus_icfg_group *groups;
  struct gus_icfg_preload *preloads;
  struct gus_icfg_info *infos;
  /* --- */
  int line_count;
  int abort_flag;
  int condition_true, condition_false, condition_stack_ptr;
  int condition_stack[ GUS_ICFG_MAX_CONDITION ];
  struct gus_icfg_variable *variables;
  int unset_flag;
  int action;
  int source_flag;
  int preload_source_flag;
  int external_flag;
  int exit_value;
  struct gus_icfg_group *tmp_group;
  int tmp_iwfile_number;
  int tmp_drums_flag;
  int tmp_gf1path_directory;
  int tmp_preload;
  struct gus_icfg_preload *tmp_preload_ptr;
  struct gus_icfg_preload_format *tmp_preload_format;
  /* --- */
  int gus_fd;
  int gus_access;
  int card;

  int uart_flag;
  int pnp_flag;
  int midi_emul;
  int global_whole_flag;
  int global_write_status;

  gus_info_t info_data;

  char *load_source, *load_options;
  char *preload_source, *preload_options;

  void *privatedata;
  void (*error)( void *privatedata, int device, int warning, char *filename, int line, char *format, va_list va );
  int (*memory_alloc)( void *privatedata, int device, gus_instrument_t *instrument );
  int (*memory_test)( void *privatedata, int device, unsigned int instrument );
  /* --- */
  struct gus_icfg_config_stru *next;
};

extern struct gus_icfg_config_stru *gus_icfg_config;

/* icfg.c */

#ifndef NO_DPRINTF
#ifdef DEBUG
void __gus_icfg_dprintf( char *format, ... );
#define gus_dprintf( args... ) __gus_icfg_dprintf( ##args )
#else
#define gus_dprintf( args... ) /* nothing */
#endif
#endif

void gus_icfg_error( int warning, char *format, ... );
char *gus_icfg_look_for_patch_file( char *filename );
struct gus_icfg_iwfile *get_ffff_file( int file );

/* lexer.c */

void gus_icfg_lexer_init( int action );
void gus_icfg_lexer_done( void );

void gus_icfg_lexer_define_set( const char *name, unsigned short flags );
int gus_icfg_lexer_define_test( const char *name, unsigned short flags );
void gus_icfg_lexer_define_unset( const char *name, unsigned short flags );
void gus_icfg_lexer_variable_set_string( const char *name, char *value, unsigned short flags );
void gus_icfg_lexer_variable_set_integer( const char *name, int value, unsigned short flags );
void gus_icfg_lexer_variable_set_bool( const char *name, int value, unsigned short flags );
struct gus_icfg_variable *gus_icfg_lexer_variable_get( const char *name, unsigned short flags );
void gus_icfg_lexer_variable_unset( const char *name, unsigned short flags );
void gus_icfg_lexer_include( char *filename );

/* parser.c */

void gus_icfg_parser_init( int action );
void gus_icfg_parser_done( void );
