
#ifndef FALSE
#define FALSE 0
#endif

#ifndef False
#define False 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef True
#define True 1
#endif

#define TYPE_WAVE 0
#define TYPE_AIFC 1
#define TYPE_AU 2
#define TYPE_RAW 3
#define TYPE_NORAW 4
#define TYPE_UNDEFINED 5

#define ONE_SECOND 1000000

typedef unsigned char byte;
typedef byte bool;

#ifdef FreeBSD
typedef unsigned long ulong;
#endif

typedef struct Wave_Datas {
    char	 *name;	           /* name of loaded file */
    char         *actual_name;     /* changed file on HDD */
    int           actual_no;       /* index changed file */
    byte	  res;		   /* 8 or 16 bit */
    byte	  channels;	   /* */
    byte         *buffer;	   /* the data */
    byte	  bpspl;           /* byte per sample */
    int 	  freq;		   /* frequence */
    int	          length;	   /* length of data in bytes */
    int	          markbeg;	   /* the begin of the mark/playline */
    int	          marklength;	   /* the length of the mark */
    int 	  tlength;	   /* length / bpspl */
    int	          fd;		   /* fileno if not complete in mem */
    int           headoffs;
    int           peak_l;
    int           peak_r;
    int           ind_peak_l;      /* index (position) of peak */
    int           ind_peak_r;
    ulong         type;            /* AF_TYPE */
    ulong         comp;            /* AF_COMP */
    ulong         oldtype;         /* changed files on hd are saved in raw mode */
    ulong         oldcomp;         /* later they can saved in original format */
    byte         *lines_l;         /* points for lines for the main */
    byte         *lines_r;         /* graphic window (speedup) */
    bool          inmem;
    bool          ismark;
    bool          isplay;
} Wave_Data;

typedef struct { 
    char *name;
    int fd;
    byte bps;
    byte channels;
    ulong comp;
    ulong type;
    int freq;
    int length;
    int headoffs;
} Audio_File;
