;; $Id: dblink.dsl 1.4 1998/08/22 16:14:41 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= LINKS AND ANCHORS ==========================

(element link 
  (let* ((target (element-with-id 
		  (attribute-string (normalize "linkend")))))
    (if (node-list-empty? target)
	(process-children)
	(make element gi: "A"
	      attributes: (list
			   (list "HREF" (href-to target)))
	      (process-children)))))

(element olink ($charseq$))

(element ulink 
  (make element gi: "A"
	attributes: (list
		     (list "HREF" (attribute-string (normalize "url")))
		     (list "TARGET" "_top"))
	(process-children)))

(element anchor
  (make element gi: "A"
	attributes: (list
		     (list "NAME" (attribute-string (normalize "id"))))
	(empty-sosofo)))

(element beginpage (empty-sosofo))

;; ======================================================================

(element xref
  (let* ((endterm (attribute-string (normalize "endterm")))
	 (linkend (attribute-string (normalize "linkend")))
	 (target  (element-with-id linkend)))
    (if (node-list-empty? target)
	(literal "[xref to non-existent element '" linkend "']")
	(make element gi: "A"
	      attributes: (list
			   (list "HREF" (href-to target)))
	      (if endterm
		  (if (node-list-empty? (element-with-id endterm))
		      (literal "[xref endterm to non-existent element '" endterm "']")
		      (with-mode xref-endterm-mode
			(process-node-list (element-with-id endterm))))
		  (if (attribute-string (normalize "xreflabel") target)
		      (xreflabel-sosofo (attribute-string (normalize "xreflabel") target))
		      (auto-xref target)))))))

(mode xref-endterm-mode
  (default
    (make element gi: "I"
	  (process-children-trim))))

(define (xreflabel-sosofo xreflabel)
  (make element gi: "I"
	(literal xreflabel)))

;; Returns the title of the element as a sosofo, italicized for xref.
;;
(define (element-title-xref-sosofo nd)
  (make element gi: "I"
	(element-title-sosofo nd)))

(mode xref-title-mode
  (element title
    (process-children-trim))
  (element refname
    (process-children-trim))
  (element refentrytitle
    (process-children-trim)))

;; ======================================================================

(define (element-page-number-sosofo target)
  (with-mode pageno-mode
	(process-node-list target)))

(mode pageno-mode
  (default
    (current-node-page-number-sosofo)))

;; ======================================================================

