/* node.h	-- Henry S. Thompson
 *
 */

#ifndef _NODE_H

#include "Node.h"
extern "C" {
#include <stdio.h>
#include "config.h"
#include "funcproto.h"
#include "object.h"
#include "extern.h"
#include "misc.h"
#include "type.h"
#include "gc.h"
}
/* note we don't just include scheme.h because of signal conflicts */

extern int T_Node,T_Node_Size,T_NodeList,T_NodeList_Size;
extern Object Make_Node(Node *);
extern Object Make_NodeList(NodeList *);
extern void elk_init_node(void);

// Elk requires an object in first place, for GC forwarding ptr
struct S_Node {
    Object unused;
    Node* node_;
};

struct S_NodeList {
    Object unused;
    NodeList* nodelist_;
};

#define NODE(obj) ((struct S_Node *)POINTER(obj))
#define NODELIST(obj) ((struct S_NodeList *)POINTER(obj))

#define _NODE_H

#endif
