
/*

  Dedicated to Evelyn Reimann, the most wonderful girl I ever met.
  
 */

#include "cmd.h"

void parse_command_line(int *argc, char ***argv, char *picturefile, int *speed)
{
  int gotx=0,goty=0,gotprg=0,gotpic=0,i;
  char helpmsg[]={"Usage: gicon -x [X on screen] -y [Y on screen] -p [Picturefile]\n\t     -r [Program to run] -a [Arguments for program. Use \"\"] -s [animation speed in ms]\n\t     [-h] [-v]\n"};

  where_x=5;
  where_y=5;
  *speed=3*100;
  cmd[0]='\0';

  if(*argc==1){
    printf("%s",helpmsg);
    exit(1);
  }

  for(i=1;i<*argc;i++){
    if((*argv)[i][0]=='-'){
      switch((*argv)[i][1]){
      case 'h':
	printf("%s",helpmsg);
	exit(1);
      case 'v':
	printf("\nGicon v%s\nwritten by Jonas Aaberg, August 1998.\nMax pictures is set to: %d\n\nDedicated to Evelyn Reimann.\n\n",VERSION,MAX_PICTURES);
	exit(1);
      case 'x':
	where_x=atoi((*argv)[i+1]);
	i++;
	gotx=1;
	break;
      case 'y':
	where_y=atoi((*argv)[i+1]);
	i++;
	goty=1;
	break;
      case 'p':
	strcpy(picturefile,(*argv)[i+1]);
	gotpic=1;
	i++;
	break;
      case 'r':
	strcpy(run,(*argv)[i+1]);
	i++;
	gotprg=1;
	break;
      case 'a':
	strcpy(cmd,(*argv)[i+1]);
	i++;
	break;
      case 's':
	*speed=atoi((*argv)[i+1]);
	i++;
	break;
      default:
	break;
      }
    }
  }
  if(!gotx) printf("Got no X coord. Uses 5.\n");
  if(!goty) printf("Got no Y coord. Uses 5.\n");

  if(!gotpic){
    printf("No picture given.\n");
    exit(2);
  }

  if(!gotprg){
    printf("No program specified.\n");
    exit(3);
  }

  if(where_x<=0 || where_x>3000 || where_y<=0 || where_y>3000){
    printf("You have a really high screen resolution or you are giving me some strange arguments.\nI guess you won't see any icon.\n ");
  }
}
