/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.net.MalformedURLException;
import java.net.URL;
import netscape.application.Bitmap;
import netscape.application.BrokenImageAttachment;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.HRTextAttachment;
import netscape.application.ImageAttachment;
import netscape.application.TextAttachment;
import netscape.application.TextView;
import netscape.application.TextViewHTMLMarker;
import netscape.util.Enumeration;
import netscape.util.Hashtable;

public class TextViewHTMLMarkerImp
extends TextViewHTMLMarker {
    TextAttachment textAttachmentCache;

    public Hashtable attributesForMarker(Hashtable context, Hashtable initialAttributes, TextView textView) {
        if (this.marker.equals("HR") || this.marker.equals("IMG")) {
            String align;
            Hashtable attr;
            Hashtable newAttr;
            if (initialAttributes != null && initialAttributes.count() > 0) {
                newAttr = (Hashtable)TextView.hashtablePool.allocateObject();
                Enumeration enumeration = initialAttributes.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    newAttr.put(key, initialAttributes.get(key));
                }
            } else {
                newAttr = (Hashtable)TextView.hashtablePool.allocateObject();
            }
            TextAttachment attachment = this.textAttachment(textView.baseURL(), textView);
            newAttr.put("TextAttachmentKey", attachment);
            if (this.marker.equals("IMG") && (attr = this.hashtableForHTMLAttributes(this.attributes)) != null && (align = (String)attr.get("ALIGN")) != null) {
                int baselineOffset = 0;
                if (align.equals("TOP")) {
                    int ascent = 0;
                    Font currentFont = (Font)newAttr.get("FontKey");
                    if (currentFont == null) {
                        currentFont = (Font)textView.defaultAttributes().get("FontKey");
                    }
                    if (currentFont != null) {
                        FontMetrics fm = new FontMetrics(currentFont);
                        ascent = fm.ascent();
                    }
                    baselineOffset = attachment.height() - ascent;
                } else if (align.equals("MIDDLE")) {
                    baselineOffset = attachment.height() / 2;
                }
                newAttr.put("TextAttachmentBaselineOffsetKey", new Integer(baselineOffset));
            }
            return newAttr;
        }
        return initialAttributes;
    }

    public String prefix(Hashtable context, char lastChar) {
        if (this.marker.equals("HR")) {
            return "\n\n";
        }
        return "";
    }

    public String string(Hashtable context) {
        if (this.marker.equals("BR")) {
            return "\n";
        }
        return "@";
    }

    private TextAttachment textAttachment(URL baseURL, TextView textView) {
        if (this.textAttachmentCache == null) {
            if (this.marker.equals("HR")) {
                this.textAttachmentCache = new HRTextAttachment();
            } else if (this.marker.equals("IMG")) {
                String hrefUrlStr;
                int width = -1;
                int height = -1;
                Hashtable attr = this.hashtableForHTMLAttributes(this.attributes);
                if (attr != null && (hrefUrlStr = (String)attr.get("SRC")) != null) {
                    try {
                        String str = (String)attr.get("WIDTH");
                        if (str != null) {
                            width = Integer.parseInt(str);
                        }
                        if ((str = (String)attr.get("HEIGHT")) != null) {
                            height = Integer.parseInt(str);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        height = -1;
                        width = -1;
                    }
                    try {
                        URL imageUrl = new URL(baseURL, hrefUrlStr);
                        Bitmap bm = Bitmap.bitmapFromURL(imageUrl);
                        if (bm != null) {
                            bm.loadData();
                        }
                        if (bm != null && bm.isValid()) {
                            this.textAttachmentCache = new ImageAttachment(bm);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("Malformed URL " + hrefUrlStr);
                    }
                }
                if (this.textAttachmentCache == null) {
                    this.textAttachmentCache = new BrokenImageAttachment();
                }
            }
        }
        return this.textAttachmentCache;
    }
}

