/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.io.IOException;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPControl;
import netscape.ldap.client.opers.JDAPAddResponse;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPCompareResponse;
import netscape.ldap.client.opers.JDAPDeleteResponse;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNResponse;
import netscape.ldap.client.opers.JDAPModifyResponse;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class JDAPMessage {
    protected int m_msgid;
    protected JDAPProtocolOp m_protocolOp;
    protected JDAPControl[] m_controls;

    public JDAPMessage(int msgid, JDAPProtocolOp op) {
        this.m_msgid = msgid;
        this.m_protocolOp = op;
    }

    public JDAPMessage(int msgid, JDAPProtocolOp op, JDAPControl[] controls) {
        this.m_msgid = msgid;
        this.m_protocolOp = op;
        this.m_controls = controls;
    }

    public JDAPMessage(BERElement element) throws IOException {
        if (element.getType() != 48) {
            throw new IOException("SEQUENCE in jdap message expected");
        }
        BERSequence seq = (BERSequence)element;
        BERInteger msgid = (BERInteger)seq.elementAt(0);
        this.m_msgid = msgid.getValue();
        BERElement protocolOp = seq.elementAt(1);
        if (protocolOp.getType() != -1) {
            throw new IOException("TAG in protocol operation is expected");
        }
        BERTag tag = (BERTag)protocolOp;
        switch (tag.getTag() & 0x1F) {
            case 1: {
                this.m_protocolOp = new JDAPBindResponse(protocolOp);
                break;
            }
            case 4: {
                this.m_protocolOp = new JDAPSearchResponse(protocolOp);
                break;
            }
            case 3: 
            case 5: {
                this.m_protocolOp = new JDAPSearchResult(protocolOp);
                break;
            }
            case 7: {
                this.m_protocolOp = new JDAPModifyResponse(protocolOp);
                break;
            }
            case 9: {
                this.m_protocolOp = new JDAPAddResponse(protocolOp);
                break;
            }
            case 11: {
                this.m_protocolOp = new JDAPDeleteResponse(protocolOp);
                break;
            }
            case 13: {
                this.m_protocolOp = new JDAPModifyRDNResponse(protocolOp);
                break;
            }
            case 15: {
                this.m_protocolOp = new JDAPCompareResponse(protocolOp);
                break;
            }
            case 19: {
                this.m_protocolOp = new JDAPSearchResultReference(protocolOp);
                break;
            }
            case 24: {
                this.m_protocolOp = new JDAPExtendedResponse(protocolOp);
                break;
            }
            default: {
                throw new IOException("Unknown rotocol operation");
            }
        }
        if (seq.size() >= 3 && (tag = (BERTag)seq.elementAt(2)).getTag() == 160) {
            BERSequence controls = (BERSequence)tag.getValue();
            this.m_controls = new JDAPControl[controls.size()];
            int i = 0;
            while (i < controls.size()) {
                this.m_controls[i] = new JDAPControl(controls.elementAt(i));
                ++i;
            }
        }
    }

    public int getId() {
        return this.m_msgid;
    }

    public JDAPProtocolOp getProtocolOp() {
        return this.m_protocolOp;
    }

    public JDAPControl[] getControls() {
        return this.m_controls;
    }

    public void write(OutputStream s) throws IOException {
        BERSequence seq = new BERSequence();
        BERInteger i = new BERInteger(this.m_msgid);
        seq.addElement(i);
        BERElement e = this.m_protocolOp.getBERElement();
        if (e == null) {
            throw new IOException("Bad BER element");
        }
        seq.addElement(e);
        if (this.m_controls != null) {
            BERSequence c = new BERSequence();
            int j = 0;
            while (j < this.m_controls.length) {
                c.addElement(this.m_controls[j].getBERElement());
                ++j;
            }
            BERTag t = new BERTag(160, c, true);
            seq.addElement(t);
        }
        seq.write(s);
    }

    public String toString() {
        return "[JDAPMessage] " + this.m_msgid + " " + this.m_protocolOp.toString();
    }
}

