/*
 * Copyright 1988, 1992 Hiroto Kagotani
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Hiroto Kagotani not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 *
 * HIROTO KAGOTANI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL HIROTO KAGOTANI BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author:
 * 	Hiroto Kagotani
 * 	Dept. of Computer Science
 *	Tokyo Institute of Technology
 * 	2-12-2 Ookayama, Meguro-ku Tokyo 152 Japan
 * 	kagotani@cs.titech.ac.jp
 */ 

#include	<stdio.h>
#include	<ctype.h>	/* isdigit(), isxdigit macro */
#include	<strings.h>	/* bzero() function */
#include	<sys/param.h>	/* howmany() macro */
#include	"def.h"

extern char	*optarg;
extern int	optind, opterr;

int	numerator_x = 1, denominator_x = 1;
int	numerator_y = 1, denominator_y = 1;
int	blackness = 4;
char	linebuf[BUFSIZE];

static int	line;

main(argc, argv)
int	argc;
char	*argv[];
{
	int	c, err = 0;
	int	charcount;
	while ((c = getopt(argc, argv, "vb:w:h:f:")) != EOF) {
		switch (c)  {
		case 'v':
			version();
			exit(0);
			break;
		case 'b':
			blackness = atoi(optarg);
			if (blackness <= 0) err ++;
			break;
		case 'w':
			numerator_x = atoi(optarg);
			denominator_x = index(optarg,'/')
					? atoi(index(optarg,'/')+1) : 1;
			if (numerator_x <= 0 || denominator_x <= 0) err ++;
			break;
		case 'h':
			numerator_y = atoi(optarg);
			denominator_y = index(optarg,'/')
					? atoi(index(optarg,'/')+1) : 1;
			if (numerator_y <= 0 || denominator_y <= 0) err ++;
			break;
		case 'f':
			numerator_x = numerator_y = atoi(optarg);
			denominator_x = denominator_y = index(optarg,'/')
					? atoi(index(optarg,'/')+1) : 1;
			if (numerator_x <= 0 || denominator_x <= 0) err ++;
			break;
		case '?':
			err ++;
			break;
		}
	}
	if (err) {
		version();
		usage();
		exit(1);
	}
	if (optind < argc && freopen(argv[optind], "r", stdin) == NULL) {
		perror(argv[optind]);
		exit(1);
	}
	charcount = processHeader();
	for (; charcount > 0; charcount --) {
		processChar();
	}
	processFooter();
	exit(0);
	/* NOTREACHED */
}


int
processHeader()
{
	startfont();
	font();
	size();
	fontboundingbox();
	processProperties();
	return chars();
}


processFooter()
{
	endfont();
}


processProperties()
{
	int	arg;

	get_line();
	if (beginwith(linebuf, "STARTPROPERTIES")) { /* optional */
		if (sscanf(linebuf, "STARTPROPERTIES %d", &arg) != 1
		    || arg < 0) {
			error("STARTPROPERTIES has illegal or no arguments\n");
		}
		put_line();
		for (; arg > 0; arg --) {
			get_line();
			if (beginwith(linebuf, "FONT_ASCENT")) {
				hresize("FONT_ASCENT");
			} else if (beginwith(linebuf, "FONT_DESCENT")) {
				yresize("FONT_DESCENT");
			} else if (beginwith(linebuf, "PIXEL_SIZE")) {
				hresize("PIXEL_SIZE");
			} else if (beginwith(linebuf, "POINT_SIZE")) {
				hresize("POINT_SIZE");
			} else if (beginwith(linebuf, "AVERAGE_WIDTH")) {
				wresize("AVERAGE_WIDTH");
			}
			put_line();
		}
		get_line();
		if (!beginwith(linebuf, "ENDPROPERTIES")) {
			error("ENDPROPERTIES expected\n");
		}
		put_line();
		get_line();
	}
}


wresize(prop)
char	*prop;
{
	int	arg;
	char	form[100];
	char	errbuf[100];
	sprintf(form, "%s %%d", prop);
	if (sscanf(linebuf, form, &arg) != 1) {
		sprintf(errbuf, "%s has illegal or no arguments\n", prop);
		error(errbuf);
	}
	sprintf(linebuf, "%s %d", prop, WRESIZE(arg));
}


hresize(prop)
char	*prop;
{
	int	arg;
	char	form[100];
	char	errbuf[100];
	sprintf(form, "%s %%d", prop);
	if (sscanf(linebuf, form, &arg) != 1) {
		sprintf(errbuf, "%s has illegal or no arguments\n", prop);
		error(errbuf);
	}
	sprintf(linebuf, "%s %d", prop, HRESIZE(arg));
}


yresize(prop)
char	*prop;
{
	int	arg;
	char	form[100];
	char	errbuf[100];
	sprintf(form, "%s %%d", prop);
	if (sscanf(linebuf, form, &arg) != 1) {
		sprintf(errbuf, "%s has illegal or no arguments\n", prop);
		error(errbuf);
	}
	sprintf(linebuf, "%s %d", prop, YRESIZE(arg));
}


startfont()
{
	char	arg[BUFSIZE];

	get_line();
	if (!beginwith(linebuf, "STARTFONT")) {
		error("STARTFONT expected\n");
	}
	if (sscanf(linebuf, "STARTFONT %s", arg) != 1) {
		error("STARTFONT has illegal or no arguments\n");
	}
	if (strcmp(arg, "2.1")) {
		error("STARTFONT version error\n");
	}
	put_line();
	sprintf(linebuf,
	    "COMMENT This font was automatically resized by bdfresize-%s",
	    VERSION);
	put_line();
	sprintf(linebuf,
	    "COMMENT   mag_x = %d/%d, mag_y = %d/%d, blackness = %d",
	    numerator_x, denominator_x, numerator_y, denominator_y, blackness);
	put_line();
}


font()
{
	char *cp;
	get_line();
	if (!beginwith(linebuf, "FONT")) {
		error("FONT expected\n");
	}
	cp = linebuf + 4;
	while (*cp && isspace(*cp)) cp++;
	if (!*cp) {
		error("FONT has no arguments\n");
	}
	if (*cp == '+' || *cp == '-') { /* xlfd */
		resize_xlfd(cp);
	}
	put_line();
}


resize_xlfd(xlfd)
char	*xlfd;
{
	char	buf[BUFSIZE];
	char	*p, *q;

	buf[0] = '\0';

	if ((q = index(p = xlfd, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* XFontNameRegistry */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* FOUNDRY */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* FAMILY_NAME */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* WEIGHT_NAME */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* SLANT */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* SETWIDTH_NAME */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* ADD_STYLE_NAME */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	if (!isnumber(p)) { fputs(p, stdout); putchar('-'); goto parseerror; }
	sprintf(buf + strlen(buf), "%d", HRESIZE(atoi(p))); strcat(buf, "-");
	/* PIXEL_SIZE */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	if (!isnumber(p)) { fputs(p, stdout); putchar('-'); goto parseerror; }
	sprintf(buf + strlen(buf), "%d", HRESIZE(atoi(p))); strcat(buf, "-");
	/* POINT_SIZE */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* RESOLUTION_X */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* RESOLUTION_Y */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* SPACING */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	if (!isnumber(p)) { fputs(p, stdout); putchar('-'); goto parseerror; }
	sprintf(buf + strlen(buf), "%d", WRESIZE(atoi(p))); strcat(buf, "-");
	/* AVERAGE_WIDTH */

	if ((q = index(p = q + 1, '-')) == NULL) goto parseerror;
	*q = '\0';
	strcat(buf, p); strcat(buf, "-");
	/* CHARSET_REGISTRY */

	if ((q = index(p = q + 1, '-')) != NULL) goto parseerror;
	strcat(buf, p);
	/* CHARSET_ENCODING */

	strcpy(xlfd, buf);
	return;

  parseerror:
	fprintf(stderr, "Cannot parse XLFD '%s'\n", xlfd);
	strcat(buf, p);			/* rest */

	strcpy(xlfd, buf);
	return;
}


int
isnumber(p)
char	*p;
{
	if (!*p) return 0;
	while (*p && isdigit(*p)) {
		p ++;
	}
	if (*p) return 0;

	return 1;
}


size()
{
	int	arg1, arg2, arg3;
	int	newsize;

	get_line();
	if (!beginwith(linebuf, "SIZE")) {
		error("SIZE expected\n");
	}
	if (sscanf(linebuf, "SIZE %d %d %d", &arg1, &arg2, &arg3) != 3
	  || arg1 <= 0 || arg2 <= 0 || arg3 <= 0) {
		error("SIZE has illegal arguments\n");
	}
	newsize = HRESIZE(arg1);
	sprintf(linebuf, "SIZE %d %d %d", newsize, arg2, arg3);
	put_line();
}


fontboundingbox()
{
	int	arg1, arg2, arg3, arg4;
	int	new1, new2, new3, new4;

	get_line();
	if (!beginwith(linebuf, "FONTBOUNDINGBOX")) {
		error("FONTBOUNDINGBOX expected\n");
	}
	if (sscanf(linebuf, "FONTBOUNDINGBOX %d %d %d %d",
				&arg1, &arg2, &arg3, &arg4) != 4
	  || arg1 <= 0 || arg2 <= 0) {
		error("FONTBOUNDINGBOX has illegal arguments\n");
	}
	new1 = WRESIZE(arg1);
	new2 = HRESIZE(arg2);
	new3 = XRESIZE(arg3);
	new4 = YRESIZE(arg4);
	sprintf(linebuf, "FONTBOUNDINGBOX %d %d %d %d", new1,new2,new3,new4);
	put_line();
}


int
chars()
{
	int	arg;

	if (!beginwith(linebuf, "CHARS")) {
		error("CHARS expected\n");
	}
	if (sscanf(linebuf, "CHARS %d", &arg) != 1 || arg < 0) {
		error("CHARS has illegal or no arguments\n");
	}
	put_line();
	return arg;
}


endfont()
{
	get_line();
	if (!beginwith(linebuf, "ENDFONT")) {
		error("ENDFONT expected\n");
	}
	put_line();
}


get_line()
{
	while (gets(linebuf) != NULL) {
		line ++;
		if (linebuf[0] == '\0' || beginwith(linebuf, "COMMENT")) {
			put_line();
		} else {
			return;
		}
	}
	error("EOF detected\n");
}


put_line()
{
	puts(linebuf);
}


beginwith(l, s)
char	*l;
char	*s;
{
	return !strncmp(l, s, strlen(s));
}


error(fmt, a, b, c, d, e, f, g)
char	*fmt;
{
	char	buf[100];
	strcat(buf, "bdfresize: line %d: ");
	strcat(buf, fmt);
	fprintf(stderr, buf, line, a, b, c, d, e, f, g);
	exit(1);
}


usage()
{
	fprintf(stderr, "usage: bdfresize [-options] [bdffile]\n");
	fprintf(stderr, "  -v : show version\n");
	fprintf(stderr, "  -b <number> : blackness (default = 4)\n");
	fprintf(stderr, "  -f <factor> : \n");
	fprintf(stderr, "  -w <factor> : (width only)\n");
	fprintf(stderr, "  -h <factor> : (height only)\n");
	fprintf(stderr, "    (<factor> ::= digits | digits/digits)\n");
}


version()
{
	fprintf(stderr, "bdfresize: version %s\n", VERSION);
}
