.\" t
.\" @(#)FvwmTile.1  11/27/96
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH FvwmTile 1 "November 27, 1996" "FvwmTile 1.0" "FvwmTile 1.0"
.UC
.SH NAME
FvwmTile \- tile FVWM windows
.SH SYNOPSIS
FvwmTile is spawned by fvwm, so no command line invocation will work.

.SH DESCRIPTION
This module attempts to tile windows on the current screen subject to
certain constraints.  Horizontal or vertical tiling is performed so
that each window does not overlap another, and by default each window
is resized to its nearest resize increment (note sometimes some space
might appear between tiled windows -- this is why).

.SH INVOCATION
FvwmTile is best invoked from a menu, popup or button.  There are a
number of command line options which can be used to constrain the
layering, these are described below.  As an example case, one could
call FvwmTile with the following arguments:
.EX
FvwmTile -h 10 10 90 90
.EE

This invocation will horizontally tile windows with a bounding box
which starts at 10 by 10 percent into and down the screen and ends at
90 by 90 percent into and down the screen.

Command-line arguments passed to FvwmTile are described here.
.IP \-a
Causes \fIall\fP window styles to be affected, even ones with the
WindowListSkip style.
.IP \-desk
Causes all windows on the desk to be cascaded instead of the current
screen only.
.IP \-h
Tiles horizontally (default is to tile vertically).
.IP \-m
Causes maximized windows to also be affected (implied by \-all).
.IP "\-mn \fIarg\fP"
Tiles up to \fIarg\fP windows in tile direction.  If more windows
exist, a new direction row or column is created (in effect, a matrix
is created).
.IP \-noraise
Inhibits window raising, leaving the depth ordering intact.
.IP \-noresize
Inhibits window resizing, leaving window sizes intact.
.IP \-nostretch
Inhibits window growth to fit tile.  Windows are shrunk to fit the
tile but not expanded.
.IP \-r
Reverses the window sequence.
.IP \-s
Causes sticky windows to also be affected (implied by \-all).
.IP \-t
Causes transient windows to also be affected (implied by \-all).
.IP \-u
Causes untitled windows to also be affected (implied by \-all).

Up to four numbers can be placed on the command line that are not
switches.  The first pair specify an x and y offset to start the first
window (default is 0, 0).  The second pair specify an absolute
coordinate reference denoting the lower right bounding box for tiling.
If any number is suffixed with the letter p, then it is taken to be a
pixel value, otherwise it is interpreted as a screen percentage.
Specifying zero for any parameter is equivalent to not specifying it.

.SH BUGS
It is probably not a good idea to delete windows while windows are
being tiled.

.SH AUTHOR
Andrew Veliath
