/*
 * IceWM
 *
 * Copyright (C) 1998 Marko Macek
 */

/* just a quick hack */

#include "icewm.h"
#include <dirent.h>

BrowseMenu::BrowseMenu(const char *path,
                         YWindow *parent): ObjectMenu(parent)
{
    fPath = strdup(path);
    fModTime = 0;
}

BrowseMenu::~BrowseMenu() {
    FREE(fPath);
}

void BrowseMenu::updatePopup() {
    struct stat sb;

    if (stat(fPath, &sb) != 0)
        removeAll();
    else if (sb.st_mtime > fModTime) {
        fModTime = sb.st_mtime;
        
        removeAll();

        DIR *dir;
        int plen = strlen(fPath);

        if ((dir = opendir(fPath)) != NULL) {
            struct dirent *de;
            bool isDir;
            int nlen;
            char *npath;
            YMenu *sub;
            YMenu::YMenuItem *item;
            char *name;

            while ((de = readdir(dir)) != NULL) {
                nlen = plen + 1 + strlen(de->d_name) + 1;
                npath = (char *)MALLOC(nlen);

                if (npath && de->d_name[0] != '.') {
                    strcpy(npath, fPath);
                    if (plen == 0 || npath[plen - 1] != '/') {
                        strcpy(npath + plen, "/");
                        strcpy(npath + plen + 1, de->d_name);
                    } else {
                        strcpy(npath + plen, de->d_name);
                    }

                    isDir = false;
                    
                    if (stat(npath, &sb) == 0)
                        if (S_ISDIR(sb.st_mode))
                            isDir = true;
                    
                    sub = 0;
                    if (isDir)
                        sub = new BrowseMenu(npath);

                    name = strdup(de->d_name);
                    
                    if (name) {
                        item = new YMenuItem(name, -1, 0,
                                             cmdOpen,
                                             sub, (void *)npath);
                        add(item);
                    }
                }
            }
            closedir(dir);
        }
    }
}
