
#ifdef CFGDEF
#define XSV(t,a,b) t a = b;
#else
#define XSV(t,a,b) extern t a;
#endif

#ifndef NO_CONFIGURE
#ifdef CFGDEF
#define XIV(t,a,b) t a = b;
#else
#define XIV(t,a,b) extern t a;
#endif
#else
#ifdef CFGDEF
#define XIV(t,a,b)
#else
#define XIV(t,a,b) static const t a = b;  // I hope this can be optimized away ?
#endif
#endif

#ifndef CFGDEF
typedef enum {
#ifdef CONFIG_LOOK_WIN95
    lookWin95,
#endif
#ifdef CONFIG_LOOK_MOTIF
    lookMotif,
#endif
#ifdef CONFIG_LOOK_WARP3
    lookWarp3,
#endif
#ifdef CONFIG_LOOK_WARP4
    lookWarp4,
#endif
#ifdef CONFIG_LOOK_NICE
    lookNice,
#endif
#ifdef CONFIG_LOOK_PIXMAP
    lookPixmap,
#endif
#ifdef CONFIG_LOOK_METAL
    lookMetal,
#endif
#ifdef CONFIG_LOOK_GTK
    lookGtk,
#endif
    // !!! TODO: lookWin31
    lookMAX
} WMLook;
#endif

XIV(bool, clickFocus                  , true)
XIV(bool, raiseOnFocus                , true)
XIV(bool, focusOnClickClient          , true)
XIV(bool, raiseOnClickClient          , true)
XIV(bool, raiseOnClickButton          , true)
XIV(bool, raiseOnClickFrame           , true)
XIV(bool, raiseOnClickTitleBar        , true)
XIV(bool, passFirstClickToClient      , true)
XIV(bool, focusOnMap                  , true)
XIV(bool, focusOnMapTransient         , true)
XIV(bool, focusRootWindow             , false)
XIV(bool, pointerColormap             , false)
XIV(bool, sizeMaximized               , false)
XIV(bool, taskBarAtTop                , false)
XIV(bool, showMoveSizeStatus          , true)
XIV(bool, beepOnNewMail               , false)
XIV(bool, warpPointer                 , false)
XIV(bool, opaqueMove                  , true)
XIV(bool, opaqueResize                , true)
XIV(bool, win95keys                   , false)
XIV(bool, showTaskBar                 , true)
XIV(bool, taskBarShowClock            , true)
XIV(bool, taskBarShowMailboxStatus    , true)
XIV(bool, taskBarShowStartMenu        , true)
XIV(bool, taskBarShowWindowListMenu   , true)
XIV(bool, taskBarShowWorkspaces       , true)
XIV(bool, taskBarShowAllWindows       , false)
XIV(bool, taskBarAutoHide             , false)
XIV(bool, minimizeToDesktop           , false)
XIV(bool, prettyClock                 , true)
XIV(bool, manualPlacement             , false)
XIV(bool, menuMouseTracking           , false)
XIV(bool, autoRaise                   , false)
XIV(bool, delayPointerFocus           , false)
XIV(bool, useMouseWheel               , false)
XIV(bool, taskBarDoubleHeight         , false)
XIV(bool, taskBarShowCPUStatus        , true)
XIV(bool, quickSwitchToMinimized      , true)
XIV(WMLook, wmLook                    , CONFIG_DEFAULT_LOOK)
XIV(unsigned int, wsBorderX           , 6)
XIV(unsigned int, wsBorderY           , 6)
XIV(unsigned int, wsDlgBorderX        , 2)
XIV(unsigned int, wsDlgBorderY        , 2)
XIV(unsigned int, wsTitleBar          , 20)
XIV(unsigned int, wsCornerX           , 24)
XIV(unsigned int, wsCornerY           , 24)
XIV(unsigned int, ClickMotionDistance , 4)
XIV(unsigned int, ClickMotionDelay    , 200)
XIV(unsigned int, MultiClickTime      , 400)
XIV(unsigned int, ToolTipDelay        , 1000)
XIV(unsigned int, EdgeResistance      , 32)
XIV(unsigned int, useXButton          , 1)
XIV(unsigned int, pointerFocusDelay   , 200);
XIV(unsigned int, autoRaiseDelay      , 400)
XIV(unsigned int, autoHideDelay       , 250)
XSV(const char *, themeName                 , CONFIG_DEFAULT_THEME)
XSV(const char *, titleFontName             , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, menuFontName              , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, statusFontName            , "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, switchFontName            , "-adobe-courier-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, normalButtonFontName      , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, activeButtonFontName      , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, normalTaskBarFontName     , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, activeTaskBarFontName     , "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, minimizedWindowFontName   , "-adobe-helvetica-medium-r-*-*-*-100-*-*-*-*-*-*")
XSV(const char *, windowListFontName        , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, toolTipFontName           , "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*")
XSV(const char *, clockFontName             , "-adobe-courier-bold-r-*-*-*-140-*-*-*-*-*-*")
XSV(const char *, iconPath                  , 0)
XSV(const char *, libDir                    , LIBDIR);
XSV(const char *, configDir                 , CONFIGDIR);
XSV(const char *, mailBoxPath               , 0)
XSV(const char *, mailCommand               , 0)
XSV(const char *, lockCommand               , 0)
XSV(const char *, clockCommand              , 0)
XSV(const char *, runDlgCommand                , 0)
XSV(const char *, openCommand               , 0)
XSV(const char *, fmtTime                   , "%H:%M:%S")
XSV(const char *, fmtDate                   , "%y %m %d")
XSV(const char *, clrDialog                 , "rgb:C0/C0/C0")
XSV(const char *, clrActiveBorder           , "rgb:C0/C0/C0")
XSV(const char *, clrInactiveBorder         , "rgb:C0/C0/C0")
XSV(const char *, clrNormalTitleButton      , "rgb:C0/C0/C0")
XSV(const char *, clrNormalTitleButtonText  , "rgb:00/00/00")
XSV(const char *, clrActiveTitleBar         , "rgb:00/00/A0")
XSV(const char *, clrInactiveTitleBar       , "rgb:80/80/80")
XSV(const char *, clrActiveTitleBarText     , "rgb:FF/FF/FF")
XSV(const char *, clrInactiveTitleBarText   , "rgb:00/00/00")
XSV(const char *, clrNormalMinimizedWindow  , "rgb:C0/C0/C0")
XSV(const char *, clrNormalMinimizedWindowText, "rgb:00/00/00")
XSV(const char *, clrActiveMinimizedWindow  , "rgb:E0/E0/E0")
XSV(const char *, clrActiveMinimizedWindowText, "rgb:00/00/00")
XSV(const char *, clrNormalMenu             , "rgb:C0/C0/C0")
XSV(const char *, clrActiveMenuItem         , "rgb:00/00/A0")
XSV(const char *, clrActiveMenuItemText     , "rgb:FF/FF/FF")
XSV(const char *, clrNormalMenuItemText     , "rgb:00/00/00")
XSV(const char *, clrDisabledMenuItemText   , "rgb:80/80/80")
XSV(const char *, clrMoveSizeStatus         , "rgb:C0/C0/C0")
XSV(const char *, clrMoveSizeStatusText     , "rgb:00/00/00")
XSV(const char *, clrQuickSwitch            , "rgb:C0/C0/C0")
XSV(const char *, clrQuickSwitchText        , "rgb:00/00/00")
XSV(const char *, clrDefaultTaskBar         , "rgb:C0/C0/C0")
XSV(const char *, clrNormalButton           , "rgb:C0/C0/C0")
XSV(const char *, clrNormalButtonText       , "rgb:00/00/00")
XSV(const char *, clrActiveButton           , "rgb:E0/E0/E0")
XSV(const char *, clrActiveButtonText       , "rgb:00/00/00")
/// !!! fix colors for task bar buttons (use button colors + overrides)
XSV(const char *, clrNormalTaskBarApp       , "rgb:C0/C0/C0")
XSV(const char *, clrNormalTaskBarAppText   , "rgb:00/00/00")
XSV(const char *, clrActiveTaskBarApp       , "rgb:E0/E0/E0")
XSV(const char *, clrActiveTaskBarAppText   , "rgb:00/00/00")
XSV(const char *, clrMinimizedTaskBarApp    , "rgb:A0/A0/A0")
XSV(const char *, clrMinimizedTaskBarAppText, "rgb:00/00/00")
XSV(const char *, clrScrollBar              , "rgb:A0/A0/A0")
XSV(const char *, clrScrollBarArrow         , "rgb:C0/C0/C0")
XSV(const char *, clrScrollBarSlider        , "rgb:C0/C0/C0")
XSV(const char *, clrListBox                , "rgb:C0/C0/C0")
XSV(const char *, clrListBoxText            , "rgb:00/00/00")
XSV(const char *, clrListBoxSelected        , "rgb:80/80/80")
XSV(const char *, clrListBoxSelectedText    , "rgb:00/00/00")
XSV(const char *, clrToolTip                , "rgb:E0/E0/00")
XSV(const char *, clrToolTipText            , "rgb:00/00/00")
XSV(const char *, clrClock                  , "rgb:00/00/00")
XSV(const char *, clrClockText              , "rgb:00/FF/00")
XSV(const char *, DesktopBackgroundColor    , "rgb:00/50/60")
XSV(const char *, DesktopBackgroundPixmap   , 0)

#if defined(CFGDEF) && !defined(NO_CONFIGURE)

static struct {
    const char *option;
    bool *value;
} bool_options[] = {
    { "ClickToFocus", &clickFocus }, //
    { "RaiseOnFocus", &raiseOnFocus }, //
    { "FocusOnClickClient", &focusOnClickClient }, //
    { "RaiseOnClickClient", &raiseOnClickClient }, //
    { "RaiseOnClickTitleBar", &raiseOnClickTitleBar }, //
    { "RaiseOnClickButton", &raiseOnClickButton }, //
    { "RaiseOnClickFrame", &raiseOnClickFrame }, //
    { "PassFirstClickToClient", &passFirstClickToClient }, //
    { "FocusOnMap", &focusOnMap }, //
    { "FocusOnMapTransient", &focusOnMapTransient }, //
    { "PointerColormap", &pointerColormap }, //
    { "SizeMaximized", &sizeMaximized }, //
    { "ShowMoveSizeStatus", &showMoveSizeStatus }, //
    { "MinimizeToDesktop", &minimizeToDesktop }, //
    { "WarpPointer" , &warpPointer }, //
    { "OpaqueMove", &opaqueMove }, //
    { "OpaqueResize", &opaqueResize }, //
    { "ShowTaskBarClock", &taskBarShowClock }, // obsolete
    { "ShowMailBoxStatus", &taskBarShowMailboxStatus }, // obsolete
    { "PrettyClock", &prettyClock }, // obsolete
    { "BeepOnNewMail", &beepOnNewMail },
    { "ShowTaskBar", &showTaskBar },
    { "TaskBarAtTop" , &taskBarAtTop }, //
    { "TaskBarAutoHide", &taskBarAutoHide },//
    { "TaskBarShowClock", &taskBarShowClock }, //
    { "TaskBarClockLeds", &prettyClock }, //
    { "TaskBarShowMailboxStatus", &taskBarShowMailboxStatus }, //
    { "TaskBarMailboxStatusBeepOnNewMail", &beepOnNewMail }, //
    { "TaskBarShowWorkspaces", &taskBarShowWorkspaces }, //
    { "TaskBarShowAllWindows", &taskBarShowAllWindows }, //
    { "TaskBarShowStartMenu", &taskBarShowStartMenu }, //
    { "TaskBarShowWindowListMenu", &taskBarShowWindowListMenu }, //
    { "ManualPlacement", &manualPlacement }, //
    { "MenuMouseTracking", &menuMouseTracking }, //
    { "AutoRaise", &autoRaise }, //
    { "DelayPointerFocus", &delayPointerFocus },
    { "Win95Keys", &win95keys }, //
    { "UseMouseWheel", &useMouseWheel }, //
    { "TaskBarDoubleHeight", &taskBarDoubleHeight }, //
    { "TaskBarShowCPUStatus", &taskBarShowCPUStatus }, //
    { "QuickSwitchToMinimized", &quickSwitchToMinimized } //
};

static struct {
    const char *option;
    unsigned int *value;
    unsigned int min, max;
} uint_options[] = {
    { "ShowXButton", &useXButton, 0, 2 }, //
    { "BorderSizeX", &wsBorderX, 0, 128 }, //
    { "BorderSizeY", &wsBorderY, 0, 128 }, //
    { "DlgBorderSizeX", &wsDlgBorderX, 0, 128 }, //
    { "DlgBorderSizeY", &wsDlgBorderY, 0, 128 }, //
    { "TitleBarHeight", &wsTitleBar, 0, 128 }, //
    { "CornerSizeX", &wsCornerX, 0, 64 }, //
    { "CornerSizeY", &wsCornerY, 0, 64 }, //
    { "ClickMotionDistance", &ClickMotionDistance, 0, 32 }, //
    { "ClickMotionDelay", &ClickMotionDelay, 0, 2000 }, //
    { "MultiClickTime", &MultiClickTime, 0, 5000 }, //
    { "ToolTipDelay", &ToolTipDelay, 0, 5000 }, //
    { "AutoHideDelay", &autoHideDelay, 0, 5000 },
    { "AutoRaiseDelay", &autoRaiseDelay, 0, 5000 },
    { "EdgeResistance", &EdgeResistance, 0, 10000 },
    { "PointerFocusDelay", &pointerFocusDelay, 0, 1000 }
};

static struct {
    const char *option;
    const char **value;
    bool initial;
} string_options[] = {
    //    { "display", &displayName, 1 },
    { "Theme", &themeName, 1 }, //
    { "TitleFontName", &titleFontName, 1 }, //
    { "MenuFontName", &menuFontName, 1 }, //
    { "StatusFontName", &statusFontName, 1 }, //
    { "QuickSwitchFontName", &switchFontName, 1 }, //
    { "NormalTaskBarFontName", &normalTaskBarFontName, 1 }, //
    { "ActiveTaskBarFontName", &activeTaskBarFontName, 1 }, //
    { "WindowListFontName", &windowListFontName, 1 }, //
    { "ToolTipFontName", &toolTipFontName, 1 }, //
    { "ClockFontName", &clockFontName, 1 }, //
    { "IconPath", &iconPath, 1 }, //
    { "MailBoxPath", &mailBoxPath, 1 },
    { "MailCommand", &mailCommand, 1 }, //
    { "LockCommand", &lockCommand, 1 }, //
    { "ClockCommand", &clockCommand, 1 }, //
    { "RunCommand", &runDlgCommand, 1 }, //
    { "OpenCommand", &openCommand, 1 },
    { "TimeFormat", &fmtTime, 1 }, //
    { "DateFormat", &fmtDate, 1 }, //
    { "ColorDialog", &clrDialog, 1 },
    { "ColorActiveBorder", &clrActiveBorder, 1 },
    { "ColorNormalBorder", &clrInactiveBorder, 1 },
    { "ColorNormalTitleButton", &clrNormalTitleButton, 1 },
    { "ColorNormalTitleButtonText", &clrNormalTitleButtonText, 1 },
    { "ColorNormalButton", &clrNormalButton, 1 },
    { "ColorNormalButtonText", &clrNormalButtonText, 1 },
    { "ColorActiveButton", &clrActiveButton, 1 },
    { "ColorActiveButtonText", &clrActiveButtonText, 1 },
    { "ColorActiveTitleBar", &clrActiveTitleBar, 1 },
    { "ColorNormalTitleBar", &clrInactiveTitleBar, 1 },
    { "ColorActiveTitleBarText", &clrActiveTitleBarText, 1 },
    { "ColorNormalTitleBarText", &clrInactiveTitleBarText, 1 },
    { "ColorNormalMenu", &clrNormalMenu, 1 },
    { "ColorActiveMenuItem", &clrActiveMenuItem, 1 },
    { "ColorActiveMenuItemText", &clrActiveMenuItemText, 1 },
    { "ColorNormalMenuItemText", &clrNormalMenuItemText, 1 },
    { "ColorDisabledMenuItemText", &clrDisabledMenuItemText, 1 },
    { "ColorMoveSizeStatus", &clrMoveSizeStatus, 1 },
    { "ColorMoveSizeStatusText", &clrMoveSizeStatusText, 1 },
    { "ColorQuickSwitch", &clrQuickSwitch, 1 },
    { "ColorQuickSwitchText", &clrQuickSwitchText, 1 },
    { "ColorDefaultTaskBar", &clrDefaultTaskBar, 1 },
    { "ColorNormalTaskBarApp", &clrNormalTaskBarApp, 1 },
    { "ColorNormalTaskBarAppText", &clrNormalTaskBarAppText, 1 },
    { "ColorActiveTaskBarApp", &clrActiveTaskBarApp, 1 },
    { "ColorActiveTaskBarAppText", &clrActiveTaskBarAppText, 1 },
    { "ColorMinimizedTaskBarApp", &clrMinimizedTaskBarApp, 1 },
    { "ColorMinimizedTaskBarAppText", &clrMinimizedTaskBarAppText, 1 },
    { "ColorScrollBar", &clrScrollBar, 1 },
    { "ColorScrollBarArrow", &clrScrollBarArrow, 1 },
    { "ColorScrollBarSlider", &clrScrollBarSlider, 1 },
    { "ColorListBox", &clrListBox, 1 },
    { "ColorListBoxText", &clrListBoxText, 1 },
    { "ColorListBoxSelection", &clrListBoxSelected, 1 },
    { "ColorListBoxSelectionText", &clrListBoxSelectedText, 1 },
    { "ColorToolTip", &clrToolTip, 1 },
    { "ColorToolTipText", &clrToolTipText, 1 },
    { "ColorClock", &clrClock, 1 },
    { "ColorClockText", &clrClockText, 1 },
    { "DesktopBackgroundColor", &DesktopBackgroundColor, 1 },
    { "DesktopBackgroundImage", &DesktopBackgroundPixmap, 1 }
};

#define ACOUNT(x) (sizeof(x)/sizeof(x[0]))
#endif

#undef XIV
#undef XSV
