/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"
#include <dirent.h>

void findThemes(const char *path, YMenu *container) {
    DIR *dir;
    int nlen, plen = strlen(path);
    const char *tname = "/default.theme";
    char *npath;

    if ((dir = opendir(path)) != NULL) {
        struct dirent *de;

        while ((de = readdir(dir)) != NULL) {
            nlen = plen + 1 + strlen(de->d_name) + 1 + strlen(tname);
            npath = (char *)MALLOC(nlen);

            if (npath) {
                strcpy(npath, path);
                if (plen == 0 || npath[plen - 1] != '/') {
                    strcpy(npath + plen, "/");
                    strcpy(npath + plen + 1, de->d_name);
                    plen++;
                } else {
                    strcpy(npath + plen, de->d_name);
                }
                strcat(npath, tname);

                if (access(npath, R_OK) == 0) {
                    char **args = (char **)malloc(4 * sizeof(char *));
                    if (args) {
                        args[0] = strdup("icewm"EXEEXT);
                        args[1] = strdup("-t");
                        args[2] = strdup(npath + plen);
                        args[3] = 0;
                        if (args[0] && args[1] && args[2]) {
                            if (addProgram("icewm"EXEEXT, "icewm"EXEEXT, args) == 1)
                                container->addItem(de->d_name, -1, "", cmdRestart, (void *)(progCount - 1));
                        }
                    }
                }
                free(npath);
            }
        }
        closedir(dir);
    }
}
