/*
 * Copyright (C) 1997 and 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLER
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: postscript.c,v 1.2 1998/08/26 05:29:57 itojun Exp $
 */

#include "mgp.h"

int
ps_boundingbox(fname, px1, py1, px2, py2)
	char *fname;
	int *px1;
	int *py1;
	int *px2;
	int *py2;
{
	FILE *epsfp;
	char buf[BUFSIZ];
	int i;
	int x1, y1, x2, y2;
#define SCANLINES	10	/*XXX*/

	epsfp = NULL;
	epsfp = fopen(fname, "r");
	if (!epsfp)
		goto fail;

	/* magic number */
	if (fgets(buf, sizeof(buf), epsfp) == NULL)
		goto fail;
	if (buf[0] != '%' || buf[1] != '!')
		goto fail;
	for (i = 0; i < SCANLINES; i++) {
		if (fgets(buf, sizeof(buf), epsfp) == NULL)
			goto fail;
		if (sscanf(buf, "%%%%BoundingBox: %d %d %d %d",
				&x1, &y1, &x2, &y2) == 4) {
			if (px1) *px1 = x1;
			if (py1) *py1 = y1;
			if (px2) *px2 = x2;
			if (py2) *py2 = y2;
			fclose(epsfp);
			return 0;
		}
	}

fail:
	if (epsfp)
		fclose(epsfp);
	return -1;
}
