/* ------------------------------------------------------------------------- */
/* i2c_priv.h -- local definitions for the various modules		     */
/* ------------------------------------------------------------------------- */

#ifndef I2C_PRIV_H
#define I2C_PRIV_H 1

#include <linux/fs.h>
#include "i2c.h"

extern struct i2c_algorithm algo_illeg;		/* dummy, illegal	*/


/* 
 * private information for each open file:
 */ 
struct i2c_data {
	int magic;		/* i2c's magic number			*/
	char address;		/* address slave chip			*/
        char ownadr;            /* interface i2c-address		*/
	unsigned int  flags;	/* local flags field			*/
	int writelength;	/* bytes to write before read		*/
	char buf[I2C_BUFFER_SIZE];/* write buffer			*/
};

				/* the local flags:			*/
#define F_LNG0	0x00		/* 10 bit address group 0		*/
#define F_LNG1	0x01		/* 10 bit address group 1		*/
#define F_LNG2	0x02		/* 10 bit address group 2		*/
#define F_LNG3	0x03		/* 10 bit address group 3		*/
#define F_LONG	0x04		/* enable 10 bit addressing		*/
#define F_INIT	0x80		/* structure has been initialized	*/



#define	BASE	i2c_table[(minor)].base	/* hardware base port		*/




/* --- Defines for PCF adapters ---------------------------------------	*/
#if (PCFADAPS)

extern int alg_pcf_init(void);	/* Init procedure for algorithm module	*/

# if ( PCFADAPS > 1 )
/*
 * ditto for PCF 8584 based interfaces:
 */
struct i2c_pcf_opns {
	/*to be defined... */
	int  (*pcf_read)	(int minor, int adr);
 	void (*pcf_write)	(int minor, int adr,char data);
 	int  (*pcf_init)	(int minor);
	void (*pcf_exit)	(int minor);
};
# else

extern	int  pcf_read	(int minor, int adr);
extern	void pcf_write	(int minor, int adr,char data);
extern	int  pcf_init	(int minor);
extern	void pcf_exit	(int minor);
#endif
			/* some convenience defines: */
# define pcfInt(cmd)	(i2c_table[minor].irq>0)? (cmd)|PCF_ENI : (cmd)
# define cmd(data)	pcf_write(minor,1,pcfInt(data))
# define dta(data)	pcf_write(minor,0,(data))
# define stat()		pcf_read(minor,1)
# define recv()		pcf_read(minor,0)
#endif

#endif	/* - I2C_PRIV_H	-----------------------------------------------	*/







