// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: event.h,v 1.10 1998/06/21 03:25:03 jgg Exp $
/* ######################################################################
   
   Event - Defines all of the events
   
   Each external event that can enter a widget is defined here. This is
   basically Mouse and Keyboard.
   
   A keyboard event is encoded into a structure containing an extended
   keycode and a unicode key value. This allows the specification of a 
   large number of different keys. To the client of the library all keys
   appear to be unicode and all drawn text is in UTF-8 (8 bit wide 
   character encoding).

   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_EVENT_H
#define DEITY_EVENT_H

#include <deity/graphics.h>

struct MouseEvent
{
   // Mouse Events (Type)
   enum TypeFlags
   {
      Motion = (1 << 0),
      ButtonUp = (1 << 1),
      ButtonDn = (1 << 2),
      Click = (1 << 3),
      Drag = (1 << 4)
   };

   // Button 
   enum ButtonMask
   {
      Select = (1 << 0),  // Left button
      Aux = (1 << 1),     // Middle button
      Menu = (1 << 2)    // Right button
   };
   
   unsigned long Type;
   Point Pos;
   unsigned char Button;
   unsigned char Clicks;
   unsigned long ButtonState;
   
   inline bool IsUp() const {return (Type & ButtonUp) == ButtonUp;};
   inline bool IsDn() const {return (Type & ButtonDn) == ButtonDn;};
   inline bool IsClick() const {return (Type & Click) == Click;};
   inline bool IsMotion() const {return (Type & Motion) == Motion;};
   inline bool IsDrag() const {return (Type & Drag) == Drag;};
   inline bool IsButtonDn(ButtonMask Button) const {return (ButtonState & Button) == (unsigned)Button;};
      
   MouseEvent();
};
ostream &operator << (ostream &stream,const MouseEvent &E);

// Keyboard events. 
struct KeyEvent
{
   enum SpecialKey
   {
      None = 0, Up, Down, Enter, Left,Right, PgUp, PgDown, Home, End, 
      Delete, Backspace, Insert
   };
   
   enum Mods {LShift = (1 << 0), RShift = (1 << 1),
              LControl = (1 << 2), RControl = (1 << 3),
              LAlt = (1 << 3), RAlt = (1 << 4)};
   
   unsigned int Modifiers;
   SpecialKey Extended;
   unsigned long Key;             // This is a 32bit unicode character
   
   inline bool IsExtended() const {return Extended != None;};
   inline bool IsPrintable() const {return Key != 0;};
      
   KeyEvent();
};
ostream &operator << (ostream &stream,const KeyEvent &E);

#endif
