// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: controlcache.cc,v 1.3 1998/03/03 03:55:28 jgg Exp $
/* ######################################################################

   ControlCache - Package control info cache.
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#include <pkglib/controlcache.h>
#include <pkglib/pkglist.h>
#include <pkglib/error.h>

#include <unistd.h>
#include <sys/stat.h>
#include <fstream.h>
									/*}}}*/

// ControlCache::pkgControlCache - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* This initializes the control info cache and checks all the package
   data files for consistancy with the cache. */
pkgControlCache::pkgControlCache(pkgCache &Cache) : Cache(Cache), Files(0)
{
   Files = new ifstream[Cache.Head().PackageFileCount];
   CtrlList = new CData[Cache.Head().VersionCount];
   Cached = 0;
   MaxCache = 50;
   
   for (PkgFileIterator F(Cache); F.end() == false; F++)
   {
      if (F.IsOk() == false)
      {
	 _error->Error("Packages file %s has changed.",F.FileName());
	 delete [] Files; 
	 Files = 0;
	 return;
      }

      Files[F->ID].open(F.FileName());
      if (!Files[F->ID])
      {
	 _error->Errno("ifstream::ifstream","Can't open package file %s.",F.FileName());
	 delete [] Files; 
	 Files = 0;
	 return;
      }
      char S[300];
      Files[F->ID] >> S;
   }
}
									/*}}}*/
// ControlCache::~pkgControlCache - Destructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
pkgControlCache::~pkgControlCache()
{
   delete [] Files;
   delete [] CtrlList;
}
									/*}}}*/
// ControlCache::operator [] - Lookup a version				/*{{{*/
// ---------------------------------------------------------------------
/* */
pkgSPkgCtrlInfo pkgControlCache::operator [](const VerIterator &Ver)
{
   // Hasnt been inited
   if (Files == 0 || Ver.end() == true)
      return pkgSPkgCtrlInfo();
   
   // In cache
   if (CtrlList[Ver->ID].Info.isNull() == false)
       return CtrlList[Ver->ID].Info;
   
   // Cache overflow
   if (Cached >= MaxCache)
      Dump();
   
   // Read the control info
   pkgTextElmReader Reader(Files[Ver.File()->ID],Ver.File().FileName());
   Reader.Seek(0,Ver->Offset);
   Reader.Read(CtrlList[Ver->ID].Info);
   CtrlList[Ver->ID].LastHit = clock();

   Cached++;
   return CtrlList[Ver->ID].Info;
}
									/*}}}*/
// ControlCache::Dump - Remove the last used item from the cache	/*{{{*/
// ---------------------------------------------------------------------
/* This removes the item with the lowest time from the cache. */
void pkgControlCache::Dump()
{
   CData *Hit = 0;
   for (CData *I = CtrlList; I != CtrlList + Cache.Head().VersionCount; I++)
   {
      if (I->Info.isNull() == true)
	 continue;
      if (Hit == 0)
	 Hit = I;
      if (I->LastHit < Hit->LastHit)
	 Hit = I;
   }
   
   if (Hit != 0 && Hit->Info.isNull() == false)
   {
      Cached--;
      Hit->Info.Delete();
   }
}
									/*}}}*/

