//*****************************************************************************
//
//	$Id: ptrfuncs.h,v 1.1 1997/05/05 14:09:06 bcwhite Exp $
//
//	Pointer Functions -- function definitions (for preprocessor use)
//
//	Written By:  Brian C. White
//
//*****************************************************************************
//
//	Since many smart pointers are derived and define functions to deal with
//	structures ending with a variable size array, these macros are provided
//	to automatically generate those functions.  Using these ensure correctness
//	and simplifies adding new features
//
//	In order for these sizing functions to work, there must be a field named
//	"size", preferrably a 32-bit unsigned integer.
//
//*****************************************************************************



#ifndef _ptrfuncs_h
#define _ptrfuncs_h


//	NEWSLOTS(Type, Field)
//	SLOTCOUNT(Type, Field)
//	RESIZESLOTS(Type, Field)
//	COMPACTSLOTS(Type, Field, TestField, EmptyVal)



//*****************************************************************************
//
//	Allocate memory for a structure with 'n' slots in it.
//
#define	NEWSLOTS(Type, Field) \
	void SPtr<Type>::newSlots(uint number) \
	{																		\
		size_t	newsize;													\
																			\
		newsize = sizeof(Type) - sizeof((*this)-> ## Field)					\
					  + number * sizeof((*this)-> ## Field ## [0]);			\
		malloc(newsize);													\
		Construct((Type*)Ptr);												\
		(*this)->Size = newsize;											\
	}


//*****************************************************************************
//
//	Calculate how many slots exist in the structure.
//
#define SLOTCOUNT(Type, Field) \
	uint SPtr<Type>::slotCount(void) \
	{																		\
		return( ((*this)->Size - sizeof(Type) + sizeof((*this)-> ## Field))	\
				/ sizeof((*this)-> ## Field ## [0]) );						\
	}


//*****************************************************************************
//
//	Change the number of slots in the structure.
//
#define RESIZESLOTS(Type, Field) \
	void SPtr<Type>::resizeSlots(uint number) \
	{																		\
		size_t	newsize;													\
																			\
		newsize = sizeof(Type) - sizeof((*this)-> ## Field)					\
					  + number * sizeof((*this)-> ## Field ## [0]);			\
																			\
		if (newsize > (*this)->Size) resize((*this)->Size,newsize);			\
		(*this)->Size = newsize;											\
	}


//*****************************************************************************
//
//	Compact the slots and return the number of used slots.
//
#define COMPACTSLOTS(Type, Field, TestField, EmptyVal) \
	uint SPtr<Type>::compactSlots(void) \
	{																		\
		uint	i,j,max;													\
																			\
		max = slotCount();													\
		j   = 0;															\
																			\
		for (i=0; i<max; i++) {												\
			if ((*this)-> ## Field ## [i] ## TestField != EmptyVal) {		\
				if (i != j) {												\
					(*this)-> ## Field ## [j]=(*this)-> ## Field ## [i];	\
				}															\
				j++;														\
			}																\
		}																	\
																			\
		for (i=j; i<max; i++) {												\
			(*this)-> ## Field ## [i] ## TestField = EmptyVal;				\
		}																	\
																			\
		setPFlag(PTRF_CHANGED);												\
		return(j);															\
	}


//*****************************************************************************

#endif
