// -*- mode: cpp; mode: fold -*-
#include <iostream.h>

#include <pkglib/error.h>
#include <pkglib/pkgcache.h>

bool Dump(string Name)
{
   pkgCache Cache(Name,true,true);
   if (_error->PendingError() == true) return false;
   
   pkgCache::Header &Head = Cache.Head();
   
   cout << "Signature " << hex << Head.Signature << dec << endl;
   cout << "Version " << Head.MajorVersion << '.' << Head.MinorVersion << endl;
   cout << "Dirty " << Head.Dirty << endl;

   #define Say(x) cout << #x << " = " << x << endl;
   cout << endl << "Sizes:" << endl;
   Say(Head.HeaderSz);
   Say(Head.PackageSz);
   Say(Head.PackageFileSz);
   Say(Head.VersionSz);
   Say(Head.DependencySz);
   Say(Head.ProvidesSz);
   
   cout << endl << "Counts:" << endl;
   Say(Head.PackageCount);
   Say(Head.VersionCount);
   Say(Head.DependsCount);
   
   cout << endl << "Package dump:" << endl;
   for (pkgCache::PkgIterator I = Cache.PkgBegin(); I.end() == false; I++)
   {
      cout << I.Name() << '(' << I.Section() << ')';
      pkgCache::PrvIterator P = I.ProvidesList();
      if (P.end() == false)
      {
	 cout << " aka ";
	 for (;P.end() == false; P++)
	    cout << P.OwnerPkg().Name() << '(' << P.OwnerPkg().Section() << "), ";
      }
      cout << endl;
   }   
}

int main(int argc,char *argv[])
{
   if (argc < 2)
      cerr << "Need a cache filename" << endl;
   else
      Dump(argv[1]);
   
   // Print any errors or warnings found during parsing
   _error->DumpErrors();
   return 0;
}
