static char qmaster_rcsid[]="$Id: qmaster.c,v 1.1.1.1 1997/04/10 15:10:35 green Exp $";

/*----------------------------------------------------
 * qmaster.c Tom Green Mon Jan 31 10:43:11 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: qmaster.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.15  1996/11/20 23:05:15  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.14  1996/06/27  01:56:17  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.13  1996/03/22  04:21:47  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.12  1996/03/21  20:46:14  nrl
 * adding new utilities and moved qidle to mainline code
 *
 * Revision 3.11  1996/03/14  03:16:55  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.10  1995/11/03  16:50:01  nrl
 * Added (char *) cast to setsockopt to avoid a warning message during compile
 *
 * Revision 3.9  1995/06/21  17:02:05  nrl
 * fixed bad syntax on enidf statemenets
 *
 * Revision 3.8  1995/05/29  18:09:03  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.7  1995/03/05  03:47:53  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.6  1995/02/26  03:32:23  nrl
 * Added error checling on qmaster checkin
 *
 * Revision 3.5  1995/02/23  23:14:03  nrl
 * Cleaned up some dangling pointers which were causing memory
 * corruption.
 *
 * Revision 3.4  1995/02/22  14:29:53  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.3  1995/02/09  22:44:15  nrl
 * Added "-mq" modify queue option
 *
 * Revision 3.2  1995/01/17  16:32:13  nrl
 * completed mailer feature
 *
 * Revision 3.1  1994/04/01  02:59:38  green
 * added "qalter" support
 *
 * Revision 3.0  1994/03/07  04:15:18  green
 * 3.0 freeze
 *
 * Revision 1.8  1994/03/01  19:23:44  green
 * removed "test" from the default dependancy list in Makefile.proto.
 *
 * changed dqs_show_all_cofigurations() to dqs_show_all_configurations()
 * in dqs_execd.c, qmaster.c and dqs_utility.c.
 *
 * fixed the broken comment exclusion feature in dqs_resolve.c.
 *
 * fixed bug in me.default_cell in dqs_setup.c where conf_file
 * default_cell was not updating me.default_cell.
 *
 * getenv(DQS_CELL) mved out of dqs_getme() into dqs_setup()
 * to allow dqs_getme() to be called on forks.
 *
 * remade func.h.
 *
 * pulled garbage out of test.c.
 *
 * added syntax instructions to resolve_file
 *
 * Revision 1.7  1994/02/25  23:13:28  green
 * added "PID_FILE" to def.h to log process id.
 *
 * modified dqs_execd.c and qmaster.c to log pids to a file
 *
 * added dqs_log_pid() to dqs_utility.c
 *
 * remade func.h
 *
 * forced insertion of "green" into Man_head  -- this needs to be removed
 * and a def in dqs.h if running as non-root.
 *
 * Revision 1.6  1994/02/24  18:11:39  green
 * added dqs_show_all_cofigurations() to dqs_execd.c an qmaster.c
 *
 * modified dqs_execd.c and dqs_load_avg.c to use me.default_cell rather than
 * conf.default_cell
 *
 * previous message about errant pointer reference was incorrect.
 * dqs_sig_handlers.c put back like it was previously
 *
 * there was however a point problem with dusage->master in dqs_setup.c.
 *
 * added dqs_show_all_cofigurations() to dqs_utility.c
 *
 * remade func.h
 *
 * activated the "-cell cell_name" option for dqs_execd in globals.h
 *
 * changed fscanf() to fgets() in qsub.c to fix problems on SV machines
 * and to avoid byte-stuffing problems.
 *
 * Revision 1.5  1994/02/17  17:38:24  green
 * moved dqs_daemonize() out of dqs_setup_dqs_execd() and dqs_setup_qmaster()
 * and into dqs_execd.c and qmaster.c respectively to allow the "-passwd"
 * and "-verify" options to function properly.
 *
 * Revision 1.4  1994/02/17  14:49:14  green
 * added MAX_KLOG_TIME to def.h
 *
 * added some strategic dqs_set_coresize_2_0() as CYAs
 *
 * nuked some dqs_set_coresize_back_normal()
 *
 * dinked with ALRM handlers for "robustness"
 *
 * NOTE: HPUX does not support core limit size --- sad...
 *
 * Revision 1.3  1994/02/17  14:15:03  green
 * yanked the sleep out of dqs_reauth_job() and placed in qmaster,
 * dqs_execd and dqs_exec_job() such that the sleep only occurs at
 * startup.  This minimizes "re-authing" overhead.
 *
 * The AFS reauthing will have to be rewritten anyway since AFS
 * behaves differently on different platforms.(eg: requires reauthing
 * process to be of the same pgroup on "non-AIX" platforms. (UGH! a
 * sheepherder process being required...)
 *
 * Revision 1.2  1994/02/09  19:48:22  green
 * syncing source with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:51  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/**********************************************************************/

main(argc, argv,envp)
int argc;
char **argv;
char **envp;

{
     
     int on = 1;
     int sfd;
     int sfd0;
     int fromlen;
     string str;
     struct servent *sp;
     struct sockaddr_in from;
     struct sockaddr_in s_in;
     dqs_list_type listel;
     dqs_list_type *listel_ptr;   
     dqs_list_type  *argv_list=(dqs_list_type *) NULL;
     dqs_list_type *tmp_lp;
     
     DENTER_MAIN((DQS_EVENT,"qmaster"));
     dqs_setup(QMASTER,argv[0]);
     argv_list=dqs_args2list(++argv,argc-1);
     options=dqs_parse_job(argv_list,envp);
     if (!options)
     {
	  ERROR((DQS_EVENT,"DQS_ERROR_0557 error: parsing options"));
	  DEXITE;
	  exit(-1);
     }

     dqs_get_passwd_info(options);

     if (options->verify)
     {
	  dqs_show_all_configurations();
	  DEXIT;
          exit(0);
     }

     dqs_daemonize();  

     if (dqs_reauth(options))
     sleep(MAX_KLOG_TIME); /* UGH!  I know - I know! */

     dqs_setup_sig_handlers();
     
     /***** set up socket *****/
     
     if(!(sp = getservbyname(conf.qmaster_service, "tcp"))) {
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0558 %s: Bad service?",conf.qmaster_service));
	  abort();
     }
     
     if ((sfd0 = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0559 socket creation error"));
	  abort();
     }
     
     setsockopt(sfd0, SOL_SOCKET, SO_REUSEADDR,(char *) &on, sizeof(on));
     s_in.sin_family =  AF_INET;
     s_in.sin_addr.s_addr=htonl(INADDR_ANY);
     s_in.sin_port = sp->s_port;
     if (bind(sfd0,(struct sockaddr *) &s_in, sizeof(s_in))) {
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0560 bind failure %d",errno));
	  abort();
     }

     dqs_log_pid();
     
#if __hpux
     listen(sfd0,20);
#else
     
#if (defined(sun) || defined(solaris) || defined(SOLARIS23) || defined(SOLARIS24) )
     listen(sfd0,5);
#else
     listen(sfd0,10); 
#endif
#endif

     tmp_lp = Job_head;
     while (tmp_lp) {
        tmp_lp->int0 = 0;
        tmp_lp = tmp_lp->next;
     }    
     fromlen = sizeof(from);
     
     /***** MAIN LOOP *****/
     while(TRUE) {

	  dqs_ck_to_do_list();

          if (dead_children)
          dqs_reap_children();

	  DPRINTF((DQS_EVENT,
		   "******************************EPOCH***************************************"));

	  (void *)dqs_schedule((dqs_job_type *)NULL);

          if (shut_me_down)
          dqs_shutdown();

	  bzero((char *)&listel,sizeof(listel));
	  if ((sfd = accept(sfd0,(struct sockaddr *) &from, &fromlen)) < 0) {
	       if (errno = EINTR) /* yea, I see it, leave it! */
	       continue;
	       ERROR((DQS_EVENT,"DQS_ERROR_0561 accept error\n"));
	  }
	  
	  if (dqs_trusted_host(sfd))
	  {
	       bzero((char *)&listel,sizeof(listel));
	       listel.status=DQS_NAK;
	       listel.str0=dqs_string_insert(NULL,
			   "error: you are not a DQS trusted host");
	       (void) dqs_send_list(NULL,NULL,sfd,&listel);
	       FREE(listel.str0);
	       dqs_close_sfd(sfd);
	       continue;
	  }
	  
	  if (dqs_get_list(sfd,&listel_ptr))
	  {
               dqs_close_sfd(sfd);
	       DPRINTF((DQS_EVENT,"lost connection - unable to obtain list"));
	       continue;
	  }
	  
	  switch(listel_ptr->who) 
	  {
             case QALTER:
               dqs_c_qalter(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

	     case QCONF:
	       dqs_c_qconf(sfd,&listel_ptr);
	       dqs_close_sfd(sfd);
	       break;

             case DQS_EXECD:
               dqs_c_dqs_execd(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

             case QDEL:
               dqs_c_qdel(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

             case QHOLD:
               dqs_c_qhold(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

             case QIDLE:
               dqs_c_qidle(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

             case QMOD:
               dqs_c_qmod(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

             case QMOVE:
               dqs_c_qmove(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

             case QRLS:
               dqs_c_qrls(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;
               
             case QSUB:
               dqs_c_qsub(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;
	       
             case QSTAT:
               dqs_c_qstat(sfd,&listel_ptr);
               dqs_close_sfd(sfd);
               break;

	     default:
	       sprintf(str,"error: unknown list type %d",listel_ptr->type);
	       INFO((DQS_EVENT,"DQS_ERROR_0562 %s",str));
               listel.str0=dqs_string_insert(NULL,str);
               (void) dqs_send_list(NULL,NULL,sfd,&listel);
               FREE(listel.str0);
               dqs_close_sfd(sfd);
	       break;
	  }
	  
     } 
     
} 

