static char shell_rcsid[]="shell.c,v 1.2 1994/11/28 16:56:18 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  shell.c,v
 * Revision 1.2  1994/11/28  16:56:18  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           shell_popup;
static Widget           widget_shellrc;
static Widget           widget_shelllabel;
static Widget           widget_shellframe;
static Widget           widget_shellmenu;
static Widget           widget_shellmain;
static Widget           widget_shellexec;
static Widget           widget_shellclear;
static Widget           widget_shellclose;
static Widget           widget_shellseparator;
static Widget           widget_shellopt;

struct optionstruct shellmenu[]={
  0,"Command",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_shellexec - Activate callback for exec
 */
XtCallbackProc pb_shellexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  char            command[MAX_STRING_SIZE];
  char            *ptr;


  ptr=QmonTextGetString(shellmenu[0].widgetid);
  sprintf(command,"%s &",ptr);
  execit(command);
}


/***********************************************************
 * pb_shellclear - Activate callback for clear
 */
XtCallbackProc pb_shellclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(shellmenu);
}


/***********************************************************
 * pb_shellclose - Activate callback for close
 */

XtCallbackProc pb_shellclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_shell_dialog - Create widgets used for the shell menu
 */
int create_shell_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        shell_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  shell_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  shell_form = XtCreateManagedWidget("form", formWidgetClass, shell_popup,args,
ii);


  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_shelllabel=
        XtCreateManagedWidget("Shell",labelWidgetClass,shell_form,args,ii);


  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_shelllabel); ii++;
  widget_shellmain=XtCreateManagedWidget("box",formWidgetClass,shell_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_shellmain,NULL,"Exec",(XtCallbackProc)pb_shellexec,NULL);
 clear=QmonAddButtonN(widget_shellmain,exec,"Clear",(XtCallbackProc)pb_shellclear,NULL);
 close=QmonAddButtonN(widget_shellmain,clear,"Close",(XtCallbackProc)pb_shellclose,NULL);

  widget_shellopt=createmenuoptions(shell_form,widget_shellmain,shellmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_shell - Open the shell menu
 */
int openwidget_shell()
{
   XtPopup(shell_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_shell - Close the shell menu
 */
int closewidget_shell()
{
  XtPopdown(shell_popup);
}
